/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.impl;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.ConfigurationInfoProvider;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.configurations.TargetAwareRunProfile;
import com.intellij.execution.configurations.UnknownRunConfiguration;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerAndConfigurationSettingsImpl
implements JDOMExternalizable,
Cloneable,
RunnerAndConfigurationSettings,
Comparable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.impl.RunnerAndConfigurationSettings");
    @NonNls
    private static final String RUNNER_ID = "RunnerId";
    private static final Comparator<Element> RUNNER_COMPARATOR = (o1, o2) -> {
        String attributeValue1 = o1.getAttributeValue(RUNNER_ID);
        if (attributeValue1 == null) {
            return 1;
        }
        return StringUtil.compare((String)attributeValue1, (String)o2.getAttributeValue(RUNNER_ID), (boolean)false);
    };
    @NonNls
    private static final String CONFIGURATION_TYPE_ATTRIBUTE = "type";
    @NonNls
    private static final String FACTORY_NAME_ATTRIBUTE = "factoryName";
    @NonNls
    private static final String FOLDER_NAME = "folderName";
    @NonNls
    static final String TEMPLATE_FLAG_ATTRIBUTE = "default";
    @NonNls
    public static final String NAME_ATTR = "name";
    @NonNls
    protected static final String DUMMY_ELEMENT_NAME = "dummy";
    @NonNls
    private static final String TEMPORARY_ATTRIBUTE = "temporary";
    @NonNls
    private static final String EDIT_BEFORE_RUN = "editBeforeRun";
    @NonNls
    private static final String ACTIVATE_TOOLWINDOW_BEFORE_RUN = "activateToolWindowBeforeRun";
    @NonNls
    public static final String SINGLETON = "singleton";
    @NonNls
    private static final String TEMP_CONFIGURATION = "tempConfiguration";
    private final RunManagerImpl myManager;
    private RunConfiguration myConfiguration;
    private boolean myIsTemplate;
    private final RunnerItem<RunnerSettings> myRunnerSettings = new RunnerItem<RunnerSettings>("RunnerSettings"){

        @Override
        protected RunnerSettings createSettings(@NotNull ProgramRunner runner) {
            return runner.createConfigurationData((ConfigurationInfoProvider)new InfoProvider(runner));
        }
    };
    private final RunnerItem<ConfigurationPerRunnerSettings> myConfigurationPerRunnerSettings = new RunnerItem<ConfigurationPerRunnerSettings>("ConfigurationWrapper"){

        @Override
        protected ConfigurationPerRunnerSettings createSettings(@NotNull ProgramRunner runner) {
            return RunnerAndConfigurationSettingsImpl.this.myConfiguration.createRunnerSettings((ConfigurationInfoProvider)new InfoProvider(runner));
        }
    };
    private boolean myTemporary;
    private boolean myEditBeforeRun;
    private boolean myActivateToolWindowBeforeRun = true;
    private boolean mySingleton;
    private boolean myWasSingletonSpecifiedExplicitly;
    private String myFolderName;

    public RunnerAndConfigurationSettingsImpl(RunManagerImpl manager) {
        this.myManager = manager;
    }

    public RunnerAndConfigurationSettingsImpl(RunManagerImpl manager, @NotNull RunConfiguration configuration, boolean isTemplate) {
        this.myManager = manager;
        this.myConfiguration = configuration;
        this.myIsTemplate = isTemplate;
    }

    @Nullable
    public ConfigurationFactory getFactory() {
        return this.myConfiguration == null ? null : this.myConfiguration.getFactory();
    }

    public boolean isTemplate() {
        return this.myIsTemplate;
    }

    public boolean isTemporary() {
        return this.myTemporary;
    }

    public void setTemporary(boolean temporary) {
        this.myTemporary = temporary;
    }

    public RunConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    public Factory<RunnerAndConfigurationSettings> createFactory() {
        return () -> {
            RunConfiguration configuration = this.myConfiguration.getFactory().createConfiguration(ExecutionBundle.message((String)"default.run.configuration.name", (Object[])new Object[0]), this.myConfiguration);
            return new RunnerAndConfigurationSettingsImpl(this.myManager, configuration, false);
        };
    }

    public void setName(String name) {
        this.myConfiguration.setName(name);
    }

    public String getName() {
        return this.myConfiguration.getName();
    }

    public String getUniqueID() {
        return this.myConfiguration.getType().getDisplayName() + "." + this.myConfiguration.getName() + (this.myConfiguration instanceof UnknownRunConfiguration ? Integer.valueOf(this.myConfiguration.getUniqueID()) : "");
    }

    public void setEditBeforeRun(boolean b) {
        this.myEditBeforeRun = b;
    }

    public boolean isEditBeforeRun() {
        return this.myEditBeforeRun;
    }

    public void setActivateToolWindowBeforeRun(boolean activate) {
        this.myActivateToolWindowBeforeRun = activate;
    }

    public boolean isActivateToolWindowBeforeRun() {
        return this.myActivateToolWindowBeforeRun;
    }

    public void setSingleton(boolean singleton) {
        this.mySingleton = singleton;
    }

    public boolean isSingleton() {
        return this.mySingleton;
    }

    public void setFolderName(@Nullable String folderName) {
        this.myFolderName = folderName;
    }

    @Nullable
    public String getFolderName() {
        return this.myFolderName;
    }

    @Nullable
    private ConfigurationFactory getFactory(Element element) {
        String typeName = element.getAttributeValue(CONFIGURATION_TYPE_ATTRIBUTE);
        String factoryName = element.getAttributeValue(FACTORY_NAME_ATTRIBUTE);
        return this.myManager.getFactory(typeName, factoryName, !this.myIsTemplate);
    }

    public void readExternal(Element element) {
        Module module2;
        this.myIsTemplate = Boolean.valueOf(element.getAttributeValue(TEMPLATE_FLAG_ATTRIBUTE));
        this.myTemporary = Boolean.valueOf(element.getAttributeValue(TEMPORARY_ATTRIBUTE)) != false || TEMP_CONFIGURATION.equals(element.getName());
        this.myEditBeforeRun = Boolean.valueOf(element.getAttributeValue(EDIT_BEFORE_RUN));
        String value2 = element.getAttributeValue(ACTIVATE_TOOLWINDOW_BEFORE_RUN);
        this.myActivateToolWindowBeforeRun = value2 == null || Boolean.valueOf(value2) != false;
        this.myFolderName = element.getAttributeValue(FOLDER_NAME);
        ConfigurationFactory factory = this.getFactory(element);
        if (factory == null) {
            return;
        }
        this.myWasSingletonSpecifiedExplicitly = false;
        if (this.myIsTemplate) {
            this.mySingleton = factory.isConfigurationSingletonByDefault();
        } else {
            String singletonStr = element.getAttributeValue(SINGLETON);
            if (StringUtil.isEmpty((String)singletonStr)) {
                this.mySingleton = factory.isConfigurationSingletonByDefault();
            } else {
                this.myWasSingletonSpecifiedExplicitly = true;
                this.mySingleton = Boolean.parseBoolean(singletonStr);
            }
        }
        this.myConfiguration = this.myIsTemplate ? this.myManager.getConfigurationTemplate(factory).getConfiguration() : this.myManager.doCreateConfiguration(element.getAttributeValue(NAME_ATTR), factory, false);
        PathMacroManager.getInstance((ComponentManager)this.myConfiguration.getProject()).expandPaths(element);
        if (this.myConfiguration instanceof ModuleBasedConfiguration && (module2 = ((ModuleBasedConfiguration)this.myConfiguration).getConfigurationModule().getModule()) != null) {
            PathMacroManager.getInstance((ComponentManager)module2).expandPaths(element);
        }
        this.myConfiguration.readExternal(element);
        this.myRunnerSettings.loadState(element);
        this.myConfigurationPerRunnerSettings.loadState(element);
    }

    public void writeExternal(Element element) {
        ConfigurationFactory factory = this.myConfiguration.getFactory();
        if (!(this.myConfiguration instanceof UnknownRunConfiguration)) {
            element.setAttribute(TEMPLATE_FLAG_ATTRIBUTE, String.valueOf(this.myIsTemplate));
            if (!this.myIsTemplate) {
                element.setAttribute(NAME_ATTR, this.myConfiguration.getName());
            }
            element.setAttribute(CONFIGURATION_TYPE_ATTRIBUTE, factory.getType().getId());
            element.setAttribute(FACTORY_NAME_ATTRIBUTE, factory.getName());
            if (this.myFolderName != null) {
                element.setAttribute(FOLDER_NAME, this.myFolderName);
            }
            if (this.isEditBeforeRun()) {
                element.setAttribute(EDIT_BEFORE_RUN, String.valueOf(true));
            }
            if (!this.isActivateToolWindowBeforeRun()) {
                element.setAttribute(ACTIVATE_TOOLWINDOW_BEFORE_RUN, String.valueOf(false));
            }
            if (this.myWasSingletonSpecifiedExplicitly || this.mySingleton != factory.isConfigurationSingletonByDefault()) {
                element.setAttribute(SINGLETON, String.valueOf(this.mySingleton));
            }
            if (this.myTemporary) {
                element.setAttribute(TEMPORARY_ATTRIBUTE, Boolean.toString(true));
            }
        }
        this.myConfiguration.writeExternal(element);
        if (!(this.myConfiguration instanceof UnknownRunConfiguration)) {
            this.myRunnerSettings.getState(element);
            this.myConfigurationPerRunnerSettings.getState(element);
        }
    }

    public void checkSettings() throws RuntimeConfigurationException {
        this.checkSettings(null);
    }

    public void checkSettings(@Nullable Executor executor) throws RuntimeConfigurationException {
        this.myConfiguration.checkConfiguration();
        if (this.myConfiguration instanceof RunConfigurationBase) {
            RunConfigurationBase runConfigurationBase = (RunConfigurationBase)this.myConfiguration;
            THashSet runners = new THashSet();
            runners.addAll(((RunnerItem)this.myRunnerSettings).settings.keySet());
            runners.addAll(((RunnerItem)this.myConfigurationPerRunnerSettings).settings.keySet());
            for (ProgramRunner runner : runners) {
                if (executor != null && !runner.canRun(executor.getId(), (RunProfile)this.myConfiguration)) continue;
                runConfigurationBase.checkRunnerSettings(runner, (RunnerSettings)((RunnerItem)this.myRunnerSettings).settings.get(runner), (ConfigurationPerRunnerSettings)((RunnerItem)this.myConfigurationPerRunnerSettings).settings.get(runner));
            }
            if (executor != null) {
                runConfigurationBase.checkSettingsBeforeRun();
            }
        }
    }

    public boolean canRunOn(@NotNull ExecutionTarget target) {
        if (this.myConfiguration instanceof TargetAwareRunProfile) {
            return ((TargetAwareRunProfile)this.myConfiguration).canRunOn(target);
        }
        return true;
    }

    public RunnerSettings getRunnerSettings(@NotNull ProgramRunner runner) {
        return this.myRunnerSettings.getOrCreateSettings(runner);
    }

    @Nullable
    public ConfigurationPerRunnerSettings getConfigurationSettings(@NotNull ProgramRunner runner) {
        return this.myConfigurationPerRunnerSettings.getOrCreateSettings(runner);
    }

    @Nullable
    public ConfigurationType getType() {
        return this.myConfiguration == null ? null : this.myConfiguration.getType();
    }

    public RunnerAndConfigurationSettings clone() {
        RunnerAndConfigurationSettingsImpl copy = new RunnerAndConfigurationSettingsImpl(this.myManager, this.myConfiguration.clone(), false);
        copy.importRunnerAndConfigurationSettings(this);
        return copy;
    }

    public void importRunnerAndConfigurationSettings(RunnerAndConfigurationSettingsImpl template) {
        this.importFromTemplate(template.myRunnerSettings, this.myRunnerSettings);
        this.importFromTemplate(template.myConfigurationPerRunnerSettings, this.myConfigurationPerRunnerSettings);
        this.setSingleton(template.isSingleton());
        this.setEditBeforeRun(template.isEditBeforeRun());
        this.setActivateToolWindowBeforeRun(template.isActivateToolWindowBeforeRun());
    }

    private <T> void importFromTemplate(@NotNull RunnerItem<T> templateItem, @NotNull RunnerItem<T> item) {
        for (ProgramRunner runner : ((RunnerItem)templateItem).settings.keySet()) {
            T data = item.createSettings(runner);
            ((RunnerItem)item).settings.put(runner, data);
            if (data == null) continue;
            Element temp = new Element(DUMMY_ELEMENT_NAME);
            Object templateSettings = ((RunnerItem)templateItem).settings.get(runner);
            if (templateSettings == null) continue;
            try {
                ((JDOMExternalizable)templateSettings).writeExternal(temp);
                ((JDOMExternalizable)data).readExternal(temp);
            }
            catch (InvalidDataException | WriteExternalException e) {
                LOG.error(e);
            }
        }
    }

    public int compareTo(@NotNull Object o) {
        if (o instanceof RunnerAndConfigurationSettings) {
            return this.getName().compareTo(((RunnerAndConfigurationSettings)o).getName());
        }
        return 0;
    }

    public String toString() {
        ConfigurationType type2 = this.getType();
        return (type2 != null ? type2.getDisplayName() + ": " : "") + (this.isTemplate() ? "<template>" : this.getName());
    }

    private class InfoProvider
    implements ConfigurationInfoProvider {
        private final ProgramRunner myRunner;

        public InfoProvider(ProgramRunner runner) {
            this.myRunner = runner;
        }

        public ProgramRunner getRunner() {
            return this.myRunner;
        }

        public RunConfiguration getConfiguration() {
            return RunnerAndConfigurationSettingsImpl.this.myConfiguration;
        }

        public RunnerSettings getRunnerSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getRunnerSettings(this.myRunner);
        }

        public ConfigurationPerRunnerSettings getConfigurationSettings() {
            return RunnerAndConfigurationSettingsImpl.this.getConfigurationSettings(this.myRunner);
        }
    }

    private abstract class RunnerItem<T> {
        private final Map<ProgramRunner, T> settings = new THashMap();
        private List<Element> unloadedSettings;
        private final Set<String> loadedIds = new THashSet();
        private final String childTagName;

        RunnerItem(String childTagName) {
            this.childTagName = childTagName;
        }

        public void loadState(@NotNull Element element) throws InvalidDataException {
            this.settings.clear();
            if (this.unloadedSettings != null) {
                this.unloadedSettings.clear();
            }
            this.loadedIds.clear();
            Iterator iterator = element.getChildren(this.childTagName).iterator();
            while (iterator.hasNext()) {
                Element state = (Element)iterator.next();
                ProgramRunner runner = this.findRunner(state.getAttributeValue(RunnerAndConfigurationSettingsImpl.RUNNER_ID));
                if (runner == null) {
                    iterator.remove();
                }
                this.add(state, runner, runner == null ? null : (T)this.createSettings(runner));
            }
        }

        private ProgramRunner findRunner(String runnerId) {
            List runnersById = ContainerUtil.filter((Object[])ProgramRunner.PROGRAM_RUNNER_EP.getExtensions(), runner -> Comparing.equal((String)runnerId, (String)runner.getRunnerId()));
            int runnersByIdCount = runnersById.size();
            if (runnersByIdCount == 0) {
                return null;
            }
            if (runnersByIdCount == 1) {
                return (ProgramRunner)ContainerUtil.getFirstItem((List)runnersById);
            }
            LOG.error("More than one runner found for ID: " + runnerId);
            for (Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
                for (ProgramRunner runner2 : runnersById) {
                    if (!runner2.canRun(executor.getId(), (RunProfile)RunnerAndConfigurationSettingsImpl.this.myConfiguration)) continue;
                    return runner2;
                }
            }
            return null;
        }

        public void getState(@NotNull Element element) throws WriteExternalException {
            SmartList runnerSettings = new SmartList();
            for (ProgramRunner runner : this.settings.keySet()) {
                T settings = this.settings.get(runner);
                boolean wasLoaded = this.loadedIds.contains(runner.getRunnerId());
                if (settings == null && !wasLoaded) continue;
                Element state = new Element(this.childTagName);
                if (settings != null) {
                    ((JDOMExternalizable)settings).writeExternal(state);
                }
                if (!wasLoaded && JDOMUtil.isEmpty((Element)state)) continue;
                state.setAttribute(RunnerAndConfigurationSettingsImpl.RUNNER_ID, runner.getRunnerId());
                runnerSettings.add(state);
            }
            if (this.unloadedSettings != null) {
                for (Element unloadedSetting : this.unloadedSettings) {
                    runnerSettings.add(unloadedSetting.clone());
                }
            }
            Collections.sort(runnerSettings, RUNNER_COMPARATOR);
            for (Element runnerSetting : runnerSettings) {
                element.addContent(runnerSetting);
            }
        }

        protected abstract T createSettings(@NotNull ProgramRunner var1);

        private void add(@NotNull Element state, @Nullable ProgramRunner runner, @Nullable T data) throws InvalidDataException {
            if (runner == null) {
                if (this.unloadedSettings == null) {
                    this.unloadedSettings = new SmartList();
                }
                this.unloadedSettings.add(state);
                return;
            }
            if (data != null) {
                ((JDOMExternalizable)data).readExternal(state);
            }
            this.settings.put(runner, data);
            this.loadedIds.add(runner.getRunnerId());
        }

        public T getOrCreateSettings(@NotNull ProgramRunner runner) {
            T result2 = this.settings.get(runner);
            if (result2 == null) {
                try {
                    result2 = this.createSettings(runner);
                    this.settings.put(runner, result2);
                }
                catch (AbstractMethodError ignored) {
                    LOG.error("Update failed for: " + RunnerAndConfigurationSettingsImpl.this.myConfiguration.getType().getDisplayName() + ", runner: " + runner.getRunnerId(), (Throwable)new ExtensionException(runner.getClass()));
                }
            }
            return result2;
        }
    }
}

