/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.JUnitRecognizer;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.SourceScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.testIntegration.JavaTestFramework;
import com.intellij.testIntegration.TestFramework;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JUnitUtil {
    @NonNls
    public static final String TESTCASE_CLASS = "junit.framework.TestCase";
    @NonNls
    private static final String TEST_INTERFACE = "junit.framework.Test";
    @NonNls
    private static final String TESTSUITE_CLASS = "junit.framework.TestSuite";
    @NonNls
    public static final String TEST_ANNOTATION = "org.junit.Test";
    @NonNls
    public static final String TEST5_PACKAGE_FQN = "org.junit.jupiter.api";
    @NonNls
    public static final String TEST5_ANNOTATION = "org.junit.jupiter.api.Test";
    @NonNls
    public static final String CUSTOM_TESTABLE_ANNOTATION = "org.junit.platform.commons.annotation.Testable";
    @NonNls
    public static final String TEST5_FACTORY_ANNOTATION = "org.junit.jupiter.api.TestFactory";
    @NonNls
    public static final String IGNORE_ANNOTATION = "org.junit.Ignore";
    @NonNls
    public static final String RUN_WITH = "org.junit.runner.RunWith";
    @NonNls
    public static final String DATA_POINT = "org.junit.experimental.theories.DataPoint";
    @NonNls
    public static final String SUITE_METHOD_NAME = "suite";
    public static final String BEFORE_ANNOTATION_NAME = "org.junit.Before";
    public static final String AFTER_ANNOTATION_NAME = "org.junit.After";
    public static final String BEFORE_EACH_ANNOTATION_NAME = "org.junit.jupiter.api.BeforeEach";
    public static final String AFTER_EACH_ANNOTATION_NAME = "org.junit.jupiter.api.AfterEach";
    public static final String PARAMETRIZED_PARAMETERS_ANNOTATION_NAME = "org.junit.runners.Parameterized.Parameters";
    public static final String PARAMETRIZED_PARAMETER_ANNOTATION_NAME = "org.junit.runners.Parameterized.Parameter";
    public static final String AFTER_CLASS_ANNOTATION_NAME = "org.junit.AfterClass";
    public static final String BEFORE_CLASS_ANNOTATION_NAME = "org.junit.BeforeClass";
    public static final String BEFORE_ALL_ANNOTATION_NAME = "org.junit.jupiter.api.BeforeAll";
    public static final String AFTER_ALL_ANNOTATION_NAME = "org.junit.jupiter.api.AfterAll";
    private static final Collection<String> TEST_ANNOTATIONS = Collections.unmodifiableList(Arrays.asList("org.junit.Test", "org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory"));
    public static final Collection<String> TEST5_ANNOTATIONS = Collections.unmodifiableList(Arrays.asList("org.junit.jupiter.api.Test", "org.junit.jupiter.api.TestFactory", "org.junit.platform.commons.annotation.Testable"));
    private static final List<String> INSTANCE_CONFIGS = Arrays.asList("org.junit.Before", "org.junit.After");
    private static final List<String> INSTANCE_5_CONFIGS = Arrays.asList("org.junit.jupiter.api.BeforeEach", "org.junit.jupiter.api.AfterEach");
    private static final List<String> STATIC_5_CONFIGS = Arrays.asList("org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll");
    private static final List<String> STATIC_CONFIGS = Arrays.asList("org.junit.BeforeClass", "org.junit.AfterClass", "org.junit.runners.Parameterized.Parameters");
    private static final Collection<String> CONFIGURATIONS_ANNOTATION_NAME = Collections.unmodifiableList(Arrays.asList("org.junit.experimental.theories.DataPoint", "org.junit.After", "org.junit.Before", "org.junit.AfterClass", "org.junit.BeforeClass", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"));
    @NonNls
    public static final String PARAMETERIZED_CLASS_NAME = "org.junit.runners.Parameterized";
    @NonNls
    public static final String SUITE_CLASS_NAME = "org.junit.runners.Suite";
    public static final String JUNIT5_NESTED = "org.junit.jupiter.api.Nested";

    public static boolean isSuiteMethod(@NotNull PsiMethod psiMethod) {
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (psiMethod.getParameterList().getParametersCount() > 0) {
            return false;
        }
        PsiType returnType = psiMethod.getReturnType();
        if (returnType == null || returnType instanceof PsiPrimitiveType) {
            return false;
        }
        return returnType.equalsToText(TEST_INTERFACE) || returnType.equalsToText(TESTSUITE_CLASS) || InheritanceUtil.isInheritor((PsiType)returnType, (String)TEST_INTERFACE);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location) {
        return JUnitUtil.isTestMethod(location, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean checkAbstract) {
        return JUnitUtil.isTestMethod(location, checkAbstract, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean checkAbstract, boolean checkRunWith) {
        return JUnitUtil.isTestMethod(location, checkAbstract, checkRunWith, true);
    }

    public static boolean isTestMethod(Location<? extends PsiMethod> location, boolean checkAbstract, boolean checkRunWith, boolean checkClass) {
        PsiClass testCaseClass;
        PsiAnnotation annotation;
        PsiClass aClass;
        PsiMethod psiMethod = (PsiMethod)location.getPsiElement();
        PsiClass psiClass = aClass = location instanceof MethodLocation ? ((MethodLocation)location).getContainingClass() : psiMethod.getContainingClass();
        if (checkClass && (aClass == null || !JUnitUtil.isTestClass(aClass, checkAbstract, true))) {
            return false;
        }
        if (JUnitUtil.isTestAnnotated(psiMethod)) {
            return true;
        }
        if (psiMethod.isConstructor()) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("public")) {
            return false;
        }
        if (psiMethod.hasModifierProperty("abstract")) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, CONFIGURATIONS_ANNOTATION_NAME, (boolean)false)) {
            return false;
        }
        if (checkClass && checkRunWith && (annotation = JUnitUtil.getRunWithAnnotation(aClass)) != null) {
            return !JUnitUtil.isParameterized(annotation);
        }
        if (psiMethod.getParameterList().getParametersCount() > 0) {
            return false;
        }
        if (psiMethod.hasModifierProperty("static")) {
            return false;
        }
        if (!psiMethod.getName().startsWith("test")) {
            return false;
        }
        if (checkClass && ((testCaseClass = JUnitUtil.getTestCaseClassOrNull(location)) == null || !psiMethod.getContainingClass().isInheritor(testCaseClass, true))) {
            return false;
        }
        return PsiType.VOID.equals((Object)psiMethod.getReturnType());
    }

    public static boolean isTestCaseInheritor(PsiClass aClass) {
        if (!aClass.isValid()) {
            return false;
        }
        Location location = PsiLocation.fromPsiElement((PsiElement)aClass);
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(location);
        return testCaseClass != null && aClass.isInheritor(testCaseClass, true);
    }

    public static boolean isTestClass(PsiClass psiClass) {
        return JUnitUtil.isTestClass(psiClass, true, true);
    }

    public static boolean isTestClass(@NotNull PsiClass psiClass, boolean checkAbstract, boolean checkForTestCaseInheritance) {
        String runnerName;
        PsiAnnotationMemberValue attributeValue;
        PsiAnnotation annotation;
        if (psiClass.getQualifiedName() == null) {
            return false;
        }
        if (JUnitUtil.isJUnit5((PsiElement)psiClass) && JUnitUtil.isJUnit5TestClass(psiClass, checkAbstract)) {
            return true;
        }
        PsiClass topLevelClass = (PsiClass)PsiTreeUtil.getTopmostParentOfType((PsiElement)psiClass, PsiClass.class);
        if (topLevelClass != null && (annotation = AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)topLevelClass, Collections.singleton(RUN_WITH))) != null && (attributeValue = annotation.findAttributeValue("value")) instanceof PsiClassObjectAccessExpression && !PARAMETERIZED_CLASS_NAME.equals(runnerName = ((PsiClassObjectAccessExpression)attributeValue).getOperand().getType().getCanonicalText()) && !SUITE_CLASS_NAME.equals(runnerName)) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (boolean)true)) {
            return true;
        }
        if (checkForTestCaseInheritance && JUnitUtil.isTestCaseInheritor(psiClass)) {
            return true;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)psiClass, () -> CachedValueProvider.Result.create((Object)JUnitUtil.hasTestOrSuiteMethods(psiClass), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}));
    }

    private static boolean hasTestOrSuiteMethods(@NotNull PsiClass psiClass) {
        for (PsiMethod psiMethod : psiClass.getAllMethods()) {
            if (JUnitUtil.isSuiteMethod(psiMethod)) {
                return true;
            }
            if (!JUnitUtil.isTestAnnotated(psiMethod)) continue;
            return true;
        }
        if (JUnitUtil.isJUnit5((PsiElement)psiClass)) {
            for (PsiMethod psiMethod : psiClass.getInnerClasses()) {
                for (PsiMethod method3 : psiMethod.getAllMethods()) {
                    if (!JUnitUtil.isTestAnnotated(method3)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isJUnit3TestClass(PsiClass clazz) {
        return JUnitUtil.isTestCaseInheritor(clazz);
    }

    public static boolean isJUnit4TestClass(PsiClass psiClass) {
        return JUnitUtil.isJUnit4TestClass(psiClass, true);
    }

    private static boolean isJUnit4TestClass(PsiClass psiClass, boolean checkAbstract) {
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)RUN_WITH, (boolean)true)) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)true, (boolean)checkAbstract)) {
            return false;
        }
        for (PsiMethod method2 : psiClass.getAllMethods()) {
            ProgressManager.checkCanceled();
            if (!JUnitUtil.isTestAnnotated(method2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isJUnit5TestClass(PsiClass psiClass, boolean checkAbstract) {
        PsiModifierList modifierList = psiClass.getModifierList();
        if (modifierList == null) {
            return false;
        }
        if (psiClass.getContainingClass() != null && AnnotationUtil.isAnnotated((PsiModifierListOwner)psiClass, (String)JUNIT5_NESTED, (boolean)false)) {
            return true;
        }
        if (MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiClass, Collections.singleton(CUSTOM_TESTABLE_ANNOTATION))) {
            return true;
        }
        if (!PsiClassUtil.isRunnableClass((PsiClass)psiClass, (boolean)false, (boolean)checkAbstract)) {
            return false;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
        if (module2 != null) {
            for (PsiMethod psiMethod : psiClass.getAllMethods()) {
                ProgressManager.checkCanceled();
                if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, TEST5_ANNOTATIONS)) continue;
                return true;
            }
            for (PsiMethod psiMethod : psiClass.getInnerClasses()) {
                if (!MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)psiMethod, Collections.singleton(JUNIT5_NESTED))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isJUnit5(@NotNull PsiElement element) {
        return JUnitUtil.isJUnit5(element.getResolveScope(), element.getProject());
    }

    public static boolean isJUnit5(GlobalSearchScope scope, Project project2) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project2);
        Condition foundCondition = aPackageName -> {
            PsiPackage aPackage = facade.findPackage(aPackageName);
            return aPackage != null && aPackage.getDirectories(scope).length > 0;
        };
        return foundCondition.value((Object)TEST5_PACKAGE_FQN);
    }

    public static boolean isTestAnnotated(PsiMethod method2) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)method2, (String)TEST_ANNOTATION, (boolean)false) || JUnitRecognizer.willBeAnnotatedAfterCompilation((PsiMethod)method2)) {
            return true;
        }
        return MetaAnnotationUtil.isMetaAnnotated((PsiModifierListOwner)method2, TEST5_ANNOTATIONS);
    }

    @Nullable
    private static PsiClass getTestCaseClassOrNull(Location<?> location) {
        Location ancestorOrSelf = location.getAncestorOrSelf(PsiClass.class);
        if (ancestorOrSelf == null) {
            return null;
        }
        PsiClass aClass = (PsiClass)ancestorOrSelf.getPsiElement();
        Module module2 = JavaExecutionUtil.findModule((PsiClass)aClass);
        if (module2 == null) {
            return null;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module2, (boolean)true);
        return JUnitUtil.getTestCaseClassOrNull(scope, module2.getProject());
    }

    public static PsiClass getTestCaseClass(Module module2) throws NoJUnitException {
        if (module2 == null) {
            throw new NoJUnitException();
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleRuntimeScope((Module)module2, (boolean)true);
        return JUnitUtil.getTestCaseClass(scope, module2.getProject());
    }

    public static PsiClass getTestCaseClass(SourceScope scope) throws NoJUnitException {
        if (scope == null) {
            throw new NoJUnitException();
        }
        return JUnitUtil.getTestCaseClass(scope.getLibrariesScope(), scope.getProject());
    }

    public static void checkTestCase(SourceScope scope, Project project2) throws NoJUnitException {
        if (scope == null) {
            throw new NoJUnitException();
        }
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project2).findPackage("junit.framework");
        if (aPackage == null || aPackage.getDirectories(scope.getLibrariesScope()).length == 0) {
            throw new NoJUnitException();
        }
    }

    private static PsiClass getTestCaseClass(GlobalSearchScope scope, Project project2) throws NoJUnitException {
        PsiClass testCaseClass = JUnitUtil.getTestCaseClassOrNull(scope, project2);
        if (testCaseClass == null) {
            throw new NoJUnitException(scope.getDisplayName());
        }
        return testCaseClass;
    }

    @Nullable
    private static PsiClass getTestCaseClassOrNull(GlobalSearchScope scope, Project project2) {
        return JavaPsiFacade.getInstance((Project)project2).findClass(TESTCASE_CLASS, scope);
    }

    public static boolean isTestMethodOrConfig(@NotNull PsiMethod psiMethod) {
        if (JUnitUtil.isTestMethod((Location<? extends PsiMethod>)PsiLocation.fromPsiElement((PsiElement)psiMethod), false)) {
            PsiClass containingClass = psiMethod.getContainingClass();
            assert (containingClass != null) : psiMethod + "; " + psiMethod.getClass() + "; " + psiMethod.getParent();
            if (containingClass.hasModifierProperty("abstract")) {
                boolean[] foundNonAbstractInheritor = new boolean[1];
                ClassInheritorsSearch.search((PsiClass)containingClass).forEach(psiClass -> {
                    if (!psiClass.hasModifierProperty("abstract")) {
                        foundNonAbstractInheritor[0] = true;
                        return false;
                    }
                    return true;
                });
                if (foundNonAbstractInheritor[0]) {
                    return true;
                }
            } else {
                return true;
            }
        }
        String name = psiMethod.getName();
        boolean isPublic = psiMethod.hasModifierProperty("public");
        if (!psiMethod.hasModifierProperty("abstract")) {
            if (isPublic && (SUITE_METHOD_NAME.equals(name) || "setUp".equals(name) || "tearDown".equals(name))) {
                return true;
            }
            if (psiMethod.hasModifierProperty("static")) {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, STATIC_CONFIGS)) {
                    return isPublic;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, STATIC_5_CONFIGS)) {
                    return true;
                }
            } else {
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, INSTANCE_CONFIGS)) {
                    return isPublic;
                }
                if (AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, INSTANCE_5_CONFIGS)) {
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public static PsiMethod findFirstTestMethod(PsiClass clazz) {
        PsiMethod testMethod = null;
        for (PsiMethod method2 : clazz.getMethods()) {
            if (!JUnitUtil.isTestMethod(MethodLocation.elementInClass(method2, clazz)) && !JUnitUtil.isSuiteMethod(method2)) continue;
            testMethod = method2;
            break;
        }
        return testMethod;
    }

    @Nullable
    public static PsiMethod findSuiteMethod(PsiClass clazz) {
        PsiMethod[] suiteMethods;
        for (PsiMethod method2 : suiteMethods = clazz.findMethodsByName(SUITE_METHOD_NAME, false)) {
            if (!JUnitUtil.isSuiteMethod(method2)) continue;
            return method2;
        }
        return null;
    }

    public static PsiAnnotation getRunWithAnnotation(PsiClass aClass) {
        return AnnotationUtil.findAnnotationInHierarchy((PsiModifierListOwner)aClass, Collections.singleton(RUN_WITH));
    }

    public static boolean isParameterized(PsiAnnotation annotation) {
        PsiAnnotationMemberValue value2 = annotation.findAttributeValue("value");
        if (value2 instanceof PsiClassObjectAccessExpression) {
            PsiTypeElement operand2 = ((PsiClassObjectAccessExpression)value2).getOperand();
            PsiClass psiClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)operand2.getType());
            return psiClass != null && PARAMETERIZED_CLASS_NAME.equals(psiClass.getQualifiedName());
        }
        return false;
    }

    public static PsiClass findPsiClass(String qualifiedName, Module module2, Project project2) {
        GlobalSearchScope scope = module2 == null ? GlobalSearchScope.projectScope((Project)project2) : GlobalSearchScope.moduleWithDependenciesScope((Module)module2);
        return JavaPsiFacade.getInstance((Project)project2).findClass(qualifiedName, scope);
    }

    public static PsiPackage getContainingPackage(@NotNull PsiClass psiClass) {
        PsiDirectory directory = psiClass.getContainingFile().getContainingDirectory();
        return directory == null ? null : JavaDirectoryService.getInstance().getPackage(directory);
    }

    public static PsiClass getTestClass(PsiElement element) {
        return JUnitUtil.getTestClass(PsiLocation.fromPsiElement((PsiElement)element));
    }

    public static PsiClass getTestClass(Location<?> location) {
        PsiClass[] classes2;
        Iterator iterator = location.getAncestors(PsiClass.class, false);
        while (iterator.hasNext()) {
            Location classLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestClass((PsiClass)classLocation.getPsiElement(), false, true)) continue;
            return (PsiClass)classLocation.getPsiElement();
        }
        PsiElement element = location.getPsiElement();
        if (element instanceof PsiClassOwner && (classes2 = ((PsiClassOwner)element).getClasses()).length == 1) {
            return classes2[0];
        }
        return null;
    }

    public static PsiMethod getTestMethod(PsiElement element) {
        return JUnitUtil.getTestMethod(element, true);
    }

    public static PsiMethod getTestMethod(PsiElement element, boolean checkAbstract) {
        return JUnitUtil.getTestMethod(element, checkAbstract, true);
    }

    public static PsiMethod getTestMethod(PsiElement element, boolean checkAbstract, boolean checkRunWith) {
        PsiManager manager = element.getManager();
        Location location = PsiLocation.fromPsiElement((Project)manager.getProject(), (PsiElement)element);
        Iterator iterator = location.getAncestors(PsiMethod.class, false);
        while (iterator.hasNext()) {
            Location methodLocation = (Location)iterator.next();
            if (!JUnitUtil.isTestMethod((Location<? extends PsiMethod>)methodLocation, checkAbstract, checkRunWith)) continue;
            return (PsiMethod)methodLocation.getPsiElement();
        }
        return null;
    }

    public static class NoJUnitException
    extends CantRunException {
        public NoJUnitException() {
            super(ExecutionBundle.message((String)"no.junit.error.message", (Object[])new Object[0]));
        }

        public NoJUnitException(String message2) {
            super(ExecutionBundle.message((String)"no.junit.in.scope.error.message", (Object[])new Object[]{message2}));
        }
    }

    public static class TestMethodFilter
    implements Condition<PsiMethod> {
        private final PsiClass myClass;
        private final JavaTestFramework framework;

        public TestMethodFilter(PsiClass aClass) {
            this.myClass = aClass;
            TestFramework framework = TestFrameworks.detectFramework((PsiClass)aClass);
            this.framework = framework instanceof JavaTestFramework ? (JavaTestFramework)framework : null;
        }

        public boolean value(PsiMethod method2) {
            return this.framework != null ? this.framework.isTestMethod(method2, this.myClass) : JUnitUtil.isTestMethod(MethodLocation.elementInClass(method2, this.myClass));
        }
    }
}

