/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import java.nio.charset.Charset;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ColoredProcessHandler
extends KillableProcessHandler
implements AnsiEscapeDecoder.ColoredTextAcceptor {
    private final AnsiEscapeDecoder myAnsiEscapeDecoder = new AnsiEscapeDecoder();
    private final List<AnsiEscapeDecoder.ColoredTextAcceptor> myColoredTextListeners = ContainerUtil.newArrayList();

    public ColoredProcessHandler(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        super(commandLine);
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process2, String commandLine) {
        super(process2, commandLine);
        this.setShouldKillProcessSoftly(false);
    }

    public ColoredProcessHandler(@NotNull Process process2, String commandLine, @NotNull Charset charset) {
        super(process2, commandLine, charset);
        this.setShouldKillProcessSoftly(false);
    }

    public final void notifyTextAvailable(String text, Key outputType) {
        this.myAnsiEscapeDecoder.escapeText(text, outputType, (AnsiEscapeDecoder.ColoredTextAcceptor)this);
    }

    public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
        this.textAvailable(text, attributes);
        this.notifyColoredListeners(text, attributes);
    }

    protected void notifyColoredListeners(String text, Key attributes) {
        for (AnsiEscapeDecoder.ColoredTextAcceptor listener2 : this.myColoredTextListeners) {
            listener2.coloredTextAvailable(text, attributes);
        }
    }

    public void addColoredTextListener(AnsiEscapeDecoder.ColoredTextAcceptor listener2) {
        this.myColoredTextListeners.add(listener2);
    }

    public void removeColoredTextListener(AnsiEscapeDecoder.ColoredTextAcceptor listener2) {
        this.myColoredTextListeners.remove(listener2);
    }

    protected void textAvailable(String text, Key attributes) {
        super.notifyTextAvailable(text, attributes);
    }
}

