/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.RemoteDeadHand;
import com.intellij.execution.rmi.RemoteServer;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.DefaultProgramRunner;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.FixedFuture;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.rmi.Remote;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import javax.rmi.PortableRemoteObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteProcessSupport<Target, EntryPoint, Parameters> {
    public static final Logger LOG = Logger.getInstance(RemoteProcessSupport.class);
    private final Class<EntryPoint> myValueClass;
    private final HashMap<Pair<Target, Parameters>, Info> myProcMap = new HashMap();

    public RemoteProcessSupport(Class<EntryPoint> valueClass) {
        this.myValueClass = valueClass;
    }

    protected abstract void fireModificationCountChanged();

    protected abstract String getName(Target var1);

    protected void logText(Parameters configuration, ProcessEvent event, Key outputType, Object info) {
    }

    public void stopAll() {
        this.stopAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll(boolean wait) {
        ArrayList infos = ContainerUtil.newArrayList();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Info o : this.myProcMap.values()) {
                if (o.handler == null) continue;
                infos.add(o);
            }
        }
        if (infos.isEmpty()) {
            return;
        }
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RemoteProcessSupport.destroyProcessesImpl(infos);
            if (wait) {
                for (Info o : infos) {
                    o.handler.waitFor();
                }
            }
        });
        if (wait) {
            try {
                future2.get();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (java.util.concurrent.ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Parameters> getActiveConfigurations(@NotNull Target target) {
        ArrayList<Object> result2 = new ArrayList<Object>();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> pair : this.myProcMap.keySet()) {
                if (pair.first != target) continue;
                result2.add(pair.second);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Pair<Target, Parameters>> getActiveConfigurations() {
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            return new HashSet(this.myProcMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntryPoint acquire(@NotNull Target target, @NotNull Parameters configuration) throws Exception {
        ApplicationManagerEx.getApplicationEx().assertTimeConsuming();
        Ref ref = Ref.create(null);
        Pair key2 = Pair.create(target, configuration);
        if (!this.getExistingInfo((Ref<RunningInfo>)ref, key2)) {
            this.startProcess(target, configuration, key2);
            if (ref.isNull()) {
                try {
                    Ref ref2 = ref;
                    synchronized (ref2) {
                        while (ref.isNull()) {
                            ref.wait(1000L);
                            ProgressManager.checkCanceled();
                        }
                    }
                }
                catch (InterruptedException e) {
                    ProgressManager.checkCanceled();
                }
            }
        }
        if (ref.isNull()) {
            throw new RuntimeException("Unable to acquire remote proxy for: " + this.getName(target));
        }
        RunningInfo info = (RunningInfo)ref.get();
        if (info.handler == null) {
            String message2 = info.name;
            if (message2 != null && message2.startsWith("ERROR: transport error 202:")) {
                message2 = "Unable to start java process in debug mode: -Xdebug parameters are already in use.";
            }
            throw new ExecutionException(message2);
        }
        return this.acquire(info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<?> release(@NotNull Target target, @Nullable Parameters configuration) {
        ArrayList infos = ContainerUtil.newArrayList();
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            for (Pair<Target, Parameters> key2 : this.myProcMap.keySet()) {
                if (key2.first != target || configuration != null && key2.second != configuration) continue;
                Info o = this.myProcMap.get(key2);
                if (o.handler == null) continue;
                infos.add(o);
            }
        }
        if (infos.isEmpty()) {
            return new FixedFuture(null);
        }
        return ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RemoteProcessSupport.destroyProcessesImpl(infos);
            this.fireModificationCountChanged();
            for (Info o : infos) {
                o.handler.waitFor();
            }
        });
    }

    private static void destroyProcessesImpl(@NotNull List<Info> infos) {
        for (Info o : infos) {
            LOG.info("Terminating: " + o);
            o.handler.destroyProcess();
        }
    }

    private void startProcess(Target target, Parameters configuration, @NotNull Pair<Target, Parameters> key2) {
        ProcessHandler processHandler2;
        DefaultProgramRunner runner = new DefaultProgramRunner(){

            @NotNull
            public String getRunnerId() {
                return "MyRunner";
            }

            public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
                return true;
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        try {
            RunProfileState state = this.getRunProfileState(target, configuration, executor);
            ExecutionResult result2 = state.execute(executor, (ProgramRunner)runner);
            processHandler2 = result2.getProcessHandler();
        }
        catch (Exception e) {
            this.dropProcessInfo(key2, e instanceof ExecutionException ? e.getMessage() : ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)LOG), null);
            return;
        }
        processHandler2.addProcessListener(this.getProcessListener(key2));
        processHandler2.startNotify();
    }

    protected abstract RunProfileState getRunProfileState(Target var1, Parameters var2, Executor var3) throws ExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getExistingInfo(@NotNull Ref<RunningInfo> ref, @NotNull Pair<Target, Parameters> key2) {
        Info info;
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            info = this.myProcMap.get(key2);
            try {
                while (info != null && (!(info instanceof RunningInfo) || info.handler.isProcessTerminating() || info.handler.isProcessTerminated())) {
                    this.myProcMap.wait(1000L);
                    ProgressManager.checkCanceled();
                    info = this.myProcMap.get(key2);
                }
            }
            catch (InterruptedException e) {
                ProgressManager.checkCanceled();
            }
            if (info == null) {
                this.myProcMap.put(key2, new PendingInfo(ref, null));
            }
        }
        if (info instanceof RunningInfo) {
            hashMap = ref;
            synchronized (hashMap) {
                ref.set((Object)((RunningInfo)info));
                ref.notifyAll();
            }
        }
        return info != null;
    }

    private EntryPoint acquire(RunningInfo port) throws Exception {
        Object result2;
        port.entryPointHardRef = result2 = RemoteUtil.executeWithClassLoader(() -> {
            Registry registry = LocateRegistry.getRegistry("localhost", port.port);
            Remote remote = (Remote)ObjectUtils.assertNotNull((Object)registry.lookup(port.name));
            if (Remote.class.isAssignableFrom(this.myValueClass)) {
                EntryPoint entryPoint = RemoteProcessSupport.narrowImpl(remote, this.myValueClass);
                if (entryPoint == null) {
                    return null;
                }
                return RemoteUtil.substituteClassLoader(entryPoint, (ClassLoader)this.myValueClass.getClassLoader());
            }
            return RemoteUtil.castToLocal((Object)remote, this.myValueClass);
        }, (ClassLoader)this.getClass().getClassLoader());
        return (EntryPoint)result2;
    }

    @Nullable
    private static <T> T narrowImpl(@Nullable Remote remote, @NotNull Class<T> to) {
        return (T)(to.isInstance(remote) ? remote : PortableRemoteObject.narrow((Object)remote, to));
    }

    private ProcessListener getProcessListener(final @NotNull Pair<Target, Parameters> key2) {
        return new ProcessListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                ProcessHandler processHandler2 = event.getProcessHandler();
                processHandler2.putUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE, (Object)Boolean.TRUE);
                HashMap hashMap = RemoteProcessSupport.this.myProcMap;
                synchronized (hashMap) {
                    Info o = (Info)RemoteProcessSupport.this.myProcMap.get(key2);
                    if (o instanceof PendingInfo) {
                        RemoteProcessSupport.this.myProcMap.put(key2, new PendingInfo(((PendingInfo)o).ref, processHandler2));
                    }
                }
            }

            public void processTerminated(ProcessEvent event) {
                if (RemoteProcessSupport.this.dropProcessInfo(key2, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
            }

            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                if (RemoteProcessSupport.this.dropProcessInfo(key2, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(ProcessEvent event, Key outputType) {
                PendingInfo info;
                String text = StringUtil.notNullize((String)event.getText());
                if (outputType == ProcessOutputTypes.STDERR) {
                    LOG.warn(text.trim());
                } else {
                    LOG.info(text.trim());
                }
                RunningInfo result2 = null;
                Ref<RunningInfo> ref = RemoteProcessSupport.this.myProcMap;
                synchronized (ref) {
                    Info o = (Info)RemoteProcessSupport.this.myProcMap.get(key2);
                    RemoteProcessSupport.this.logText(key2.second, event, outputType, o);
                    if (o instanceof PendingInfo) {
                        info = (PendingInfo)o;
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            String prefix = "Port/ID:";
                            if (text.startsWith(prefix)) {
                                String pair = text.substring(prefix.length()).trim();
                                int idx = pair.indexOf("/");
                                result2 = new RunningInfo(info.handler, Integer.parseInt(pair.substring(0, idx)), pair.substring(idx + 1));
                                RemoteProcessSupport.this.myProcMap.put(key2, result2);
                                RemoteProcessSupport.this.myProcMap.notifyAll();
                            }
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            info.stderr.append(text);
                        }
                    } else {
                        info = null;
                    }
                }
                if (result2 != null) {
                    ref = info.ref;
                    synchronized (ref) {
                        info.ref.set(result2);
                        info.ref.notifyAll();
                    }
                    RemoteProcessSupport.this.fireModificationCountChanged();
                    try {
                        RemoteDeadHand.TwoMinutesTurkish.startCooking((String)"localhost", (int)result2.port);
                    }
                    catch (Throwable e) {
                        LOG.warn("The cook failed to start due to " + ExceptionUtil.getRootCause((Throwable)e));
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropProcessInfo(Pair<Target, Parameters> key2, @Nullable String errorMessage, @Nullable ProcessHandler handler2) {
        Info info;
        HashMap<Pair<Target, Parameters>, Info> hashMap = this.myProcMap;
        synchronized (hashMap) {
            info = this.myProcMap.get(key2);
            if (info != null && (handler2 == null || info.handler == handler2)) {
                this.myProcMap.remove(key2);
                this.myProcMap.notifyAll();
            } else {
                info = null;
            }
        }
        if (info instanceof PendingInfo) {
            PendingInfo pendingInfo = (PendingInfo)info;
            if (pendingInfo.stderr.length() > 0 || pendingInfo.ref.isNull()) {
                if (errorMessage != null) {
                    pendingInfo.stderr.append(errorMessage);
                }
                pendingInfo.ref.set((Object)new RunningInfo(null, -1, pendingInfo.stderr.toString()));
            }
            Ref<RunningInfo> ref = pendingInfo.ref;
            synchronized (ref) {
                pendingInfo.ref.notifyAll();
            }
        }
        return info != null;
    }

    static {
        RemoteServer.setupRMI();
    }

    private static class RunningInfo
    extends Info {
        final int port;
        final String name;
        Object entryPointHardRef;

        RunningInfo(ProcessHandler handler2, int port, String name) {
            super(handler2);
            this.port = port;
            this.name = name;
        }

        public String toString() {
            return this.port + "/" + this.name;
        }
    }

    private static class PendingInfo
    extends Info {
        final Ref<RunningInfo> ref;
        final StringBuilder stderr = new StringBuilder();

        PendingInfo(Ref<RunningInfo> ref, ProcessHandler handler2) {
            super(handler2);
            this.ref = ref;
        }

        public String toString() {
            return "PendingInfo{" + this.ref.get() + '}';
        }
    }

    private static class Info {
        final ProcessHandler handler;

        Info(ProcessHandler handler2) {
            this.handler = handler2;
        }
    }
}

