/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.GotItMessage;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RerunTestsNotification {
    private static final String KEY = "rerun.tests.notification.shown";

    public static void showRerunNotification(@Nullable RunContentDescriptor contentToReuse, @NotNull ExecutionConsole executionConsole) {
        boolean showNotification2;
        if (contentToReuse == null) {
            return;
        }
        String lastActionId = ActionManagerEx.getInstanceEx().getPrevPreformedActionId();
        boolean bl = showNotification2 = !"RerunTests".equals(lastActionId);
        if (showNotification2 && !PropertiesComponent.getInstance().isTrueValue(KEY)) {
            UiNotifyConnector.doWhenFirstShown((JComponent)executionConsole.getComponent(), () -> RerunTestsNotification.doShow(executionConsole));
        }
    }

    private static void doShow(@NotNull ExecutionConsole executionConsole) {
        Alarm alarm = new Alarm();
        alarm.addRequest(() -> {
            String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("RerunTests"));
            if (shortcutText.isEmpty()) {
                return;
            }
            GotItMessage message2 = GotItMessage.createMessage("Rerun tests with " + shortcutText, "");
            message2.setDisposable((Disposable)executionConsole);
            message2.setCallback(() -> PropertiesComponent.getInstance().setValue(KEY, true));
            message2.setShowCallout(false);
            Dimension consoleSize = executionConsole.getComponent().getSize();
            message2.show(new RelativePoint((Component)executionConsole.getComponent(), new Point(consoleSize.width - 185, consoleSize.height - 60)), Balloon.Position.below);
            Disposer.dispose((Disposable)alarm);
        }, 1000);
    }
}

