/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.diagnostic.logging.LogConsoleManagerBase;
import com.intellij.diagnostic.logging.LogFilesManager;
import com.intellij.diagnostic.logging.OutputFileUtil;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RunTab
implements DataProvider,
Disposable {
    @NotNull
    protected final RunnerLayoutUi myUi;
    private LogFilesManager myManager;
    protected RunContentDescriptor myRunContentDescriptor;
    protected ExecutionEnvironment myEnvironment;
    protected final Project myProject;
    private final GlobalSearchScope mySearchScope;
    private LogConsoleManagerBase logConsoleManager;

    protected RunTab(@NotNull ExecutionEnvironment environment, @NotNull String runnerType) {
        this(environment.getProject(), SearchScopeProvider.createSearchScope((Project)environment.getProject(), (RunProfile)environment.getRunProfile()), runnerType, environment.getExecutor().getId(), environment.getRunProfile().getName());
        this.myEnvironment = environment;
    }

    public void dispose() {
        this.myRunContentDescriptor = null;
        this.myEnvironment = null;
        this.logConsoleManager = null;
    }

    protected RunTab(@NotNull Project project2, @NotNull GlobalSearchScope searchScope, @NotNull String runnerType, @NotNull String runnerTitle, @NotNull String sessionName) {
        this.myProject = project2;
        this.mySearchScope = searchScope;
        this.myUi = RunnerLayoutUi.Factory.getInstance((Project)project2).create(runnerType, runnerTitle, sessionName, (Disposable)this);
        this.myUi.getContentManager().addDataProvider((DataProvider)this);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (LangDataKeys.RUN_PROFILE.is(dataId)) {
            return this.myEnvironment == null ? null : this.myEnvironment.getRunProfile();
        }
        if (LangDataKeys.EXECUTION_ENVIRONMENT.is(dataId)) {
            return this.myEnvironment;
        }
        if (LangDataKeys.RUN_CONTENT_DESCRIPTOR.is(dataId)) {
            return this.myRunContentDescriptor;
        }
        return null;
    }

    @NotNull
    public LogConsoleManagerBase getLogConsoleManager() {
        if (this.logConsoleManager == null) {
            this.logConsoleManager = new LogConsoleManagerBase(this.myProject, this.mySearchScope){

                @Override
                protected Icon getDefaultIcon() {
                    return AllIcons.Debugger.Console_log;
                }

                @Override
                protected RunnerLayoutUi getUi() {
                    return RunTab.this.myUi;
                }

                @Override
                public ProcessHandler getProcessHandler() {
                    return RunTab.this.myRunContentDescriptor == null ? null : RunTab.this.myRunContentDescriptor.getProcessHandler();
                }
            };
        }
        return this.logConsoleManager;
    }

    protected final void initLogConsoles(@NotNull RunProfile runConfiguration, @NotNull RunContentDescriptor contentDescriptor, @Nullable ExecutionConsole console) {
        ProcessHandler processHandler2 = contentDescriptor.getProcessHandler();
        if (runConfiguration instanceof RunConfigurationBase) {
            RunConfigurationBase configuration = (RunConfigurationBase)runConfiguration;
            if (this.myManager == null) {
                this.myManager = new LogFilesManager(this.myProject, this.getLogConsoleManager(), (Disposable)contentDescriptor);
            }
            this.myManager.addLogConsoles(configuration, processHandler2);
            if (processHandler2 != null) {
                OutputFileUtil.attachDumpListener(configuration, processHandler2, console);
            }
        }
    }
}

