/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.execution.JavaExecutionUtil;
import com.intellij.execution.JavaTestConfigurationBase;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.junit.JavaRunConfigurationProducerBase;
import com.intellij.execution.testDiscovery.TestDiscoveryIndex;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.testIntegration.TestFramework;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public abstract class TestDiscoveryConfigurationProducer
extends JavaRunConfigurationProducerBase<JavaTestConfigurationBase> {
    protected TestDiscoveryConfigurationProducer(ConfigurationType type2) {
        super(type2);
    }

    protected abstract void setPosition(JavaTestConfigurationBase var1, PsiLocation<PsiMethod> var2);

    protected abstract Pair<String, String> getPosition(JavaTestConfigurationBase var1);

    protected boolean setupConfigurationFromContext(JavaTestConfigurationBase configuration, ConfigurationContext configurationContext, Ref<PsiElement> ref) {
        if (!Registry.is((String)"testDiscovery.enabled")) {
            return false;
        }
        Location contextLocation = configurationContext.getLocation();
        assert (contextLocation != null);
        Location location = JavaExecutionUtil.stepIntoSingleClass((Location)contextLocation);
        if (location == null) {
            return false;
        }
        PsiMethod sourceMethod = TestDiscoveryConfigurationProducer.getSourceMethod(location);
        Pair<String, String> position = TestDiscoveryConfigurationProducer.getPosition(sourceMethod);
        if (sourceMethod != null && position != null) {
            try {
                Collection<String> modules;
                Project project2 = configuration.getProject();
                TestDiscoveryIndex testDiscoveryIndex = TestDiscoveryIndex.getInstance(project2);
                Collection<String> testsByMethodName = testDiscoveryIndex.getTestsByMethodName((String)position.first, (String)position.second);
                if (testsByMethodName == null || ContainerUtil.filter(testsByMethodName, s -> s.startsWith(configuration.getFrameworkPrefix())).isEmpty()) {
                    return false;
                }
                this.setPosition(configuration, (PsiLocation<PsiMethod>)new PsiLocation((PsiElement)sourceMethod));
                configuration.setName("Tests for " + StringUtil.getShortName((String)((String)position.first)) + "." + (String)position.second);
                RunnerAndConfigurationSettings template = configurationContext.getRunManager().getConfigurationTemplate(this.getConfigurationFactory());
                Module predefinedModule = ((ModuleBasedConfiguration)template.getConfiguration()).getConfigurationModule().getModule();
                if (predefinedModule != null) {
                    configuration.setModule(predefinedModule);
                }
                if ((modules = testDiscoveryIndex.getTestModulesByMethodName((String)position.first, (String)position.second, configuration.getFrameworkPrefix())).isEmpty()) {
                    return true;
                }
                ArrayList<Module> survivedModules = new ArrayList<Module>();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
                for (String moduleName : modules) {
                    Module moduleByName = moduleManager.findModuleByName(moduleName);
                    if (moduleByName == null) continue;
                    survivedModules.add(moduleByName);
                }
                if (survivedModules.isEmpty()) {
                    return true;
                }
                HashSet allModules = new HashSet(Arrays.asList(moduleManager.getModules()));
                survivedModules.forEach(arg_0 -> TestDiscoveryConfigurationProducer.lambda$setupConfigurationFromContext$1((Set)allModules, arg_0));
                if (!allModules.isEmpty()) {
                    Module aModule = (Module)allModules.iterator().next();
                    for (Module module2 : survivedModules) {
                        if (!allModules.contains(module2)) continue;
                        aModule = module2;
                    }
                    configuration.setModule(aModule);
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    protected Module findModule(JavaTestConfigurationBase configuration, Module contextModule) {
        return null;
    }

    private static PsiMethod getSourceMethod(Location location) {
        PsiClass containingClass;
        PsiElement psiElement = location.getPsiElement();
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (psiMethod != null && (containingClass = psiMethod.getContainingClass()) != null) {
            TestFramework testFramework = TestFrameworks.detectFramework((PsiClass)containingClass);
            if (testFramework != null) {
                return null;
            }
            return psiMethod;
        }
        return null;
    }

    private static Pair<String, String> getPosition(PsiMethod method2) {
        if (method2 == null) {
            return null;
        }
        PsiClass containingClass = method2.getContainingClass();
        if (containingClass == null) {
            return null;
        }
        String qualifiedName = containingClass.getQualifiedName();
        if (qualifiedName != null) {
            return Pair.create((Object)qualifiedName, (Object)method2.getName());
        }
        return null;
    }

    public boolean isConfigurationFromContext(JavaTestConfigurationBase configuration, ConfigurationContext configurationContext) {
        Pair<String, String> position = TestDiscoveryConfigurationProducer.getPosition(TestDiscoveryConfigurationProducer.getSourceMethod(configurationContext.getLocation()));
        return position != null && position.equals(this.getPosition(configuration));
    }

    private static /* synthetic */ void lambda$setupConfigurationFromContext$1(Set allModules, Module module2) {
        List dependentModules = ModuleUtilCore.getAllDependentModules((Module)module2);
        dependentModules.add(module2);
        allModules.retainAll(dependentModules);
    }
}

