/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testDiscovery;

import com.intellij.execution.testDiscovery.TestDiscoveryExtension;
import com.intellij.execution.testDiscovery.TestInfoHolder;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntObjectHashMap;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestDiscoveryIndex
implements ProjectComponent {
    static final Logger LOG = Logger.getInstance(TestDiscoveryIndex.class);
    private final Project myProject;
    private final TestDataController myLocalTestRunDataController;
    private final TestDataController myRemoteTestRunDataController;

    public TestDiscoveryIndex(Project project2) {
        this(project2, TestDiscoveryExtension.baseTestDiscoveryPathForProject(project2));
    }

    public TestDiscoveryIndex(Project project2, String basePath) {
        this.myProject = project2;
        this.myLocalTestRunDataController = new TestDataController(basePath, false);
        this.myRemoteTestRunDataController = new TestDataController(null, true);
        if (new File(basePath).exists()) {
            StartupManager.getInstance((Project)project2).registerPostStartupActivity(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> this.myLocalTestRunDataController.getHolder()));
        }
    }

    public boolean hasTestTrace(@NotNull String testName) throws IOException {
        Boolean result2 = (Boolean)this.myLocalTestRunDataController.withTestDataHolder(localHolder -> {
            int testNameId = localHolder.myTestNameEnumerator.tryEnumerate((Object)testName);
            if (testNameId == 0) {
                return this.myRemoteTestRunDataController.withTestDataHolder(remoteHolder -> {
                    int testNameId1 = remoteHolder.myTestNameEnumerator.tryEnumerate((Object)testName);
                    return testNameId1 != 0 && remoteHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId1) != null;
                }) != null;
            }
            return localHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId) != null;
        });
        return result2 == Boolean.TRUE;
    }

    public void removeTestTrace(final @NotNull String testName) throws IOException {
        this.myLocalTestRunDataController.withTestDataHolder(new ThrowableConvertor<TestInfoHolder, Void, IOException>(){

            public Void convert(TestInfoHolder localHolder) throws IOException {
                int testNameId = localHolder.myTestNameEnumerator.tryEnumerate((Object)testName);
                if (testNameId != 0) {
                    localHolder.doUpdateFromDiff(testNameId, null, (TIntObjectHashMap<TIntArrayList>)((TIntObjectHashMap)localHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId)), null);
                }
                return null;
            }
        });
    }

    public void setRemoteTestRunDataPath(String path) {
        if (!TestInfoHolder.isValidPath(path)) {
            path = null;
        }
        this.myRemoteTestRunDataController.init(path);
    }

    public Collection<String> getTestsByMethodName(final @NotNull String classFQName, final @NotNull String methodName) throws IOException {
        return this.myLocalTestRunDataController.withTestDataHolder(new ThrowableConvertor<TestInfoHolder, Collection<String>, IOException>(){

            public Collection<String> convert(TestInfoHolder localHolder) throws IOException {
                TIntArrayList remoteList = (TIntArrayList)TestDiscoveryIndex.this.myRemoteTestRunDataController.withTestDataHolder(remoteHolder -> (TIntArrayList)remoteHolder.myMethodQNameToTestNames.get((Object)TestInfoHolder.createKey(remoteHolder.myClassEnumerator.enumerate(classFQName), remoteHolder.myMethodEnumerator.enumerate(methodName))));
                TIntArrayList localList = (TIntArrayList)localHolder.myMethodQNameToTestNames.get((Object)TestInfoHolder.createKey(localHolder.myClassEnumerator.enumerate(classFQName), localHolder.myMethodEnumerator.enumerate(methodName)));
                if (remoteList == null) {
                    return this.testIdsToTestNames(localList, localHolder);
                }
                Collection testsFromRemote = (Collection)TestDiscoveryIndex.this.myRemoteTestRunDataController.withTestDataHolder(remoteHolder -> this.testIdsToTestNames(remoteList, (TestInfoHolder)remoteHolder));
                if (localList == null) {
                    return testsFromRemote;
                }
                THashSet setOfStrings = new THashSet(testsFromRemote);
                for (int testNameId : localList.toNativeArray()) {
                    if (testNameId < 0) {
                        setOfStrings.remove((Object)localHolder.myTestNameEnumerator.valueOf(-testNameId));
                        continue;
                    }
                    setOfStrings.add((Object)localHolder.myTestNameEnumerator.valueOf(testNameId));
                }
                return setOfStrings;
            }

            private Collection<String> testIdsToTestNames(TIntArrayList localList, TestInfoHolder localHolder) throws IOException {
                if (localList == null) {
                    return Collections.emptyList();
                }
                ArrayList<String> result2 = new ArrayList<String>(localList.size());
                for (int testNameId : localList.toNativeArray()) {
                    if (testNameId < 0) {
                        boolean a = true;
                        continue;
                    }
                    result2.add(localHolder.myTestNameEnumerator.valueOf(testNameId));
                }
                return result2;
            }
        });
    }

    public Collection<String> getTestModulesByMethodName(final @NotNull String classFQName, final @NotNull String methodName, final String prefix) throws IOException {
        return this.myLocalTestRunDataController.withTestDataHolder(new ThrowableConvertor<TestInfoHolder, Collection<String>, IOException>(){

            public Collection<String> convert(TestInfoHolder localHolder) throws IOException {
                List<String> modules = this.getTestModules(localHolder);
                List modulesFromRemote = (List)TestDiscoveryIndex.this.myRemoteTestRunDataController.withTestDataHolder(this::getTestModules);
                THashSet modulesSet = new THashSet(modules);
                if (modulesFromRemote != null) {
                    modulesSet.addAll((Collection)modulesFromRemote);
                }
                return modulesSet;
            }

            private List<String> getTestModules(TestInfoHolder holder) throws IOException {
                TIntArrayList list = (TIntArrayList)holder.myTestNameToNearestModule.get((Object)TestInfoHolder.createKey(holder.myClassEnumerator.enumerate(classFQName), holder.myMethodEnumerator.enumerate(methodName)));
                if (list == null) {
                    return Collections.emptyList();
                }
                ArrayList<String> result2 = new ArrayList<String>(list.size());
                for (int moduleNameId : list.toNativeArray()) {
                    String moduleNameWithPrefix = holder.myModuleNameEnumerator.valueOf(moduleNameId);
                    if (moduleNameWithPrefix == null || !moduleNameWithPrefix.startsWith(prefix)) continue;
                    result2.add(moduleNameWithPrefix.substring(prefix.length()));
                }
                return result2;
            }
        });
    }

    public static TestDiscoveryIndex getInstance(Project project2) {
        return (TestDiscoveryIndex)project2.getComponent(TestDiscoveryIndex.class);
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        this.myLocalTestRunDataController.dispose();
        this.myRemoteTestRunDataController.dispose();
    }

    @NotNull
    public String getComponentName() {
        return this.getClass().getName();
    }

    public void projectOpened() {
    }

    public void projectClosed() {
    }

    public void updateFromTestTrace(@NotNull File file2, @Nullable String moduleName, @NotNull String frameworkPrefix) throws IOException {
        int fileNameDotIndex = file2.getName().lastIndexOf(46);
        String testName = fileNameDotIndex != -1 ? file2.getName().substring(0, fileNameDotIndex) : file2.getName();
        this.doUpdateFromTestTrace(file2, testName, moduleName != null ? frameworkPrefix + moduleName : null);
    }

    private void doUpdateFromTestTrace(final File file2, final String testName, final @Nullable String moduleName) throws IOException {
        this.myLocalTestRunDataController.withTestDataHolder(new ThrowableConvertor<TestInfoHolder, Void, IOException>(){

            public Void convert(TestInfoHolder localHolder) throws IOException {
                int testNameId = localHolder.myTestNameEnumerator.enumerate(testName);
                TIntObjectHashMap classData = TestDiscoveryIndex.loadClassAndMethodsMap(file2, localHolder);
                TIntObjectHashMap previousClassData = (TIntObjectHashMap)localHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId);
                if (previousClassData == null) {
                    previousClassData = (TIntObjectHashMap)TestDiscoveryIndex.this.myRemoteTestRunDataController.withTestDataHolder(remoteDataHolder -> {
                        Ref exceptionRef;
                        TIntObjectHashMap remoteClassData = (TIntObjectHashMap)remoteDataHolder.myTestNameToUsedClassesAndMethodMap.get((Object)testNameId);
                        if (remoteClassData == null) {
                            return null;
                        }
                        TIntObjectHashMap result2 = new TIntObjectHashMap(remoteClassData.size());
                        boolean processingResult = remoteClassData.forEachEntry((arg_0, arg_1) -> 4.lambda$null$0(localHolder, remoteDataHolder, result2, exceptionRef = new Ref(), arg_0, arg_1));
                        if (!processingResult) {
                            throw (IOException)exceptionRef.get();
                        }
                        return result2;
                    });
                }
                localHolder.doUpdateFromDiff(testNameId, (TIntObjectHashMap<TIntArrayList>)classData, (TIntObjectHashMap<TIntArrayList>)previousClassData, moduleName != null ? Integer.valueOf(localHolder.myModuleNameEnumerator.enumerate(moduleName)) : null);
                return null;
            }

            private static /* synthetic */ boolean lambda$null$0(TestInfoHolder localHolder, TestInfoHolder remoteDataHolder, TIntObjectHashMap result2, Ref exceptionRef, int remoteClassKey, TIntArrayList remoteClassMethodIds) {
                try {
                    int localClassKey = localHolder.myClassEnumeratorCache.enumerate(remoteDataHolder.myClassEnumeratorCache.valueOf(remoteClassKey));
                    TIntArrayList localClassIds = new TIntArrayList(remoteClassMethodIds.size());
                    for (int methodId : remoteClassMethodIds.toNativeArray()) {
                        localClassIds.add(localHolder.myMethodEnumeratorCache.enumerate(remoteDataHolder.myMethodEnumeratorCache.valueOf(methodId)));
                    }
                    result2.put(localClassKey, (Object)localClassIds);
                    return true;
                }
                catch (IOException ex) {
                    exceptionRef.set((Object)ex);
                    return false;
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static TIntObjectHashMap<TIntArrayList> loadClassAndMethodsMap(File file2, TestInfoHolder holder) throws IOException {
        byte[] buffer = IOUtil.allocReadWriteUTFBuffer();
        try (DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file2), 65536));){
            int numberOfClasses = DataInputOutputUtil.readINT((DataInput)inputStream);
            TIntObjectHashMap classData = new TIntObjectHashMap(numberOfClasses);
            while (numberOfClasses-- > 0) {
                String classQName = IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream);
                int classId = holder.myClassEnumeratorCache.enumerate((Object)classQName);
                int numberOfMethods = DataInputOutputUtil.readINT((DataInput)inputStream);
                TIntArrayList methodsList = new TIntArrayList(numberOfMethods);
                while (numberOfMethods-- > 0) {
                    String methodName = IOUtil.readUTFFast((byte[])buffer, (DataInput)inputStream);
                    methodsList.add(holder.myMethodEnumeratorCache.enumerate((Object)methodName));
                }
                classData.put(classId, (Object)methodsList);
            }
            TIntObjectHashMap tIntObjectHashMap = classData;
            return tIntObjectHashMap;
        }
    }

    static class TestDataController {
        private final Object myLock = new Object();
        private String myBasePath;
        private final boolean myReadOnly;
        private volatile TestInfoHolder myHolder;

        TestDataController(String basePath, boolean readonly) {
            this.myReadOnly = readonly;
            this.init(basePath);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void init(String basePath) {
            if (this.myHolder != null) {
                this.dispose();
            }
            Object object = this.myLock;
            synchronized (object) {
                this.myBasePath = basePath;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private TestInfoHolder getHolder() {
            TestInfoHolder holder = this.myHolder;
            if (holder == null) {
                Object object = this.myLock;
                synchronized (object) {
                    holder = this.myHolder;
                    if (holder == null && this.myBasePath != null) {
                        this.myHolder = holder = new TestInfoHolder(this.myBasePath, this.myReadOnly, this.myLock);
                    }
                }
            }
            return holder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispose() {
            Object object = this.myLock;
            synchronized (object) {
                TestInfoHolder holder = this.myHolder;
                if (holder != null) {
                    holder.dispose();
                    this.myHolder = null;
                }
            }
        }

        private void thingsWentWrongLetsReinitialize(@Nullable TestInfoHolder holder, Throwable throwable) throws IOException {
            LOG.error("Unexpected problem", throwable);
            if (holder != null) {
                holder.dispose();
            }
            File versionFile = TestInfoHolder.getVersionFile(this.myBasePath);
            FileUtil.delete((File)versionFile);
            this.myHolder = null;
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <R> R withTestDataHolder(ThrowableConvertor<TestInfoHolder, R, IOException> action) throws IOException {
            Object object = this.myLock;
            synchronized (object) {
                TestInfoHolder holder = this.getHolder();
                if (holder == null || holder.isDisposed()) {
                    return null;
                }
                try {
                    return (R)action.convert((Object)holder);
                }
                catch (Throwable throwable) {
                    if (!this.myReadOnly) {
                        this.thingsWentWrongLetsReinitialize(holder, throwable);
                    } else {
                        LOG.error(throwable);
                    }
                    return null;
                }
            }
        }
    }
}

