/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.junit2.PsiMemberParameterizedLocation;
import com.intellij.execution.junit2.info.MethodLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JavaTestLocator
implements SMTestLocator {
    public static final String SUITE_PROTOCOL = "java:suite";
    public static final String TEST_PROTOCOL = "java:test";
    public static final JavaTestLocator INSTANCE = new JavaTestLocator();

    @Override
    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope) {
        List<Location> results = Collections.emptyList();
        String paramName = null;
        int idx = path.indexOf(91);
        if (idx >= 0) {
            paramName = path.substring(idx);
            path = path.substring(0, idx);
        }
        if (SUITE_PROTOCOL.equals(protocol)) {
            path = StringUtil.trimEnd((String)path, (String)".");
            PsiClass aClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project2), (String)path, null, (boolean)true, (GlobalSearchScope)scope);
            if (aClass != null) {
                results = ContainerUtil.newSmartList();
                results.add(JavaTestLocator.createClassNavigatable(paramName, aClass));
            } else {
                results = JavaTestLocator.collectMethodNavigatables(path, project2, scope, paramName);
            }
        } else if (TEST_PROTOCOL.equals(protocol)) {
            results = JavaTestLocator.collectMethodNavigatables(path, project2, scope, paramName);
        }
        return results;
    }

    private static List<Location> collectMethodNavigatables(@NotNull String path, @NotNull Project project2, @NotNull GlobalSearchScope scope, String paramName) {
        List results = Collections.emptyList();
        String className = StringUtil.getPackageName((String)path);
        if (!StringUtil.isEmpty((String)className)) {
            String methodName = StringUtil.getShortName((String)path);
            PsiClass aClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project2), (String)className, null, (boolean)true, (GlobalSearchScope)scope);
            if (aClass != null) {
                results = ContainerUtil.newSmartList();
                if (methodName.trim().equals(aClass.getName())) {
                    results.add(JavaTestLocator.createClassNavigatable(paramName, aClass));
                } else {
                    PsiMethod[] methods = aClass.findMethodsByName(methodName.trim(), true);
                    if (methods.length > 0) {
                        for (PsiMethod method2 : methods) {
                            results.add(paramName != null ? new PsiMemberParameterizedLocation(project2, (PsiElement)method2, aClass, paramName) : MethodLocation.elementInClass(method2, aClass));
                        }
                    }
                }
            }
        }
        return results;
    }

    private static Location createClassNavigatable(String paramName, @NotNull PsiClass aClass) {
        return paramName != null ? PsiMemberParameterizedLocation.getParameterizedLocation(aClass, paramName) : new PsiLocation(aClass.getProject(), (PsiElement)aClass);
    }
}

