/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.process.AnsiEscapeDecoder;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.util.Key;
import org.jetbrains.annotations.NotNull;

public interface Printer {
    public void print(String var1, ConsoleViewContentType var2);

    public void onNewAvailable(@NotNull Printable var1);

    public void printHyperlink(String var1, HyperlinkInfo var2);

    public void mark();

    default public void printWithAnsiColoring(@NotNull String text, final @NotNull Key processOutputType) {
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        decoder.escapeText(text, ProcessOutputTypes.STDOUT, new AnsiEscapeDecoder.ColoredTextAcceptor(){

            public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
                ConsoleViewContentType contentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
                if (contentType == null || contentType == ConsoleViewContentType.NORMAL_OUTPUT) {
                    contentType = ConsoleViewContentType.getConsoleViewType((Key)processOutputType);
                }
                Printer.this.print(text, contentType);
            }
        });
    }

    default public void printWithAnsiColoring(@NotNull String text, final @NotNull ConsoleViewContentType contentType) {
        AnsiEscapeDecoder decoder = new AnsiEscapeDecoder();
        decoder.escapeText(text, ProcessOutputTypes.STDOUT, new AnsiEscapeDecoder.ColoredTextAcceptor(){

            public void coloredTextAvailable(@NotNull String text, @NotNull Key attributes) {
                ConsoleViewContentType viewContentType = ConsoleViewContentType.getConsoleViewType((Key)attributes);
                if (viewContentType == null) {
                    viewContentType = contentType;
                }
                Printer.this.print(text, viewContentType);
            }
        });
    }
}

