/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pass;
import com.intellij.ui.ClickListener;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackRunningTestUtil {
    private TrackRunningTestUtil() {
    }

    public static void installStopListeners(final JTree tree, Disposable parentDisposable, final Pass<AbstractTestProxy> setSelection) {
        final ClickListener userSelectionListener = new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e, int clickCount) {
                setSelection.pass((Object)TrackRunningTestUtil.setUserSelection(tree.getPathForLocation(e.getX(), e.getY())));
                return true;
            }
        };
        userSelectionListener.installOn((Component)tree);
        final KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                int keyCode = e.getKeyCode();
                if (keyCode == 40 || keyCode == 38 || keyCode == 37 || keyCode == 39 || keyCode == 34 || keyCode == 33) {
                    setSelection.pass((Object)TrackRunningTestUtil.setUserSelection(tree.getSelectionPath()));
                }
            }
        };
        tree.addKeyListener(keyAdapter);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                userSelectionListener.uninstall((Component)tree);
                tree.removeKeyListener(keyAdapter);
            }
        });
    }

    @Nullable
    private static AbstractTestProxy setUserSelection(TreePath treePath) {
        Object userObject;
        Object component;
        if (treePath != null && (component = treePath.getLastPathComponent()) instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)component).getUserObject()) instanceof NodeDescriptor) {
            return (AbstractTestProxy)((NodeDescriptor)userObject).getElement();
        }
        return null;
    }
}

