/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.testframework.export.ExportTestResultsConfiguration;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.Nullable;

public class ExportTestResultsForm {
    private JRadioButton myXmlRb;
    private JRadioButton myBundledTemplateRb;
    private TextFieldWithBrowseButton myCustomTemplateField;
    private TextFieldWithBrowseButton myFolderField;
    private JPanel myContentPane;
    private JLabel myOutputFolderLabel;
    private JRadioButton myCustomTemplateRb;
    private JTextField myFileNameField;
    private JLabel myMessageLabel;
    private JCheckBox myOpenExportedFileCb;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public ExportTestResultsForm(ExportTestResultsConfiguration config, String defaultFileName, String defaultFolder) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportTestResultsForm.this.updateOnFormatChange();
            }
        };
        this.myXmlRb.addActionListener(listener2);
        this.myBundledTemplateRb.addActionListener(listener2);
        this.myCustomTemplateRb.addActionListener(listener2);
        this.myOutputFolderLabel.setLabelFor(this.myFolderField.getChildComponent());
        this.myFileNameField.setText(defaultFileName);
        this.myCustomTemplateField.addBrowseFolderListener(ExecutionBundle.message((String)"export.test.results.custom.template.chooser.title", (Object[])new Object[0]), null, null, new FileChooserDescriptor(true, false, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file2) {
                return "xsl".equalsIgnoreCase(file2.getExtension()) || "xslt".equalsIgnoreCase(file2.getExtension());
            }
        }, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myFolderField.addBrowseFolderListener(ExecutionBundle.message((String)"export.test.results.output.folder.chooser.title", (Object[])new Object[0]), null, null, FileChooserDescriptorFactory.createSingleFolderDescriptor(), TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myFileNameField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ExportTestResultsForm.this.updateOpenInLabel();
            }
        });
        UserActivityWatcher watcher = new UserActivityWatcher();
        watcher.register((Component)this.myContentPane);
        watcher.addUserActivityListener(new UserActivityListener(){

            public void stateChanged() {
                ((ChangeListener)ExportTestResultsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        JRadioButton b = config.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.Xml ? this.myXmlRb : (config.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.BundledTemplate ? this.myBundledTemplateRb : this.myCustomTemplateRb);
        b.setSelected(true);
        IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus((Component)b, true);
        this.myFolderField.setText(defaultFolder);
        this.myCustomTemplateField.setText(FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)config.getUserTemplatePath())));
        this.myOpenExportedFileCb.setSelected(config.isOpenResults());
        this.updateOnFormatChange();
        this.updateOpenInLabel();
    }

    private void updateOpenInLabel() {
        this.myOpenExportedFileCb.setText(ExecutionBundle.message((String)(ExportTestResultsForm.shouldOpenInBrowser(this.myFileNameField.getText()) ? "export.test.results.open.browser" : "export.test.results.open.editor"), (Object[])new Object[0]));
    }

    public static boolean shouldOpenInBrowser(String filename) {
        return StringUtil.isNotEmpty((String)filename) && (filename.endsWith(".html") || filename.endsWith(".htm"));
    }

    private void updateOnFormatChange() {
        if (this.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.UserTemplate) {
            this.myCustomTemplateField.setEnabled(true);
            IdeFocusManager.findInstanceByComponent((Component)this.myContentPane).requestFocus((Component)this.myCustomTemplateField.getChildComponent(), true);
        } else {
            this.myCustomTemplateField.setEnabled(false);
        }
        String filename = this.myFileNameField.getText();
        if (filename != null && filename.indexOf(46) != -1) {
            this.myFileNameField.setText(filename.substring(0, filename.lastIndexOf(46) + 1) + this.getExportFormat().getDefaultExtension());
        }
    }

    public void apply(ExportTestResultsConfiguration config) {
        config.setExportFormat(this.getExportFormat());
        config.setUserTemplatePath(FileUtil.toSystemIndependentName((String)this.myCustomTemplateField.getText()));
        config.setOutputFolder(FileUtil.toSystemIndependentName((String)this.myFolderField.getText()));
        config.setOpenResults(this.myOpenExportedFileCb.isSelected());
    }

    private ExportTestResultsConfiguration.ExportFormat getExportFormat() {
        if (this.myXmlRb.isSelected()) {
            return ExportTestResultsConfiguration.ExportFormat.Xml;
        }
        if (this.myBundledTemplateRb.isSelected()) {
            return ExportTestResultsConfiguration.ExportFormat.BundledTemplate;
        }
        return ExportTestResultsConfiguration.ExportFormat.UserTemplate;
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.myEventDispatcher.addListener((EventListener)changeListener);
    }

    @Nullable
    public String validate() {
        if (this.getExportFormat() == ExportTestResultsConfiguration.ExportFormat.UserTemplate) {
            if (StringUtil.isEmpty((String)this.myCustomTemplateField.getText())) {
                return ExecutionBundle.message((String)"export.test.results.custom.template.path.empty", (Object[])new Object[0]);
            }
            File file2 = new File(this.myCustomTemplateField.getText());
            if (!file2.isFile()) {
                return ExecutionBundle.message((String)"export.test.results.custom.template.not.found", (Object[])new Object[]{file2.getAbsolutePath()});
            }
        }
        if (StringUtil.isEmpty((String)this.myFileNameField.getText())) {
            return ExecutionBundle.message((String)"export.test.results.output.filename.empty", (Object[])new Object[0]);
        }
        if (StringUtil.isEmpty((String)this.myFolderField.getText())) {
            return ExecutionBundle.message((String)"export.test.results.output.path.empty", (Object[])new Object[0]);
        }
        return null;
    }

    public void showMessage(@Nullable String message2) {
        this.myMessageLabel.setText(message2);
        boolean visible = this.myMessageLabel.isVisible();
        this.myMessageLabel.setVisible(message2 != null);
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myFileNameField;
    }

    public String getFileName() {
        return this.myFileNameField.getText();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JLabel jLabel;
        JTextField jTextField;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JRadioButton jRadioButton3;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel2.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Export format", (int)0, (int)0, null, null));
        this.myBundledTemplateRb = jRadioButton3 = new JRadioButton();
        jRadioButton3.setText("HTML");
        jRadioButton3.setMnemonic('H');
        jRadioButton3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton3, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel2.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myXmlRb = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("XML");
        jRadioButton2.setMnemonic('X');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton2, new GridConstraints(1, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomTemplateRb = jRadioButton = new JRadioButton();
        jRadioButton.setText("Custom, apply XSL template:");
        jRadioButton.setMnemonic('C');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jRadioButton, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myCustomTemplateField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(2, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel3.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Output", (int)0, (int)0, null, null));
        this.myOutputFolderLabel = jLabel2 = new JLabel();
        jLabel2.setText("Folder:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFolderField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("File name:");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(5);
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFileNameField = jTextField = new JTextField();
        jPanel3.add((Component)jTextField, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText(" ");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOpenExportedFileCb = jCheckBox = new JCheckBox();
        jCheckBox.setText("open exported file in browser");
        jPanel.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(jRadioButton3);
        buttonGroup2.add(jRadioButton2);
        buttonGroup2.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

