/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm;

import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import org.jetbrains.annotations.NotNull;

public class ServiceMessageBuilder {
    private final StringBuilder myText = new StringBuilder("##teamcity[");

    public ServiceMessageBuilder(String command) {
        this.myText.append(command);
    }

    public ServiceMessageBuilder addAttribute(String name, String value2) {
        this.myText.append(' ').append(name).append("='").append(ServiceMessageBuilder.replaceEscapeSymbols(value2)).append('\'');
        return this;
    }

    public String toString() {
        return this.myText.toString() + ']';
    }

    private static String replaceEscapeSymbols(String text) {
        return MapSerializerUtil.escapeStr((String)text, (MapSerializerUtil.EscapeInfoProvider)MapSerializerUtil.STD_ESCAPER);
    }

    public static ServiceMessageBuilder testSuiteStarted(@NotNull String name) {
        return new ServiceMessageBuilder("testSuiteStarted").addAttribute("name", name);
    }

    public static ServiceMessageBuilder testSuiteFinished(@NotNull String name) {
        return new ServiceMessageBuilder("testSuiteFinished").addAttribute("name", name);
    }

    public static ServiceMessageBuilder testStarted(@NotNull String name) {
        return new ServiceMessageBuilder("testStarted").addAttribute("name", name);
    }

    public static ServiceMessageBuilder testFinished(@NotNull String name) {
        return new ServiceMessageBuilder("testFinished").addAttribute("name", name);
    }

    public static ServiceMessageBuilder testStdOut(@NotNull String name) {
        return new ServiceMessageBuilder("testStdOut").addAttribute("name", name);
    }

    public static ServiceMessageBuilder testStdErr(@NotNull String name) {
        return new ServiceMessageBuilder("testStdErr").addAttribute("name", name);
    }

    public static ServiceMessageBuilder testFailed(@NotNull String name) {
        return new ServiceMessageBuilder("testFailed").addAttribute("name", name);
    }

    public static ServiceMessageBuilder testIgnored(@NotNull String name) {
        return new ServiceMessageBuilder("testIgnored").addAttribute("name", name);
    }
}

