/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.events.BaseStartedNodeEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralIdBasedToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private final HashMap<String, Node> myNodeByIdMap = new HashMap();
    private final Set<Node> myRunningTestNodes = ContainerUtil.newHashSet();
    private final Set<Node> myRunningSuiteNodes = ContainerUtil.newHashSet();
    private final SMTestProxy.SMRootTestProxy myTestsRootProxy;
    private final Node myTestsRootNode;
    private boolean myIsTestingFinished = false;
    private SMTestLocator myLocator = null;
    private TestProxyPrinterProvider myTestProxyPrinterProvider = null;

    public GeneralIdBasedToSMTRunnerEventsConvertor(Project project2, @NotNull SMTestProxy.SMRootTestProxy testsRootProxy, @NotNull String testFrameworkName) {
        super(project2, testFrameworkName);
        this.myTestsRootProxy = testsRootProxy;
        this.myTestsRootNode = new Node("0", null, testsRootProxy);
        this.myNodeByIdMap.put((Object)this.myTestsRootNode.getId(), (Object)this.myTestsRootNode);
    }

    @Override
    public void setLocator(@NotNull SMTestLocator locator) {
        this.myLocator = locator;
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(() -> {
            this.myTestsRootNode.setState(State.RUNNING, this);
            this.myTestsRootProxy.setStarted();
            this.fireOnTestingStarted(this.myTestsRootProxy);
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(() -> GeneralIdBasedToSMTRunnerEventsConvertor.fireOnTestsReporterAttached(this.myTestsRootProxy));
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(() -> {
            if (this.myIsTestingFinished) {
                return;
            }
            this.myIsTestingFinished = true;
            boolean completeTree = GeneralIdBasedToSMTRunnerEventsConvertor.isTreeComplete(this.myRunningTestNodes, this.myTestsRootProxy);
            if (completeTree) {
                this.myTestsRootProxy.setFinished();
            } else {
                this.myTestsRootProxy.setTerminated();
            }
            if (!this.myRunningTestNodes.isEmpty()) {
                this.logProblem("Unexpected running nodes: " + this.myRunningTestNodes);
            }
            this.myNodeByIdMap.clear();
            this.myRunningTestNodes.clear();
            this.myRunningSuiteNodes.clear();
            this.fireOnTestingFinished(this.myTestsRootProxy);
        });
        this.stopEventProcessing();
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
        this.myTestProxyPrinterProvider = printerProvider;
    }

    @Override
    public void onTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        this.addToInvokeLater(() -> this.doStartNode(testStartedEvent, false));
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        this.addToInvokeLater(() -> this.doStartNode(suiteStartedEvent, true));
    }

    private void doStartNode(@NotNull BaseStartedNodeEvent startedNodeEvent, boolean suite) {
        Printer printer;
        Node node = this.findNode(startedNodeEvent);
        if (node != null) {
            if (node.getState() == State.NOT_RUNNING && startedNodeEvent.isRunning()) {
                this.setNodeAndAncestorsRunning(node);
            } else {
                this.logProblem(startedNodeEvent + " has been already started: " + node + "!");
            }
            return;
        }
        Node parentNode = this.findValidParentNode(startedNodeEvent);
        if (parentNode == null) {
            return;
        }
        String nodeId = this.validateAndGetNodeId(startedNodeEvent);
        if (nodeId == null) {
            return;
        }
        String nodeName = startedNodeEvent.getName();
        SMTestProxy childProxy = new SMTestProxy(nodeName, suite, startedNodeEvent.getLocationUrl(), true);
        childProxy.setTreeBuildBeforeStart();
        TestProxyPrinterProvider printerProvider = this.myTestProxyPrinterProvider;
        String nodeType = startedNodeEvent.getNodeType();
        if (printerProvider != null && nodeType != null && nodeName != null && (printer = printerProvider.getPrinterByType(nodeType, nodeName, startedNodeEvent.getNodeArgs())) != null) {
            childProxy.setPreferredPrinter(printer);
        }
        node = new Node(nodeId, parentNode, childProxy);
        this.myNodeByIdMap.put((Object)startedNodeEvent.getId(), (Object)node);
        if (this.myLocator != null) {
            childProxy.setLocator(this.myLocator);
        }
        parentNode.getProxy().addChild(childProxy);
        if (startedNodeEvent.isRunning()) {
            this.setNodeAndAncestorsRunning(node);
        }
    }

    @Nullable
    private Node findValidParentNode(@NotNull BaseStartedNodeEvent startedNodeEvent) {
        String parentId = startedNodeEvent.getParentId();
        if (parentId == null) {
            this.logProblem("Parent node id should be defined: " + startedNodeEvent + ".", true);
            return null;
        }
        Node parentNode = (Node)this.myNodeByIdMap.get((Object)parentId);
        if (parentNode == null) {
            this.logProblem("Parent node is undefined for " + startedNodeEvent + ".", true);
            return null;
        }
        if (parentNode.getState() != State.NOT_RUNNING && parentNode.getState() != State.RUNNING) {
            this.logProblem("Parent node should be registered or running: " + parentNode + ", " + startedNodeEvent);
            return null;
        }
        return parentNode;
    }

    @Override
    public void onTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        this.addToInvokeLater(() -> {
            Node node = this.findNodeToTerminate(testFinishedEvent);
            if (node != null) {
                SMTestProxy testProxy = node.getProxy();
                Long duration = testFinishedEvent.getDuration();
                if (duration != null) {
                    testProxy.setDuration(duration);
                }
                testProxy.setFrameworkOutputFile(testFinishedEvent.getOutputFile());
                testProxy.setFinished();
                if (node.getState() != State.FAILED) {
                    this.fireOnTestFinished(testProxy);
                }
                this.terminateNode(node, State.FINISHED);
            }
        });
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        this.addToInvokeLater(() -> {
            Node node = this.findNodeToTerminate(suiteFinishedEvent);
            if (node != null) {
                SMTestProxy suiteProxy = node.getProxy();
                suiteProxy.setFinished();
                this.fireOnSuiteFinished(suiteProxy);
                this.terminateNode(node, State.FINISHED);
            }
        });
    }

    @Nullable
    private Node findNodeToTerminate(@NotNull TreeNodeEvent treeNodeEvent) {
        Node node = this.findNode(treeNodeEvent);
        if (node == null) {
            this.logProblem("Trying to finish nonexistent node: " + treeNodeEvent);
            return null;
        }
        return node;
    }

    @Override
    public void onUncapturedOutput(@NotNull String text, Key outputType) {
        this.addToInvokeLater(() -> {
            Node activeNode = this.findActiveNode();
            SMTestProxy activeProxy = activeNode.getProxy();
            if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                activeProxy.addStdErr(text);
            } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                activeProxy.addSystemOutput(text);
            } else {
                activeProxy.addStdOutput(text, outputType);
            }
        });
    }

    @Override
    public void onError(@NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.onError(null, localizedMessage, stackTrace, isCritical);
    }

    public void onError(@Nullable String nodeId, @NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.addToInvokeLater(() -> {
            SMTestProxy activeProxy = null;
            if (nodeId != null) {
                activeProxy = this.findProxyById(nodeId);
            }
            if (activeProxy == null) {
                Node activeNode = this.findActiveNode();
                activeProxy = activeNode.getProxy();
            }
            activeProxy.addError(localizedMessage, stackTrace, isCritical);
        });
    }

    @Override
    public void onTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        this.addToInvokeLater(() -> {
            Node node = this.findNodeToTerminate(testFailedEvent);
            if (node == null) {
                return;
            }
            SMTestProxy testProxy = node.getProxy();
            String comparisonFailureActualText = testFailedEvent.getComparisonFailureActualText();
            String comparisonFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
            String failureMessage = testFailedEvent.getLocalizedFailureMessage();
            String stackTrace = testFailedEvent.getStacktrace();
            if (comparisonFailureActualText != null && comparisonFailureExpectedText != null) {
                testProxy.setTestComparisonFailed(failureMessage, stackTrace, comparisonFailureActualText, comparisonFailureExpectedText, testFailedEvent);
            } else if (comparisonFailureActualText == null && comparisonFailureExpectedText == null) {
                testProxy.setTestFailed(failureMessage, stackTrace, testFailedEvent.isTestError());
            } else {
                this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisonFailureExpectedText + "\nActual:\n" + comparisonFailureActualText);
            }
            long duration = testFailedEvent.getDurationMillis();
            if (duration >= 0L) {
                testProxy.setDuration(duration);
            }
            this.fireOnTestFinished(testProxy);
            this.fireOnTestFailed(testProxy);
            this.terminateNode(node, State.FAILED);
        });
    }

    @Override
    public void onTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        this.addToInvokeLater(() -> {
            Node node = this.findNodeToTerminate(testIgnoredEvent);
            if (node != null) {
                SMTestProxy testProxy = node.getProxy();
                testProxy.setTestIgnored(testIgnoredEvent.getIgnoreComment(), testIgnoredEvent.getStacktrace());
                this.fireOnTestIgnored(testProxy);
                this.terminateNode(node, State.IGNORED);
            }
        });
    }

    @Override
    public void onTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        this.addToInvokeLater(() -> {
            Node node = this.findNode(testOutputEvent);
            if (node == null) {
                this.logProblem("Test wasn't started! But " + testOutputEvent + "!");
                return;
            }
            SMTestProxy testProxy = node.getProxy();
            if (testOutputEvent.isStdOut()) {
                testProxy.addStdOutput(testOutputEvent.getText(), ProcessOutputTypes.STDOUT);
            } else {
                testProxy.addStdErr(testOutputEvent.getText());
            }
        });
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.addToInvokeLater(() -> this.fireOnTestsCountInSuite(count));
    }

    @Nullable
    private String validateAndGetNodeId(@NotNull TreeNodeEvent treeNodeEvent) {
        String nodeId = treeNodeEvent.getId();
        if (nodeId == null || nodeId.equals("0")) {
            this.logProblem((nodeId == null ? "Missing" : "Illegal") + " nodeId: " + treeNodeEvent, true);
        }
        return nodeId;
    }

    @Nullable
    private Node findNode(@NotNull TreeNodeEvent treeNodeEvent) {
        String nodeId = this.validateAndGetNodeId(treeNodeEvent);
        return nodeId != null ? (Node)this.myNodeByIdMap.get((Object)nodeId) : null;
    }

    @Nullable
    public SMTestProxy findProxyById(@NotNull String id) {
        Node node = (Node)this.myNodeByIdMap.get((Object)id);
        return node != null ? node.getProxy() : null;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(() -> {
            Application application;
            this.disconnectListeners();
            if (!(this.myRunningTestNodes.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                this.logProblem("Not all events were processed!");
            }
            this.myRunningTestNodes.clear();
            this.myRunningSuiteNodes.clear();
            this.myNodeByIdMap.clear();
        });
    }

    private void setNodeAndAncestorsRunning(@NotNull Node lowestNode) {
        for (Node node = lowestNode; node != null && node != this.myTestsRootNode && node.getState() == State.NOT_RUNNING; node = node.getParentNode()) {
            node.setState(State.RUNNING, this);
            SMTestProxy proxy = node.getProxy();
            proxy.setStarted();
            if (proxy.isSuite()) {
                this.myRunningSuiteNodes.add(node);
                this.fireOnSuiteStarted(proxy);
                continue;
            }
            this.myRunningTestNodes.add(lowestNode);
            this.fireOnTestStarted(proxy);
        }
    }

    private void terminateNode(@NotNull Node node, @NotNull State terminateState) {
        node.setState(terminateState, this);
        this.myRunningTestNodes.remove(node);
        this.myRunningSuiteNodes.remove(node);
    }

    @NotNull
    private Node findActiveNode() {
        if (!this.myRunningTestNodes.isEmpty()) {
            return this.myRunningTestNodes.iterator().next();
        }
        if (!this.myRunningSuiteNodes.isEmpty()) {
            return this.myRunningSuiteNodes.iterator().next();
        }
        return this.myTestsRootNode;
    }

    @Override
    public void onRootPresentationAdded(String rootName, String comment, String rootLocation) {
        this.addToInvokeLater(() -> {
            this.myTestsRootProxy.setPresentation(rootName);
            this.myTestsRootProxy.setComment(comment);
            this.myTestsRootProxy.setRootLocationUrl(rootLocation);
            if (this.myLocator != null) {
                this.myTestsRootProxy.setLocator(this.myLocator);
            }
        });
    }

    private static class Node {
        private final String myId;
        private final Node myParentNode;
        private final SMTestProxy myProxy;
        private State myState;

        Node(@NotNull String id, @Nullable Node parentNode, @NotNull SMTestProxy proxy) {
            this.myId = id;
            this.myParentNode = parentNode;
            this.myProxy = proxy;
            this.myState = State.NOT_RUNNING;
        }

        @NotNull
        public String getId() {
            return this.myId;
        }

        @Nullable
        public Node getParentNode() {
            return this.myParentNode;
        }

        @NotNull
        public SMTestProxy getProxy() {
            return this.myProxy;
        }

        @NotNull
        public State getState() {
            return this.myState;
        }

        public void setState(@NotNull State newState, @NotNull GeneralIdBasedToSMTRunnerEventsConvertor convertor) {
            if (this.myState == State.NOT_RUNNING && newState != State.RUNNING && newState != State.IGNORED || this.myState == State.RUNNING && newState != State.FINISHED && newState != State.FAILED && newState != State.IGNORED || this.myState == State.FINISHED && newState != State.FAILED || this.myState == State.FAILED && newState != State.FINISHED || this.myState == State.IGNORED && newState != State.FINISHED) {
                convertor.logProblem("Illegal state change [" + (Object)((Object)this.myState) + " -> " + (Object)((Object)newState) + "]: " + this.toString(), false);
            }
            if (this.myState.ordinal() < newState.ordinal()) {
                this.myState = newState;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return this.myId == node.myId;
        }

        public int hashCode() {
            return this.myId.hashCode();
        }

        public String toString() {
            return "{id=" + this.myId + ", parentId=" + (this.myParentNode != null ? String.valueOf(this.myParentNode.getId()) : "<undefined>") + ", name='" + this.myProxy.getName() + "', isSuite=" + this.myProxy.isSuite() + ", state=" + (Object)((Object)this.myState) + '}';
        }
    }

    private static enum State {
        NOT_RUNNING,
        RUNNING,
        FINISHED,
        FAILED,
        IGNORED;

    }
}

