/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.GeneralTestEventsProcessor;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.TestProxyPrinterProvider;
import com.intellij.execution.testframework.sm.runner.TestSuiteStack;
import com.intellij.execution.testframework.sm.runner.events.TestFailedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestIgnoredEvent;
import com.intellij.execution.testframework.sm.runner.events.TestOutputEvent;
import com.intellij.execution.testframework.sm.runner.events.TestStartedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteFinishedEvent;
import com.intellij.execution.testframework.sm.runner.events.TestSuiteStartedEvent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeneralToSMTRunnerEventsConvertor
extends GeneralTestEventsProcessor {
    private final Map<String, SMTestProxy> myRunningTestsFullNameToProxy = new HashMap<String, SMTestProxy>();
    private final TestSuiteStack mySuitesStack;
    private final Set<SMTestProxy> myCurrentChildren = new LinkedHashSet<SMTestProxy>();
    private boolean myGetChildren = true;
    private final SMTestProxy.SMRootTestProxy myTestsRootNode;
    private boolean myIsTestingFinished;
    private SMTestLocator myLocator = null;
    private boolean myTreeBuildBeforeStart = false;
    private final List<Runnable> myBuildTreeRunnables = new ArrayList<Runnable>();

    public GeneralToSMTRunnerEventsConvertor(Project project2, @NotNull SMTestProxy.SMRootTestProxy testsRootNode, @NotNull String testFrameworkName) {
        super(project2, testFrameworkName);
        this.myTestsRootNode = testsRootNode;
        this.mySuitesStack = new TestSuiteStack(testFrameworkName);
    }

    @Override
    public void setLocator(@NotNull SMTestLocator locator) {
        this.myLocator = locator;
    }

    @Override
    public void onStartTesting() {
        this.addToInvokeLater(() -> {
            this.mySuitesStack.pushSuite(this.myTestsRootNode);
            this.myTestsRootNode.setStarted();
            this.fireOnTestingStarted(this.myTestsRootNode);
        });
    }

    @Override
    public void onTestsReporterAttached() {
        this.addToInvokeLater(() -> GeneralToSMTRunnerEventsConvertor.fireOnTestsReporterAttached(this.myTestsRootNode));
    }

    @Override
    public void onFinishTesting() {
        this.addToInvokeLater(() -> {
            if (this.myIsTestingFinished) {
                return;
            }
            this.myIsTestingFinished = true;
            if (!GeneralToSMTRunnerEventsConvertor.isTreeComplete(this.myRunningTestsFullNameToProxy.keySet(), this.myTestsRootNode)) {
                this.myTestsRootNode.setTerminated();
                this.myRunningTestsFullNameToProxy.clear();
            }
            this.mySuitesStack.clear();
            this.myTestsRootNode.setFinished();
            this.fireOnTestingFinished(this.myTestsRootNode);
        });
        this.stopEventProcessing();
    }

    @Override
    public void onRootPresentationAdded(String rootName, String comment, String rootLocation) {
        this.addToInvokeLater(() -> {
            this.myTestsRootNode.setPresentation(rootName);
            this.myTestsRootNode.setComment(comment);
            this.myTestsRootNode.setRootLocationUrl(rootLocation);
            if (this.myLocator != null) {
                this.myTestsRootNode.setLocator(this.myLocator);
            }
        });
    }

    @Override
    public void onSuiteTreeNodeAdded(String testName, String locationHint) {
        this.myTreeBuildBeforeStart = true;
        this.myBuildTreeRunnables.add(() -> {
            SMTestProxy testProxy = new SMTestProxy(testName, false, locationHint);
            testProxy.setTreeBuildBeforeStart();
            if (this.myLocator != null) {
                testProxy.setLocator(this.myLocator);
            }
            SMTestProxy currentSuite = this.getCurrentSuite();
            currentSuite.setTreeBuildBeforeStart();
            currentSuite.addChild(testProxy);
            this.myEventPublisher.onSuiteTreeNodeAdded(testProxy);
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onSuiteTreeNodeAdded(testProxy);
            }
        });
    }

    @Override
    public void onSuiteTreeStarted(String suiteName, String locationHint) {
        this.myTreeBuildBeforeStart = true;
        this.myBuildTreeRunnables.add(() -> {
            SMTestProxy parentSuite = this.getCurrentSuite();
            SMTestProxy newSuite = new SMTestProxy(suiteName, true, locationHint);
            if (this.myLocator != null) {
                newSuite.setLocator(this.myLocator);
            }
            parentSuite.addChild(newSuite);
            this.mySuitesStack.pushSuite(newSuite);
            this.myEventPublisher.onSuiteTreeStarted(newSuite);
            for (SMTRunnerEventsListener adapter : this.myListenerAdapters) {
                adapter.onSuiteTreeStarted(newSuite);
            }
        });
    }

    @Override
    public void onSuiteTreeEnded(String suiteName) {
        this.myBuildTreeRunnables.add(() -> this.mySuitesStack.popSuite(suiteName));
        if (this.myBuildTreeRunnables.size() > 100) {
            ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.myBuildTreeRunnables);
            this.myBuildTreeRunnables.clear();
            this.processTreeBuildEvents(runnables);
        }
    }

    @Override
    public void onBuildTreeEnded() {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>(this.myBuildTreeRunnables);
        this.myBuildTreeRunnables.clear();
        this.processTreeBuildEvents(runnables);
    }

    private void processTreeBuildEvents(List<Runnable> runnables) {
        this.addToInvokeLater(() -> {
            for (Runnable runnable2 : runnables) {
                runnable2.run();
            }
            runnables.clear();
        });
    }

    @Override
    public void setPrinterProvider(@NotNull TestProxyPrinterProvider printerProvider) {
    }

    @Override
    public void onTestStarted(@NotNull TestStartedEvent testStartedEvent) {
        this.addToInvokeLater(() -> {
            SMTestProxy testProxy;
            String testName = testStartedEvent.getName();
            String locationUrl = testStartedEvent.getLocationUrl();
            boolean isConfig = testStartedEvent.isConfig();
            String fullName = this.getFullTestName(testName);
            if (this.myRunningTestsFullNameToProxy.containsKey(fullName)) {
                this.logProblem("Test [" + fullName + "] has been already started");
                if (SMTestRunnerConnectionUtil.isInDebugMode()) {
                    return;
                }
            }
            SMTestProxy parentSuite = this.getCurrentSuite();
            SMTestProxy sMTestProxy = testProxy = locationUrl != null ? this.findChildByLocation(parentSuite, locationUrl) : this.findChildByName(parentSuite, fullName);
            if (testProxy == null) {
                testProxy = new SMTestProxy(testName, false, locationUrl);
                testProxy.setConfig(isConfig);
                if (this.myTreeBuildBeforeStart) {
                    testProxy.setTreeBuildBeforeStart();
                }
                if (this.myLocator != null) {
                    testProxy.setLocator(this.myLocator);
                }
                parentSuite.addChild(testProxy);
                if (this.myTreeBuildBeforeStart && this.myGetChildren) {
                    for (SMTestProxy sMTestProxy2 : parentSuite.getChildren()) {
                        if (sMTestProxy2.isFinal()) continue;
                        this.myCurrentChildren.add(sMTestProxy2);
                    }
                    this.myGetChildren = false;
                }
            }
            this.myRunningTestsFullNameToProxy.put(fullName, testProxy);
            testProxy.setStarted();
            this.fireOnTestStarted(testProxy);
        });
    }

    @Override
    public void onSuiteStarted(@NotNull TestSuiteStartedEvent suiteStartedEvent) {
        this.addToInvokeLater(() -> {
            SMTestProxy newSuite;
            String suiteName = suiteStartedEvent.getName();
            String locationUrl = suiteStartedEvent.getLocationUrl();
            SMTestProxy parentSuite = this.getCurrentSuite();
            SMTestProxy sMTestProxy = newSuite = locationUrl != null ? this.findChildByLocation(parentSuite, locationUrl) : this.findChildByName(parentSuite, suiteName);
            if (newSuite == null) {
                newSuite = new SMTestProxy(suiteName, true, locationUrl, parentSuite.isPreservePresentableName());
                if (this.myTreeBuildBeforeStart) {
                    newSuite.setTreeBuildBeforeStart();
                }
                if (this.myLocator != null) {
                    newSuite.setLocator(this.myLocator);
                }
                parentSuite.addChild(newSuite);
            }
            this.myGetChildren = true;
            this.mySuitesStack.pushSuite(newSuite);
            newSuite.setSuiteStarted();
            this.fireOnSuiteStarted(newSuite);
        });
    }

    private SMTestProxy findChildByName(SMTestProxy parentSuite, String fullName) {
        return this.findChild(parentSuite, fullName, (Function<SMTestProxy, String>)((Function)SMTestProxy::getName));
    }

    private SMTestProxy findChildByLocation(SMTestProxy parentSuite, String fullName) {
        return this.findChild(parentSuite, fullName, (Function<SMTestProxy, String>)((Function)SMTestProxy::getLocationUrl));
    }

    private SMTestProxy findChild(SMTestProxy parentSuite, String fullName, Function<SMTestProxy, String> nameFunction) {
        if (this.myTreeBuildBeforeStart) {
            Collection<SMTestProxy> children2 = this.myGetChildren ? parentSuite.getChildren() : this.myCurrentChildren;
            for (SMTestProxy proxy : children2) {
                if (!fullName.equals(nameFunction.fun((Object)proxy)) || proxy.isFinal()) continue;
                return proxy;
            }
        }
        return null;
    }

    @Override
    public void onTestFinished(@NotNull TestFinishedEvent testFinishedEvent) {
        this.addToInvokeLater(() -> {
            String testName = testFinishedEvent.getName();
            Long duration = testFinishedEvent.getDuration();
            String fullTestName = this.getFullTestName(testName);
            SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
            if (testProxy == null) {
                this.logProblem("Test wasn't started! TestFinished event: name = {" + testName + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
                return;
            }
            testProxy.setDuration(duration != null ? duration : 0L);
            testProxy.setFrameworkOutputFile(testFinishedEvent.getOutputFile());
            testProxy.setFinished();
            this.myRunningTestsFullNameToProxy.remove(fullTestName);
            this.myCurrentChildren.remove(testProxy);
            this.fireOnTestFinished(testProxy);
        });
    }

    @Override
    public void onSuiteFinished(@NotNull TestSuiteFinishedEvent suiteFinishedEvent) {
        this.addToInvokeLater(() -> {
            String suiteName = suiteFinishedEvent.getName();
            SMTestProxy mySuite = this.mySuitesStack.popSuite(suiteName);
            if (mySuite != null) {
                mySuite.setFinished();
                this.myCurrentChildren.clear();
                this.myGetChildren = true;
                this.fireOnSuiteFinished(mySuite);
            }
        });
    }

    @Override
    public void onUncapturedOutput(@NotNull String text, Key outputType) {
        this.addToInvokeLater(() -> {
            SMTestProxy currentProxy = this.findCurrentTestOrSuite();
            if (ProcessOutputTypes.STDERR.equals((Object)outputType)) {
                currentProxy.addStdErr(text);
            } else if (ProcessOutputTypes.SYSTEM.equals((Object)outputType)) {
                currentProxy.addSystemOutput(text);
            } else {
                currentProxy.addStdOutput(text, outputType);
            }
        });
    }

    @Override
    public void onError(@NotNull String localizedMessage, @Nullable String stackTrace, boolean isCritical) {
        this.addToInvokeLater(() -> {
            SMTestProxy currentProxy = this.findCurrentTestOrSuite();
            currentProxy.addError(localizedMessage, stackTrace, isCritical);
        });
    }

    @Override
    public void onTestFailure(@NotNull TestFailedEvent testFailedEvent) {
        this.addToInvokeLater(() -> {
            String testName = testFailedEvent.getName();
            if (testName == null) {
                this.logProblem("No test name specified in " + testFailedEvent);
                return;
            }
            String localizedMessage = testFailedEvent.getLocalizedFailureMessage();
            String stackTrace = testFailedEvent.getStacktrace();
            boolean isTestError = testFailedEvent.isTestError();
            String comparisionFailureActualText = testFailedEvent.getComparisonFailureActualText();
            String comparisionFailureExpectedText = testFailedEvent.getComparisonFailureExpectedText();
            boolean inDebugMode = SMTestRunnerConnectionUtil.isInDebugMode();
            String fullTestName = this.getFullTestName(testName);
            SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
            if (testProxy == null) {
                this.logProblem("Test wasn't started! TestFailure event: name = {" + testName + "}, message = {" + localizedMessage + "}, stackTrace = {" + stackTrace + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
                if (inDebugMode) {
                    return;
                }
                this.onTestStarted(new TestStartedEvent(testName, null));
                testProxy = this.getProxyByFullTestName(fullTestName);
            }
            if (testProxy == null) {
                return;
            }
            if (comparisionFailureActualText != null && comparisionFailureExpectedText != null) {
                testProxy.setTestComparisonFailed(localizedMessage, stackTrace, comparisionFailureActualText, comparisionFailureExpectedText, testFailedEvent);
            } else if (comparisionFailureActualText == null && comparisionFailureExpectedText == null) {
                testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
            } else {
                testProxy.setTestFailed(localizedMessage, stackTrace, isTestError);
                this.logProblem("Comparison failure actual and expected texts should be both null or not null.\nExpected:\n" + comparisionFailureExpectedText + "\nActual:\n" + comparisionFailureActualText);
            }
            this.fireOnTestFailed(testProxy);
        });
    }

    @Override
    public void onTestIgnored(@NotNull TestIgnoredEvent testIgnoredEvent) {
        this.addToInvokeLater(() -> {
            String testName = testIgnoredEvent.getName();
            if (testName == null) {
                this.logProblem("TestIgnored event: no name");
            }
            String ignoreComment = testIgnoredEvent.getIgnoreComment();
            String stackTrace = testIgnoredEvent.getStacktrace();
            String fullTestName = this.getFullTestName(testName);
            SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
            if (testProxy == null) {
                boolean debugMode = SMTestRunnerConnectionUtil.isInDebugMode();
                this.logProblem("Test wasn't started! TestIgnored event: name = {" + testName + "}, message = {" + ignoreComment + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
                if (debugMode) {
                    return;
                }
                this.onTestStarted(new TestStartedEvent(testName, null));
                testProxy = this.getProxyByFullTestName(fullTestName);
            }
            if (testProxy == null) {
                return;
            }
            testProxy.setTestIgnored(ignoreComment, stackTrace);
            this.fireOnTestIgnored(testProxy);
        });
    }

    @Override
    public void onTestOutput(@NotNull TestOutputEvent testOutputEvent) {
        this.addToInvokeLater(() -> {
            String testName = testOutputEvent.getName();
            String text = testOutputEvent.getText();
            boolean stdOut = testOutputEvent.isStdOut();
            String fullTestName = this.getFullTestName(testName);
            SMTestProxy testProxy = this.getProxyByFullTestName(fullTestName);
            if (testProxy == null) {
                this.logProblem("Test wasn't started! TestOutput event: name = {" + testName + "}, isStdOut = " + stdOut + ", text = {" + text + "}. " + this.cannotFindFullTestNameMsg(fullTestName));
                return;
            }
            if (stdOut) {
                testProxy.addStdOutput(text, ProcessOutputTypes.STDOUT);
            } else {
                testProxy.addStdErr(text);
            }
        });
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.addToInvokeLater(() -> this.fireOnTestsCountInSuite(count));
    }

    @NotNull
    protected final SMTestProxy getCurrentSuite() {
        SMTestProxy currentSuite = this.mySuitesStack.getCurrentSuite();
        if (currentSuite != null) {
            return currentSuite;
        }
        this.logProblem("Current suite is undefined. Root suite will be used.");
        this.myGetChildren = true;
        return this.myTestsRootNode;
    }

    protected String getFullTestName(String testName) {
        return testName;
    }

    protected int getRunningTestsQuantity() {
        return this.myRunningTestsFullNameToProxy.size();
    }

    @Nullable
    protected SMTestProxy getProxyByFullTestName(String fullTestName) {
        return this.myRunningTestsFullNameToProxy.get(fullTestName);
    }

    protected void clearInternalSuitesStack() {
        this.mySuitesStack.clear();
    }

    private String cannotFindFullTestNameMsg(String fullTestName) {
        return "Cant find running test for [" + fullTestName + "]. Current running tests: {" + this.dumpRunningTestsNames() + "}";
    }

    private StringBuilder dumpRunningTestsNames() {
        Set<String> names = this.myRunningTestsFullNameToProxy.keySet();
        StringBuilder namesDump = new StringBuilder();
        for (String name : names) {
            namesDump.append('[').append(name).append(']').append(',');
        }
        return namesDump;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.addToInvokeLater(() -> {
            Application application;
            this.disconnectListeners();
            if (!(this.myRunningTestsFullNameToProxy.isEmpty() || (application = ApplicationManager.getApplication()).isHeadlessEnvironment() || application.isUnitTestMode())) {
                this.logProblem("Not all events were processed! " + this.dumpRunningTestsNames());
            }
            this.myRunningTestsFullNameToProxy.clear();
            this.mySuitesStack.clear();
        });
    }

    private SMTestProxy findCurrentTestOrSuite() {
        SMTestProxy currentProxy = this.myRunningTestsFullNameToProxy.size() == 1 ? this.myRunningTestsFullNameToProxy.values().iterator().next() : (this.mySuitesStack.isEmpty() ? this.myTestsRootNode : this.getCurrentSuite());
        return currentProxy;
    }
}

