/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.util.text.StringUtil;
import jetbrains.buildServer.messages.serviceMessages.MessageWithAttributes;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseStartedNodeEvent
extends TreeNodeEvent {
    private final String myParentId;
    private final String myLocationUrl;
    private final String myNodeType;
    private final String myNodeArgs;
    private final boolean myRunning;

    protected BaseStartedNodeEvent(@Nullable String name, @Nullable String id, @Nullable String parentId, @Nullable String locationUrl, @Nullable String nodeType, @Nullable String nodeArgs, boolean running) {
        super(name, id);
        this.myParentId = parentId;
        this.myLocationUrl = locationUrl;
        this.myNodeType = nodeType;
        this.myNodeArgs = nodeArgs;
        this.myRunning = running;
    }

    @Nullable
    public String getParentId() {
        return this.myParentId;
    }

    @Nullable
    public String getLocationUrl() {
        return this.myLocationUrl;
    }

    @Nullable
    public String getNodeType() {
        return this.myNodeType;
    }

    @Nullable
    public String getNodeArgs() {
        return this.myNodeArgs;
    }

    public boolean isRunning() {
        return this.myRunning;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        BaseStartedNodeEvent.append(buf, "parentId", this.myParentId);
        BaseStartedNodeEvent.append(buf, "locationUrl", this.myLocationUrl);
        BaseStartedNodeEvent.append(buf, "running", this.myRunning);
    }

    @Nullable
    public static String getParentNodeId(@NotNull MessageWithAttributes message2) {
        return TreeNodeEvent.getNodeId((ServiceMessage)message2, "parentNodeId");
    }

    @Nullable
    public static String getNodeType(@NotNull MessageWithAttributes message2) {
        return (String)message2.getAttributes().get("nodeType");
    }

    @Nullable
    public static String getNodeArgs(@NotNull MessageWithAttributes message2) {
        return (String)message2.getAttributes().get("nodeArgs");
    }

    public static boolean isRunning(@NotNull MessageWithAttributes message2) {
        String runningStr = (String)message2.getAttributes().get("running");
        if (StringUtil.isEmpty((String)runningStr)) {
            return true;
        }
        return Boolean.parseBoolean(runningStr);
    }
}

