/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.history.actions;

import com.intellij.execution.TestStateStorage;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromFileAction;
import com.intellij.execution.testframework.sm.runner.history.actions.ImportTestsFromHistoryAction;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportTestsGroup
extends ActionGroup {
    private SMTRunnerConsoleProperties myProperties;

    public ImportTestsGroup() {
        super("Import Test Results", "Import Test Results", AllIcons.Vcs.History);
        this.setPopup(true);
    }

    public ImportTestsGroup(SMTRunnerConsoleProperties properties) {
        this();
        this.myProperties = properties;
    }

    @NotNull
    public AnAction[] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            return EMPTY_ARRAY;
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return EMPTY_ARRAY;
        }
        Collection<String> filePaths = TestHistoryConfiguration.getInstance(project2).getFiles();
        File testHistoryRoot = TestStateStorage.getTestHistoryRoot(project2);
        List fileNames = ContainerUtil.map(filePaths, fileName -> new File(testHistoryRoot, (String)fileName));
        Collections.sort(fileNames, (f1, f2) -> f1.lastModified() > f2.lastModified() ? -1 : 1);
        int historySize = fileNames.size();
        AnAction[] actions = new AnAction[historySize + 2];
        for (int i2 = 0; i2 < historySize; ++i2) {
            actions[i2] = new ImportTestsFromHistoryAction(this.myProperties, project2, ((File)fileNames.get(i2)).getName());
        }
        actions[historySize] = Separator.getInstance();
        actions[historySize + 1] = new ImportTestsFromFileAction(this.myProperties);
        return actions;
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(e.getProject() != null);
    }
}

