/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.states;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.states.AbstractState;
import com.intellij.execution.testframework.sm.runner.states.TestStateInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestFailedState
extends AbstractState
implements Disposable {
    private final List<String> myPresentationText;

    public TestFailedState(@Nullable String localizedMessage, @Nullable String stackTrace) {
        this.myPresentationText = ContainerUtil.createLockFreeCopyOnWriteList(Collections.singleton(TestFailedState.buildErrorPresentationText(localizedMessage, stackTrace)));
    }

    public void addError(@Nullable String localizedMessage, @Nullable String stackTrace, Printer printer) {
        String msg = TestFailedState.buildErrorPresentationText(localizedMessage, stackTrace);
        if (msg != null) {
            this.myPresentationText.add(msg);
            if (printer != null) {
                TestFailedState.printError(printer, Arrays.asList(msg), false);
            }
        }
    }

    public void dispose() {
    }

    @Nullable
    public static String buildErrorPresentationText(@Nullable String localizedMessage, @Nullable String stackTrace) {
        String text = (StringUtil.isEmptyOrSpaces((String)localizedMessage) ? "" : localizedMessage + "\n") + (StringUtil.isEmptyOrSpaces((String)stackTrace) ? "" : stackTrace + "\n");
        return StringUtil.isEmptyOrSpaces((String)text) ? null : text;
    }

    public static void printError(@NotNull Printer printer, @NotNull List<String> errorPresentationText) {
        TestFailedState.printError(printer, errorPresentationText, true);
    }

    private static void printError(@NotNull Printer printer, @NotNull List<String> errorPresentationText, boolean setMark) {
        boolean addMark = setMark;
        for (String errorText : errorPresentationText) {
            if (errorText == null) continue;
            printer.print("\n", ConsoleViewContentType.ERROR_OUTPUT);
            if (addMark) {
                printer.mark();
                addMark = false;
            }
            printer.printWithAnsiColoring(errorText, ProcessOutputTypes.STDERR);
        }
    }

    @Override
    public void printOn(Printer printer) {
        super.printOn(printer);
        TestFailedState.printError(printer, this.myPresentationText);
    }

    public boolean isDefect() {
        return true;
    }

    public boolean wasLaunched() {
        return true;
    }

    public boolean isFinal() {
        return true;
    }

    public boolean isInProgress() {
        return false;
    }

    public boolean wasTerminated() {
        return false;
    }

    public TestStateInfo.Magnitude getMagnitude() {
        return TestStateInfo.Magnitude.FAILED_INDEX;
    }

    public String toString() {
        return "TEST FAILED";
    }
}

