/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.concurrency.JobScheduler;
import com.intellij.execution.TestStateStorage;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.LvcsHelper;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.execution.testframework.ToolbarPanel;
import com.intellij.execution.testframework.TrackRunningTestUtil;
import com.intellij.execution.testframework.actions.ScrollToTestSourceAction;
import com.intellij.execution.testframework.export.TestResultsXmlFormatter;
import com.intellij.execution.testframework.sm.SMRunnerUtil;
import com.intellij.execution.testframework.sm.TestHistoryConfiguration;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsListener;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeBuilder;
import com.intellij.execution.testframework.sm.runner.SMTRunnerTreeStructure;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.history.ImportedTestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.history.actions.AbstractImportTestsAction;
import com.intellij.execution.testframework.sm.runner.ui.PropagateSelectionHandler;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerToolbarPanel;
import com.intellij.execution.testframework.sm.runner.ui.TestResultsViewer;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.execution.testframework.ui.TestResultsPanel;
import com.intellij.execution.testframework.ui.TestsProgressAnimator;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.progress.util.ColorProgressBar;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.ui.JBColor;
import com.intellij.util.OpenSourceUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SMTestRunnerResultsForm
extends TestResultsPanel
implements TestFrameworkRunningModel,
TestResultsViewer,
SMTRunnerEventsListener {
    @NonNls
    public static final String HISTORY_DATE_FORMAT = "yyyy.MM.dd 'at' HH'h' mm'm' ss's'";
    @NonNls
    private static final String DEFAULT_SM_RUNNER_SPLITTER_PROPERTY = "SMTestRunner.Splitter.Proportion";
    public static final Color DARK_YELLOW = JBColor.YELLOW.darker();
    private static final Logger LOG = Logger.getInstance((String)("#" + SMTestRunnerResultsForm.class.getName()));
    private SMTRunnerTestTreeView myTreeView;
    private TestsProgressAnimator myAnimator;
    private final SMTestProxy.SMRootTestProxy myTestsRootNode;
    private SMTRunnerTreeBuilder myTreeBuilder;
    private final List<TestResultsViewer.EventsListener> myEventListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private PropagateSelectionHandler myShowStatisticForProxyHandler;
    private final Project myProject;
    private int myTotalTestCount = 0;
    private int myStartedTestCount = 0;
    private int myFinishedTestCount = 0;
    private int myFailedTestCount = 0;
    private int myIgnoredTestCount = 0;
    private long myStartTime;
    private long myEndTime;
    private String myCurrentCustomProgressCategory;
    private final Set<String> myMentionedCategories = new LinkedHashSet<String>();
    private boolean myTestsRunning = true;
    private AbstractTestProxy myLastSelected;
    private final Set<Update> myRequests = Collections.synchronizedSet(new HashSet());
    private boolean myDisposed = false;
    private SMTestProxy myLastFailed;

    public SMTestRunnerResultsForm(@NotNull JComponent console, TestConsoleProperties consoleProperties) {
        this(console, AnAction.EMPTY_ARRAY, consoleProperties, null);
    }

    public SMTestRunnerResultsForm(@NotNull JComponent console, AnAction[] consoleActions, TestConsoleProperties consoleProperties, @Nullable String splitterPropertyName) {
        super(console, consoleActions, consoleProperties, StringUtil.notNullize((String)splitterPropertyName, (String)DEFAULT_SM_RUNNER_SPLITTER_PROPERTY), 0.2f);
        this.myProject = consoleProperties.getProject();
        this.myTestsRootNode = new SMTestProxy.SMRootTestProxy(consoleProperties.isPreservePresentableName());
    }

    @Override
    protected ToolbarPanel createToolbarPanel() {
        return new SMTRunnerToolbarPanel(this.myProperties, this, this);
    }

    @Override
    protected JComponent createTestTreeView() {
        this.myTreeView = new SMTRunnerTestTreeView();
        this.myTreeView.setLargeModel(true);
        this.myTreeView.attachToModel(this);
        this.myTreeView.setTestResultsViewer(this);
        SMTRunnerTreeStructure structure = new SMTRunnerTreeStructure(this.myProject, this.myTestsRootNode);
        this.myTreeBuilder = new SMTRunnerTreeBuilder((JTree)((Object)this.myTreeView), structure);
        this.myTreeBuilder.setTestsComparator(this.myProperties);
        Disposer.register((Disposable)this, (Disposable)this.myTreeBuilder);
        this.myAnimator = new TestsProgressAnimator(this.myTreeBuilder);
        TrackRunningTestUtil.installStopListeners((JTree)((Object)this.myTreeView), this.myProperties, new Pass<AbstractTestProxy>(){

            public void pass(AbstractTestProxy testProxy) {
                Navigatable descriptor;
                AbstractTestProxy firstChild;
                List<? extends AbstractTestProxy> children2;
                if (testProxy == null) {
                    return;
                }
                AbstractTestProxy selectedProxy = testProxy;
                while (!testProxy.isLeaf() && !(children2 = testProxy.getChildren()).isEmpty() && (firstChild = children2.get(0)) != null) {
                    testProxy = firstChild;
                }
                SMTestRunnerResultsForm.this.myLastSelected = testProxy;
                if (ScrollToTestSourceAction.isScrollEnabled(SMTestRunnerResultsForm.this) && (descriptor = TestsUIUtil.getOpenFileDescriptor(selectedProxy, SMTestRunnerResultsForm.this)) != null) {
                    OpenSourceUtil.navigate((boolean)false, (Navigatable[])new Navigatable[]{descriptor});
                }
            }
        });
        return this.myTreeView;
    }

    public void addTestsTreeSelectionListener(TreeSelectionListener listener2) {
        this.myTreeView.getSelectionModel().addTreeSelectionListener(listener2);
    }

    @Override
    public void setShowStatisticForProxyHandler(PropagateSelectionHandler handler2) {
        this.myShowStatisticForProxyHandler = handler2;
    }

    @Override
    public void onTestingStarted(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        this.myAnimator.setCurrentTestCase(this.myTestsRootNode);
        this.myTreeBuilder.updateFromRoot();
        this.myStatusLine.setStatusColor(ColorProgressBar.GREEN);
        this.selectAndNotify(this.myTestsRootNode);
        this.myStartTime = System.currentTimeMillis();
        boolean printTestingStartedTime = true;
        if (this.myProperties instanceof SMTRunnerConsoleProperties) {
            printTestingStartedTime = ((SMTRunnerConsoleProperties)this.myProperties).isPrintTestingStartedTime();
        }
        if (printTestingStartedTime) {
            this.myTestsRootNode.addSystemOutput("Testing started at " + DateFormatUtil.formatTime((long)this.myStartTime) + " ...\n");
        }
        this.updateStatusLabel(false);
        this.fireOnTestingStarted();
    }

    @Override
    public void onTestingFinished(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        this.myEndTime = System.currentTimeMillis();
        if (this.myTotalTestCount == 0) {
            this.myTotalTestCount = this.myStartedTestCount;
            this.myStatusLine.setFraction(1.0);
        }
        this.updateStatusLabel(true);
        this.updateIconProgress(true);
        this.myAnimator.stopMovie();
        this.myTreeBuilder.updateFromRoot();
        LvcsHelper.addLabel(this);
        Runnable onDone = () -> {
            this.myTestsRunning = false;
            boolean sortByDuration = TestConsoleProperties.SORT_BY_DURATION.value((AbstractProperty.AbstractPropertyContainer)this.myProperties);
            if (sortByDuration) {
                this.myTreeBuilder.setTestsComparator(this.myProperties);
            }
        };
        if (this.myLastSelected == null) {
            this.selectAndNotify(this.myTestsRootNode, onDone);
        } else {
            onDone.run();
        }
        this.fireOnTestingFinished();
        if (testsRoot.wasTerminated() && this.myStatusLine.getStatusColor() == ColorProgressBar.GREEN) {
            this.myStatusLine.setStatusColor((Color)JBColor.LIGHT_GRAY);
        }
        if (testsRoot.isEmptySuite() && testsRoot.isTestsReporterAttached() && this.myProperties instanceof SMTRunnerConsoleProperties && ((SMTRunnerConsoleProperties)this.myProperties).fixEmptySuite()) {
            return;
        }
        TestsUIUtil.TestResultPresentation presentation = new TestsUIUtil.TestResultPresentation(testsRoot, this.myStartTime > 0L, null).getPresentation(this.myFailedTestCount, Math.max(0, this.myFinishedTestCount - this.myFailedTestCount - this.myIgnoredTestCount), this.myTotalTestCount - (this.myFinishedTestCount - this.myIgnoredTestCount), this.myIgnoredTestCount);
        TestsUIUtil.notifyByBalloon(this.myProperties.getProject(), testsRoot, this.myProperties, presentation);
        this.addToHistory(testsRoot, this.myProperties, this);
    }

    private void addToHistory(SMTestProxy.SMRootTestProxy root, TestConsoleProperties consoleProperties, Disposable parentDisposable) {
        RunProfile configuration = consoleProperties.getConfiguration();
        if (configuration instanceof RunConfiguration && !(consoleProperties instanceof ImportedTestConsoleProperties) && !ApplicationManager.getApplication().isUnitTestMode() && !this.myDisposed) {
            final MySaveHistoryTask backgroundable = new MySaveHistoryTask(consoleProperties, root, (RunConfiguration)configuration);
            final BackgroundableProcessIndicator processIndicator = new BackgroundableProcessIndicator(backgroundable);
            Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

                public void dispose() {
                    processIndicator.cancel();
                    backgroundable.dispose();
                }
            });
            Disposer.register((Disposable)parentDisposable, (Disposable)processIndicator);
            ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)backgroundable, (ProgressIndicator)processIndicator);
        }
    }

    @Override
    public void onTestsCountInSuite(int count) {
        this.updateCountersAndProgressOnTestCount(count, false);
    }

    @Override
    public void onTestStarted(@NotNull SMTestProxy testProxy) {
        if (!testProxy.isConfig()) {
            this.updateOnTestStarted(false);
        }
        this._addTestOrSuite(testProxy);
        this.fireOnTestNodeAdded(testProxy);
    }

    @Override
    public void onSuiteTreeNodeAdded(SMTestProxy testProxy) {
        ++this.myTotalTestCount;
    }

    @Override
    public void onSuiteTreeStarted(SMTestProxy suite) {
    }

    @Override
    public void onTestFailed(@NotNull SMTestProxy test) {
        if (Comparing.equal((Object)test, (Object)this.myLastFailed)) {
            return;
        }
        this.myLastFailed = test;
        this.updateOnTestFailed(false);
        if (test.isConfig()) {
            ++this.myStartedTestCount;
            ++this.myFinishedTestCount;
        }
        this.updateIconProgress(false);
        if (this.myLastSelected != null && TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && TestConsoleProperties.HIDE_PASSED_TESTS.value((AbstractProperty.AbstractPropertyContainer)this.myProperties)) {
            this.myTreeBuilder.expand(test, null);
        }
    }

    @Override
    public void onTestIgnored(@NotNull SMTestProxy test) {
        this.updateOnTestIgnored();
    }

    @Override
    public void onSuiteStarted(@NotNull SMTestProxy newSuite) {
        this._addTestOrSuite(newSuite);
    }

    @Override
    public void onCustomProgressTestsCategory(@Nullable String categoryName, int testCount) {
        this.myCurrentCustomProgressCategory = categoryName;
        this.updateCountersAndProgressOnTestCount(testCount, true);
    }

    @Override
    public void onCustomProgressTestStarted() {
        this.updateOnTestStarted(true);
    }

    @Override
    public void onCustomProgressTestFailed() {
        this.updateOnTestFailed(true);
    }

    @Override
    public void onCustomProgressTestFinished() {
        this.updateOnTestFinished(true);
    }

    @Override
    public void onTestFinished(@NotNull SMTestProxy test) {
        if (!test.isConfig()) {
            this.updateOnTestFinished(false);
        }
        this.updateIconProgress(false);
    }

    @Override
    public void onSuiteFinished(@NotNull SMTestProxy suite) {
    }

    @Override
    public SMTestProxy.SMRootTestProxy getTestsRootNode() {
        return this.myTestsRootNode;
    }

    @Override
    public TestConsoleProperties getProperties() {
        return this.myProperties;
    }

    @Override
    public void setFilter(Filter filter) {
        SMTRunnerTreeStructure treeStructure = this.myTreeBuilder.getSMRunnerTreeStructure();
        treeStructure.setFilter(filter);
        this.myTreeBuilder.queueUpdate();
    }

    @Override
    public boolean isRunning() {
        return this.myTestsRunning;
    }

    @Override
    public TestTreeView getTreeView() {
        return this.myTreeView;
    }

    @Override
    public SMTRunnerTreeBuilder getTreeBuilder() {
        return this.myTreeBuilder;
    }

    @Override
    public boolean hasTestSuites() {
        return this.getRoot().getChildren().size() > 0;
    }

    @Override
    @NotNull
    public AbstractTestProxy getRoot() {
        return this.myTestsRootNode;
    }

    @Override
    public void selectAndNotify(AbstractTestProxy testProxy) {
        this.selectAndNotify(testProxy, null);
    }

    private void selectAndNotify(@Nullable AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        this.selectWithoutNotify(testProxy, onDone);
    }

    @Override
    public void addEventsListener(final TestResultsViewer.EventsListener listener2) {
        this.myEventListeners.add(listener2);
        this.addTestsTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                SMTestProxy selectedProxy = (SMTestProxy)SMTestRunnerResultsForm.this.getTreeView().getSelectedTest();
                listener2.onSelected(selectedProxy, SMTestRunnerResultsForm.this, SMTestRunnerResultsForm.this);
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
        this.myShowStatisticForProxyHandler = null;
        this.myEventListeners.clear();
        this.myDisposed = true;
    }

    @Override
    public void showStatisticsForSelectedProxy() {
        TestConsoleProperties.SHOW_STATISTICS.set((AbstractProperty.AbstractPropertyContainer)this.myProperties, (Object)true);
        AbstractTestProxy selectedProxy = this.myTreeView.getSelectedTest();
        this.showStatisticsForSelectedProxy(selectedProxy, true);
    }

    private void showStatisticsForSelectedProxy(AbstractTestProxy selectedProxy, boolean requestFocus) {
        if (selectedProxy instanceof SMTestProxy && this.myShowStatisticForProxyHandler != null) {
            this.myShowStatisticForProxyHandler.handlePropagateSelectionRequest((SMTestProxy)selectedProxy, this, requestFocus);
        }
    }

    protected int getTotalTestCount() {
        return this.myTotalTestCount;
    }

    protected int getStartedTestCount() {
        return this.myStartedTestCount;
    }

    protected int getFinishedTestCount() {
        return this.myFinishedTestCount;
    }

    protected int getFailedTestCount() {
        return this.myFailedTestCount;
    }

    protected int getIgnoredTestCount() {
        return this.myIgnoredTestCount;
    }

    protected Color getTestsStatusColor() {
        return this.myStatusLine.getStatusColor();
    }

    public Set<String> getMentionedCategories() {
        return this.myMentionedCategories;
    }

    protected long getStartTime() {
        return this.myStartTime;
    }

    protected long getEndTime() {
        return this.myEndTime;
    }

    private void _addTestOrSuite(@NotNull SMTestProxy newTestOrSuite) {
        final SMTestProxy parentSuite = newTestOrSuite.getParent();
        assert (parentSuite != null);
        Update update2 = new Update(parentSuite){

            public void run() {
                SMTestRunnerResultsForm.this.myRequests.remove((Object)this);
                SMTestRunnerResultsForm.this.myTreeBuilder.updateTestsSubtree(parentSuite);
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            update2.run();
        } else if (this.myRequests.add(update2) && !this.myDisposed) {
            JobScheduler.getScheduler().schedule((Runnable)update2, 100L, TimeUnit.MILLISECONDS);
        }
        this.myTreeBuilder.repaintWithParents(newTestOrSuite);
        this.myAnimator.setCurrentTestCase(newTestOrSuite);
        if (TestConsoleProperties.TRACK_RUNNING_TEST.value((AbstractProperty.AbstractPropertyContainer)this.myProperties) && (this.myLastSelected == null || this.myLastSelected == newTestOrSuite)) {
            this.myLastSelected = null;
            this.selectAndNotify(newTestOrSuite);
        }
    }

    private void fireOnTestNodeAdded(SMTestProxy test) {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestNodeAdded(this, test);
        }
    }

    private void fireOnTestingFinished() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingFinished(this);
        }
    }

    private void fireOnTestingStarted() {
        for (TestResultsViewer.EventsListener eventListener : this.myEventListeners) {
            eventListener.onTestingStarted(this);
        }
    }

    private void selectWithoutNotify(AbstractTestProxy testProxy, @Nullable Runnable onDone) {
        if (testProxy == null) {
            return;
        }
        SMRunnerUtil.runInEventDispatchThread(() -> {
            if (this.myTreeBuilder.isDisposed()) {
                return;
            }
            this.myTreeBuilder.select(testProxy, onDone);
        }, ModalityState.NON_MODAL);
    }

    private void updateStatusLabel(boolean testingFinished) {
        boolean launchedAndFinished;
        if (this.myFailedTestCount > 0) {
            this.myStatusLine.setStatusColor(ColorProgressBar.RED);
        }
        if (testingFinished && this.myTotalTestCount == 0) {
            this.myStatusLine.setStatusColor((Color)(this.myTestsRootNode.wasLaunched() || !this.myTestsRootNode.isTestsReporterAttached() ? JBColor.LIGHT_GRAY : ColorProgressBar.RED));
        }
        boolean bl = launchedAndFinished = this.myTestsRootNode.wasLaunched() && !this.myTestsRootNode.isInProgress();
        if (!TestsPresentationUtil.hasNonDefaultCategories(this.myMentionedCategories)) {
            this.myStatusLine.formatTestMessage(this.isUndefined() ? -1 : this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myIgnoredTestCount, this.myTestsRootNode.getDuration(), this.myEndTime);
        } else {
            this.myStatusLine.setText(TestsPresentationUtil.getProgressStatus_Text(this.myStartTime, this.myEndTime, this.myTotalTestCount, this.myFinishedTestCount, this.myFailedTestCount, this.myMentionedCategories, launchedAndFinished));
        }
    }

    private boolean isUndefined() {
        return this.myProperties instanceof SMTRunnerConsoleProperties && ((SMTRunnerConsoleProperties)this.myProperties).isUndefined();
    }

    public void performUpdate() {
        this.myTreeBuilder.performUpdate();
    }

    private void updateIconProgress(boolean updateWithAttention) {
        int doneTestCount;
        int totalTestCount;
        if (this.myTotalTestCount == 0) {
            totalTestCount = 2;
            doneTestCount = 1;
        } else {
            totalTestCount = this.myTotalTestCount;
            doneTestCount = this.myFinishedTestCount;
        }
        TestsUIUtil.showIconProgress(this.myProject, doneTestCount, totalTestCount, this.myFailedTestCount, updateWithAttention);
    }

    public PropagateSelectionHandler createSelectMeListener() {
        return new PropagateSelectionHandler(){

            @Override
            public void handlePropagateSelectionRequest(@Nullable SMTestProxy selectedTestProxy, @NotNull Object sender, boolean requestFocus) {
                SMRunnerUtil.addToInvokeLater(() -> {
                    SMTestRunnerResultsForm.this.selectWithoutNotify(selectedTestProxy, null);
                    if (requestFocus) {
                        IdeFocusManager.getInstance((Project)SMTestRunnerResultsForm.this.myProject).requestFocus((Component)((Object)SMTestRunnerResultsForm.this.myTreeView), true);
                    }
                });
            }
        };
    }

    private void updateCountersAndProgressOnTestCount(int count, boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myTotalTestCount += count;
        this.updateStatusLabel(false);
    }

    private void updateOnTestStarted(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        this.myMentionedCategories.add(this.myCurrentCustomProgressCategory != null ? this.myCurrentCustomProgressCategory : "Tests");
        ++this.myStartedTestCount;
        if (this.myStartedTestCount > this.myTotalTestCount && this.myTotalTestCount != 0) {
            this.myTotalTestCount = this.myStartedTestCount;
        }
        this.updateStatusLabel(false);
    }

    private void updateProgressOnTestDone() {
        int doneTestCount = this.myFinishedTestCount;
        if (this.isUndefined()) {
            this.myStatusLine.setFraction(1.0);
        } else if (this.myTotalTestCount != 0) {
            this.myStatusLine.setFraction((double)doneTestCount / (double)this.myTotalTestCount);
        } else {
            this.myStatusLine.setFraction(doneTestCount > 0 ? 0.5 : 0.0);
        }
    }

    private void updateOnTestFailed(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFailedTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private void updateOnTestFinished(boolean isCustomMessage) {
        if (!this.isModeConsistent(isCustomMessage)) {
            return;
        }
        ++this.myFinishedTestCount;
        this.updateProgressOnTestDone();
    }

    private void updateOnTestIgnored() {
        ++this.myIgnoredTestCount;
        this.updateProgressOnTestDone();
        this.updateStatusLabel(false);
    }

    private boolean isModeConsistent(boolean isCustomMessage) {
        return isCustomMessage != (this.myCurrentCustomProgressCategory == null);
    }

    private static class MySaveHistoryTask
    extends Task.Backgroundable {
        private final TestConsoleProperties myConsoleProperties;
        private SMTestProxy.SMRootTestProxy myRoot;
        private RunConfiguration myConfiguration;
        private File myOutputFile;

        public MySaveHistoryTask(TestConsoleProperties consoleProperties, SMTestProxy.SMRootTestProxy root, RunConfiguration configuration) {
            super(consoleProperties.getProject(), "Save Test Results", true);
            this.myConsoleProperties = consoleProperties;
            this.myRoot = root;
            this.myConfiguration = configuration;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            this.writeState();
            DaemonCodeAnalyzer.getInstance((Project)this.getProject()).restart();
            try {
                SAXTransformerFactory transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
                TransformerHandler handler2 = transformerFactory.newTransformerHandler();
                handler2.getTransformer().setOutputProperty("indent", "yes");
                handler2.getTransformer().setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                String configurationNameIncludedDate = PathUtil.suggestFileName((String)this.myConfiguration.getName()) + " - " + new SimpleDateFormat(SMTestRunnerResultsForm.HISTORY_DATE_FORMAT).format(new Date());
                this.myOutputFile = new File(TestStateStorage.getTestHistoryRoot(this.myProject), configurationNameIncludedDate + ".xml");
                FileUtilRt.createParentDirs((File)this.myOutputFile);
                handler2.setResult(new StreamResult(new FileWriter(this.myOutputFile)));
                SMTestProxy.SMRootTestProxy root = this.myRoot;
                RunConfiguration configuration = this.myConfiguration;
                if (root != null && configuration != null) {
                    TestResultsXmlFormatter.execute(root, configuration, this.myConsoleProperties, handler2);
                }
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Exception e) {
                LOG.info("Export to history failed", (Throwable)e);
            }
        }

        private void writeState() {
            ApplicationManager.getApplication().runReadAction(() -> {
                Project project2 = this.getProject();
                if (project2.isDisposed()) {
                    return;
                }
                TestStateStorage storage2 = TestStateStorage.getInstance(project2);
                List<SMTestProxy> tests = this.myRoot.getAllTests();
                for (SMTestProxy proxy : tests) {
                    String url = proxy instanceof SMTestProxy.SMRootTestProxy ? ((SMTestProxy.SMRootTestProxy)proxy).getRootLocation() : proxy.getLocationUrl();
                    if (url == null) continue;
                    String configurationName = this.myConfiguration != null ? this.myConfiguration.getName() : null;
                    storage2.writeState(url, new TestStateStorage.Record(proxy.getMagnitude(), new Date(), configurationName == null ? 0L : (long)configurationName.hashCode()));
                }
            });
        }

        public void onSuccess() {
            if (this.myOutputFile != null && this.myOutputFile.exists()) {
                AbstractImportTestsAction.adjustHistory(this.myProject);
                TestHistoryConfiguration.getInstance(this.myProject).registerHistoryItem(this.myOutputFile.getName(), this.myConfiguration.getName(), this.myConfiguration.getType().getId());
            }
        }

        public void dispose() {
            this.myConfiguration = null;
            this.myRoot = null;
            this.myOutputFile = null;
        }
    }
}

