/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.ui;

import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.sm.runner.SMTRunnerNodeDescriptor;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMRootTestProxyFormatter;
import com.intellij.execution.testframework.sm.runner.ui.TestsPresentationUtil;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TestTreeRenderer
extends ColoredTreeCellRenderer {
    @NonNls
    private static final String SPACE_STRING = " ";
    private final TestConsoleProperties myConsoleProperties;
    private SMRootTestProxyFormatter myAdditionalRootFormatter;
    private int myDurationWidth = -1;
    private int myRow;

    public TestTreeRenderer(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void customizeCellRenderer(JTree tree, Object value2, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this.myRow = row;
        this.myDurationWidth = -1;
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value2;
        Object userObj = node.getUserObject();
        if (userObj instanceof SMTRunnerNodeDescriptor) {
            String durationString;
            SMTRunnerNodeDescriptor desc = (SMTRunnerNodeDescriptor)((Object)userObj);
            SMTestProxy testProxy = (SMTestProxy)desc.getElement();
            if (testProxy instanceof SMTestProxy.SMRootTestProxy) {
                SMTestProxy.SMRootTestProxy rootTestProxy = (SMTestProxy.SMRootTestProxy)testProxy;
                if (node.isLeaf()) {
                    TestsPresentationUtil.formatRootNodeWithoutChildren(rootTestProxy, this);
                } else {
                    TestsPresentationUtil.formatRootNodeWithChildren(rootTestProxy, this);
                }
                if (this.myAdditionalRootFormatter != null) {
                    this.myAdditionalRootFormatter.format(rootTestProxy, this);
                }
            } else {
                TestsPresentationUtil.formatTestProxy(testProxy, this);
            }
            if (TestConsoleProperties.SHOW_INLINE_STATISTICS.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties) && (durationString = testProxy.getDurationString(this.myConsoleProperties)) != null) {
                durationString = "  " + durationString;
                this.myDurationWidth = this.getFontMetrics(this.getFont()).stringWidth(durationString);
                if (((TestTreeView)((Object)this.myTree)).isExpandableHandlerVisibleForCurrentRow(this.myRow)) {
                    this.append(durationString);
                }
            }
            return;
        }
        String text = node.toString();
        this.append(text != null ? text : SPACE_STRING, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        return this.myDurationWidth < 0 || ((TestTreeView)((Object)this.myTree)).isExpandableHandlerVisibleForCurrentRow(this.myRow) ? preferredSize : JBUI.size((int)(preferredSize.width + this.myDurationWidth), (int)preferredSize.height);
    }

    public TestConsoleProperties getConsoleProperties() {
        return this.myConsoleProperties;
    }

    public void setAdditionalRootFormatter(@NotNull SMRootTestProxyFormatter formatter) {
        this.myAdditionalRootFormatter = formatter;
    }

    public void removeAdditionalRootFormatter() {
        this.myAdditionalRootFormatter = null;
    }
}

