/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.ui;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.KillableProcess;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.dashboard.RunDashboardContributor;
import com.intellij.execution.dashboard.RunDashboardManager;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.RunContentWithExecutorListener;
import com.intellij.execution.ui.layout.impl.DockableGridContainerFactory;
import com.intellij.ide.DataManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerAdapter;
import com.intellij.openapi.wm.ex.ToolWindowManagerEx;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.docking.DockContainerFactory;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunContentManagerImpl
implements RunContentManager,
Disposable {
    public static final Key<Boolean> ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY = Key.create((String)"ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY");
    private static final Logger LOG = Logger.getInstance(RunContentManagerImpl.class);
    private static final Key<Executor> EXECUTOR_KEY = Key.create((String)"Executor");
    private final Project myProject;
    private final Map<String, ContentManager> myToolwindowIdToContentManagerMap = new THashMap();
    private final Map<String, Icon> myToolwindowIdToBaseIconMap = new THashMap();
    private final LinkedList<String> myToolwindowIdZBuffer = new LinkedList();

    public RunContentManagerImpl(@NotNull Project project2, @NotNull DockManager dockManager) {
        this.myProject = project2;
        DockableGridContainerFactory containerFactory = new DockableGridContainerFactory();
        dockManager.register("runner-grid", (DockContainerFactory)containerFactory);
        Disposer.register((Disposable)this.myProject, (Disposable)containerFactory);
        AppUIUtil.invokeOnEdt(() -> this.init(), this.myProject.getDisposed());
    }

    private void init() {
        ToolWindowManagerEx toolWindowManager = ToolWindowManagerEx.getInstanceEx(this.myProject);
        if (toolWindowManager == null) {
            return;
        }
        for (Executor executor : ExecutorRegistry.getInstance().getRegisteredExecutors()) {
            this.registerToolWindow(executor, toolWindowManager);
        }
        RunDashboardManager dashboardManager = RunDashboardManager.getInstance((Project)this.myProject);
        this.initToolWindow(null, dashboardManager.getToolWindowId(), dashboardManager.getToolWindowIcon(), dashboardManager.getDashboardContentManager());
        toolWindowManager.addToolWindowManagerListener(new ToolWindowManagerAdapter(){

            @Override
            public void stateChanged() {
                if (RunContentManagerImpl.this.myProject.isDisposed()) {
                    return;
                }
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)RunContentManagerImpl.this.myProject);
                THashSet currentWindows = new THashSet();
                ContainerUtil.addAll((Collection)currentWindows, (Object[])toolWindowManager.getToolWindowIds());
                RunContentManagerImpl.this.myToolwindowIdZBuffer.retainAll((Collection<?>)currentWindows);
                String activeToolWindowId = toolWindowManager.getActiveToolWindowId();
                if (activeToolWindowId != null && RunContentManagerImpl.this.myToolwindowIdZBuffer.remove(activeToolWindowId)) {
                    RunContentManagerImpl.this.myToolwindowIdZBuffer.addFirst(activeToolWindowId);
                }
            }
        });
    }

    public void dispose() {
    }

    private void registerToolWindow(final @NotNull Executor executor, @NotNull ToolWindowManagerEx toolWindowManager) {
        String toolWindowId = executor.getToolWindowId();
        if (toolWindowManager.getToolWindow(toolWindowId) != null) {
            return;
        }
        ToolWindow toolWindow = toolWindowManager.registerToolWindow(toolWindowId, true, ToolWindowAnchor.BOTTOM, this, true);
        final ContentManager contentManager = toolWindow.getContentManager();
        contentManager.addDataProvider(new DataProvider(){
            private int myInsideGetData = 0;

            public Object getData(String dataId) {
                ++this.myInsideGetData;
                try {
                    if (PlatformDataKeys.HELP_ID.is(dataId)) {
                        String string = executor.getHelpId();
                        return string;
                    }
                    Object object = this.myInsideGetData == 1 ? DataManager.getInstance().getDataContext((Component)contentManager.getComponent()).getData(dataId) : null;
                    return object;
                }
                finally {
                    --this.myInsideGetData;
                }
            }
        });
        toolWindow.setIcon(executor.getToolWindowIcon());
        new ContentManagerWatcher(toolWindow, contentManager);
        this.initToolWindow(executor, toolWindowId, executor.getToolWindowIcon(), contentManager);
    }

    private void initToolWindow(final @Nullable Executor executor, final String toolWindowId, Icon toolWindowIcon, ContentManager contentManager) {
        this.myToolwindowIdToBaseIconMap.put(toolWindowId, toolWindowIcon);
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void selectionChanged(ContentManagerEvent event) {
                if (event.getOperation() == ContentManagerEvent.ContentOperation.add) {
                    Content content = event.getContent();
                    Executor contentExecutor = executor;
                    if (contentExecutor == null) {
                        contentExecutor = RunContentManagerImpl.getExecutorByContent(content);
                        LOG.assertTrue(contentExecutor != null);
                    }
                    RunContentManagerImpl.this.getSyncPublisher().contentSelected(RunContentManagerImpl.getRunContentDescriptorByContent(content), contentExecutor);
                }
            }
        });
        this.myToolwindowIdToContentManagerMap.put(toolWindowId, contentManager);
        Disposer.register((Disposable)contentManager, (Disposable)new Disposable(){

            public void dispose() {
                ((ContentManager)RunContentManagerImpl.this.myToolwindowIdToContentManagerMap.remove(toolWindowId)).removeAllContents(true);
                RunContentManagerImpl.this.myToolwindowIdZBuffer.remove(toolWindowId);
                RunContentManagerImpl.this.myToolwindowIdToBaseIconMap.remove(toolWindowId);
            }
        });
        this.myToolwindowIdZBuffer.addLast(toolWindowId);
    }

    private RunContentWithExecutorListener getSyncPublisher() {
        return (RunContentWithExecutorListener)this.myProject.getMessageBus().syncPublisher(TOPIC);
    }

    public void toFrontRunContent(Executor requestor, ProcessHandler handler2) {
        RunContentDescriptor descriptor = this.getDescriptorBy(handler2, requestor);
        if (descriptor == null) {
            return;
        }
        this.toFrontRunContent(requestor, descriptor);
    }

    public void toFrontRunContent(Executor requestor, RunContentDescriptor descriptor) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ContentManager contentManager = this.getContentManagerForRunner(requestor, descriptor);
            Content content = RunContentManagerImpl.getRunContentByDescriptor(contentManager, descriptor);
            if (content != null) {
                contentManager.setSelectedContent(content);
                ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(RunContentManagerImpl.getToolWindowIdForRunner(requestor, descriptor)).show(null);
            }
        }, this.myProject.getDisposed());
    }

    public void hideRunContent(@NotNull Executor executor, RunContentDescriptor descriptor) {
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(RunContentManagerImpl.getToolWindowIdForRunner(executor, descriptor));
            if (toolWindow != null) {
                toolWindow.hide(null);
            }
        }, this.myProject.getDisposed());
    }

    @Nullable
    public RunContentDescriptor getSelectedContent(Executor executor) {
        Content selectedContent = this.getContentManagerForRunner(executor, null).getSelectedContent();
        return selectedContent != null ? RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent) : null;
    }

    @Nullable
    public RunContentDescriptor getSelectedContent() {
        for (String activeWindow : this.myToolwindowIdZBuffer) {
            ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(activeWindow);
            if (contentManager == null) continue;
            Content selectedContent = contentManager.getSelectedContent();
            if (selectedContent == null) {
                if (contentManager.getContentCount() != 0) break;
                continue;
            }
            return RunContentManagerImpl.getRunContentDescriptorByContent(selectedContent);
        }
        return null;
    }

    public boolean removeRunContent(@NotNull Executor executor, RunContentDescriptor descriptor) {
        ContentManager contentManager = this.getContentManagerForRunner(executor, descriptor);
        Content content = RunContentManagerImpl.getRunContentByDescriptor(contentManager, descriptor);
        return content != null && contentManager.removeContent(content, true);
    }

    public void showRunContent(@NotNull Executor executor, @NotNull RunContentDescriptor descriptor) {
        this.showRunContent(executor, descriptor, descriptor.getExecutionId());
    }

    private void showRunContent(final @NotNull Executor executor, final @NotNull RunContentDescriptor descriptor, long executionId) {
        Content content;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        ContentManager contentManager = this.getContentManagerForRunner(executor, descriptor);
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, descriptor, executionId, descriptor.getDisplayName());
        if (oldDescriptor == null) {
            content = RunContentManagerImpl.createNewContent(descriptor, executor);
        } else {
            content = oldDescriptor.getAttachedContent();
            LOG.assertTrue(content != null);
            this.getSyncPublisher().contentRemoved(oldDescriptor, executor);
            Disposer.dispose((Disposable)oldDescriptor);
        }
        content.setExecutionId(executionId);
        content.setComponent(descriptor.getComponent());
        content.setPreferredFocusedComponent(descriptor.getPreferredFocusComputable());
        content.putUserData(RunContentDescriptor.DESCRIPTOR_KEY, (Object)descriptor);
        content.putUserData(EXECUTOR_KEY, (Object)executor);
        content.setDisplayName(descriptor.getDisplayName());
        descriptor.setAttachedContent(content);
        final String toolWindowId = RunContentManagerImpl.getToolWindowIdForRunner(executor, descriptor);
        final ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId);
        final ProcessHandler processHandler2 = descriptor.getProcessHandler();
        if (processHandler2 != null) {
            final ProcessAdapter processAdapter = new ProcessAdapter(){

                public void startNotified(ProcessEvent event) {
                    UIUtil.invokeLaterIfNeeded(() -> {
                        content.setIcon(ExecutionUtil.getLiveIndicator((Icon)descriptor.getIcon()));
                        toolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)((Icon)RunContentManagerImpl.this.myToolwindowIdToBaseIconMap.get(toolWindowId))));
                    });
                }

                public void processTerminated(ProcessEvent event) {
                    ApplicationManager.getApplication().invokeLater(() -> {
                        boolean alive = false;
                        ContentManager manager = (ContentManager)RunContentManagerImpl.this.myToolwindowIdToContentManagerMap.get(toolWindowId);
                        if (manager == null) {
                            return;
                        }
                        for (Content content1 : manager.getContents()) {
                            ProcessHandler handler2;
                            RunContentDescriptor descriptor1 = RunContentManagerImpl.getRunContentDescriptorByContent(content1);
                            if (descriptor1 == null || (handler2 = descriptor1.getProcessHandler()) == null || handler2.isProcessTerminated()) continue;
                            alive = true;
                            break;
                        }
                        Icon base = (Icon)RunContentManagerImpl.this.myToolwindowIdToBaseIconMap.get(toolWindowId);
                        toolWindow.setIcon(alive ? ExecutionUtil.getLiveIndicator((Icon)base) : base);
                        Icon icon = descriptor.getIcon();
                        content.setIcon(icon == null ? executor.getDisabledIcon() : IconLoader.getTransparentIcon((Icon)icon));
                    });
                }
            };
            processHandler2.addProcessListener((ProcessListener)processAdapter);
            Disposable disposer = content.getDisposer();
            if (disposer != null) {
                Disposer.register((Disposable)disposer, (Disposable)new Disposable(){

                    public void dispose() {
                        processHandler2.removeProcessListener((ProcessListener)processAdapter);
                    }
                });
            }
        }
        if (oldDescriptor == null) {
            contentManager.addContent(content);
            new CloseListener(content, executor);
        }
        content.getManager().setSelectedContent(content);
        if (!descriptor.isActivateToolWindowWhenAdded()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            ToolWindow window = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(toolWindowId);
            descriptor.getPreferredFocusComputable();
            window.activate(descriptor.getActivationCallback(), descriptor.isAutoFocusContent(), descriptor.isAutoFocusContent());
        }, this.myProject.getDisposed());
    }

    @Nullable
    public RunContentDescriptor getReuseContent(@NotNull ExecutionEnvironment executionEnvironment) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        RunContentDescriptor contentToReuse = executionEnvironment.getContentToReuse();
        if (contentToReuse != null) {
            return contentToReuse;
        }
        String toolWindowId = this.getContentDescriptorToolWindowId(executionEnvironment.getRunnerAndConfigurationSettings());
        ContentManager contentManager = toolWindowId == null ? this.getContentManagerForRunner(executionEnvironment.getExecutor(), null) : this.myToolwindowIdToContentManagerMap.get(toolWindowId);
        return RunContentManagerImpl.chooseReuseContentForDescriptor(contentManager, null, executionEnvironment.getExecutionId(), executionEnvironment.toString());
    }

    public RunContentDescriptor findContentDescriptor(Executor requestor, ProcessHandler handler2) {
        return this.getDescriptorBy(handler2, requestor);
    }

    public void showRunContent(@NotNull Executor info, @NotNull RunContentDescriptor descriptor, @Nullable RunContentDescriptor contentToReuse) {
        RunContentManagerImpl.copyContentAndBehavior(descriptor, contentToReuse);
        this.showRunContent(info, descriptor, descriptor.getExecutionId());
    }

    public static void copyContentAndBehavior(@NotNull RunContentDescriptor descriptor, @Nullable RunContentDescriptor contentToReuse) {
        if (contentToReuse != null) {
            Content attachedContent = contentToReuse.getAttachedContent();
            if (attachedContent != null && attachedContent.isValid()) {
                descriptor.setAttachedContent(attachedContent);
            }
            if (contentToReuse.isReuseToolWindowActivation()) {
                descriptor.setActivateToolWindowWhenAdded(contentToReuse.isActivateToolWindowWhenAdded());
            }
            descriptor.setContentToolWindowId(contentToReuse.getContentToolWindowId());
        }
    }

    @Nullable
    private static RunContentDescriptor chooseReuseContentForDescriptor(@NotNull ContentManager contentManager, @Nullable RunContentDescriptor descriptor, long executionId, @Nullable String preferredName) {
        Content content = null;
        if (descriptor != null) {
            if (descriptor.isContentReuseProhibited()) {
                return null;
            }
            Content attachedContent = descriptor.getAttachedContent();
            if (attachedContent != null && attachedContent.isValid() && contentManager.getIndexOfContent(attachedContent) != -1 && (Comparing.equal((String)descriptor.getDisplayName(), (String)attachedContent.getDisplayName()) || !attachedContent.isPinned())) {
                content = attachedContent;
            }
        }
        if (content == null) {
            content = RunContentManagerImpl.getContentFromManager(contentManager, preferredName, executionId);
        }
        if (content == null || !RunContentManagerImpl.isTerminated(content) || content.getExecutionId() == executionId && executionId != 0L) {
            return null;
        }
        RunContentDescriptor oldDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        if (oldDescriptor != null && !oldDescriptor.isContentReuseProhibited()) {
            return oldDescriptor;
        }
        return null;
    }

    @Nullable
    private static Content getContentFromManager(ContentManager contentManager, @Nullable String preferredName, long executionId) {
        ArrayList<Content> contents = new ArrayList<Content>(Arrays.asList(contentManager.getContents()));
        Content first = contentManager.getSelectedContent();
        if (first != null && contents.remove(first)) {
            contents.add(0, first);
        }
        if (preferredName != null) {
            for (Content c : contents) {
                if (!RunContentManagerImpl.canReuseContent(c, executionId) || !preferredName.equals(c.getDisplayName())) continue;
                return c;
            }
        }
        for (Content c : contents) {
            if (!RunContentManagerImpl.canReuseContent(c, executionId)) continue;
            return c;
        }
        return null;
    }

    private static boolean canReuseContent(Content c, long executionId) {
        return c != null && !c.isPinned() && RunContentManagerImpl.isTerminated(c) && (c.getExecutionId() != executionId || executionId == 0L);
    }

    @NotNull
    private ContentManager getContentManagerForRunner(Executor executor, RunContentDescriptor descriptor) {
        ContentManager contentManager = this.myToolwindowIdToContentManagerMap.get(RunContentManagerImpl.getToolWindowIdForRunner(executor, descriptor));
        if (contentManager == null) {
            LOG.error("Runner " + executor.getId() + " is not registered");
        }
        return contentManager;
    }

    private static String getToolWindowIdForRunner(Executor executor, RunContentDescriptor descriptor) {
        if (descriptor != null && descriptor.getContentToolWindowId() != null) {
            return descriptor.getContentToolWindowId();
        }
        return executor.getToolWindowId();
    }

    private static Content createNewContent(RunContentDescriptor descriptor, Executor executor) {
        String processDisplayName = descriptor.getDisplayName();
        Content content = ContentFactory.SERVICE.getInstance().createContent(descriptor.getComponent(), processDisplayName, true);
        content.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
        Icon icon = descriptor.getIcon();
        content.setIcon(icon == null ? executor.getToolWindowIcon() : icon);
        return content;
    }

    public static boolean isTerminated(@NotNull Content content) {
        RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
        ProcessHandler processHandler2 = descriptor == null ? null : descriptor.getProcessHandler();
        return processHandler2 == null || processHandler2.isProcessTerminated();
    }

    @Nullable
    public static RunContentDescriptor getRunContentDescriptorByContent(@NotNull Content content) {
        return (RunContentDescriptor)content.getUserData(RunContentDescriptor.DESCRIPTOR_KEY);
    }

    @Nullable
    public static Executor getExecutorByContent(@NotNull Content content) {
        return (Executor)content.getUserData(EXECUTOR_KEY);
    }

    @Nullable
    public ToolWindow getToolWindowByDescriptor(@NotNull RunContentDescriptor descriptor) {
        for (Map.Entry<String, ContentManager> entry : this.myToolwindowIdToContentManagerMap.entrySet()) {
            if (RunContentManagerImpl.getRunContentByDescriptor(entry.getValue(), descriptor) == null) continue;
            return ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(entry.getKey());
        }
        return null;
    }

    @Nullable
    private static Content getRunContentByDescriptor(@NotNull ContentManager contentManager, @NotNull RunContentDescriptor descriptor) {
        for (Content content : contentManager.getContents()) {
            if (!descriptor.equals(RunContentManagerImpl.getRunContentDescriptorByContent(content))) continue;
            return content;
        }
        return null;
    }

    @NotNull
    public List<RunContentDescriptor> getAllDescriptors() {
        if (this.myToolwindowIdToContentManagerMap.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList descriptors = new SmartList();
        for (String id : this.myToolwindowIdToContentManagerMap.keySet()) {
            for (Content content : this.myToolwindowIdToContentManagerMap.get(id).getContents()) {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                if (descriptor == null) continue;
                descriptors.add(descriptor);
            }
        }
        return descriptors;
    }

    public void selectRunContent(@NotNull RunContentDescriptor descriptor) {
        for (Map.Entry<String, ContentManager> entry : this.myToolwindowIdToContentManagerMap.entrySet()) {
            Content content = RunContentManagerImpl.getRunContentByDescriptor(entry.getValue(), descriptor);
            if (content == null) continue;
            entry.getValue().setSelectedContent(content);
        }
    }

    @Nullable
    public String getContentDescriptorToolWindowId(@Nullable RunnerAndConfigurationSettings settings) {
        ConfigurationType type2;
        if (settings != null && RunDashboardContributor.isShowInDashboard((ConfigurationType)(type2 = settings.getType()))) {
            return RunDashboardManager.getInstance((Project)this.myProject).getToolWindowId();
        }
        return null;
    }

    @NotNull
    public String getToolWindowIdByEnvironment(@NotNull ExecutionEnvironment executionEnvironment) {
        String toolWindowId = this.getContentDescriptorToolWindowId(executionEnvironment.getRunnerAndConfigurationSettings());
        return toolWindowId != null ? toolWindowId : executionEnvironment.getExecutor().getToolWindowId();
    }

    @Nullable
    private RunContentDescriptor getDescriptorBy(ProcessHandler handler2, Executor runnerInfo) {
        ArrayList contents = new ArrayList();
        ContainerUtil.addAll(contents, (Object[])this.getContentManagerForRunner(runnerInfo, null).getContents());
        ContainerUtil.addAll(contents, (Object[])this.myToolwindowIdToContentManagerMap.get(RunDashboardManager.getInstance((Project)this.myProject).getToolWindowId()).getContents());
        for (Content content : contents) {
            RunContentDescriptor runContentDescriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
            assert (runContentDescriptor != null);
            if (runContentDescriptor.getProcessHandler() != handler2) continue;
            return runContentDescriptor;
        }
        return null;
    }

    private void waitForProcess(final RunContentDescriptor descriptor, final boolean modal) {
        final ProcessHandler processHandler2 = descriptor.getProcessHandler();
        final boolean killable = !modal && processHandler2 instanceof KillableProcess && ((KillableProcess)processHandler2).canKillProcess();
        String title = ExecutionBundle.message((String)"terminating.process.progress.title", (Object[])new Object[]{descriptor.getDisplayName()});
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, true){
            {
                super(arg0, arg1, arg2);
                if (killable) {
                    String cancelText = ExecutionBundle.message((String)"terminating.process.progress.kill", (Object[])new Object[0]);
                    this.setCancelText(cancelText);
                    this.setCancelTooltipText(cancelText);
                }
            }

            public boolean isConditionalModal() {
                return modal;
            }

            public boolean shouldStartInBackground() {
                return !modal;
            }

            public void run(final @NotNull ProgressIndicator progressIndicator) {
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    ProcessHandler processHandler1 = descriptor.getProcessHandler();
                    try {
                        if (processHandler1 != null) {
                            processHandler1.waitFor();
                        }
                    }
                    finally {
                        semaphore.up();
                    }
                });
                progressIndicator.setText(ExecutionBundle.message((String)"waiting.for.vm.detach.progress.text", (Object[])new Object[0]));
                ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        while (true) {
                            if (progressIndicator.isCanceled() || !progressIndicator.isRunning()) break;
                            try {
                                1 var1_1 = this;
                                synchronized (var1_1) {
                                    this.wait(2000L);
                                    continue;
                                }
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                        semaphore.up();
                    }
                });
                semaphore.waitFor();
            }

            public void onCancel() {
                if (killable && !processHandler2.isProcessTerminated()) {
                    ((KillableProcess)processHandler2).killProcess();
                }
            }
        });
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private Content myContent;
        private final Executor myExecutor;

        private CloseListener(@NotNull Content content, Executor executor) {
            this.myContent = content;
            content.getManager().addContentManagerListener((ContentManagerListener)this);
            ProjectManager.getInstance().addProjectManagerListener((ProjectManagerListener)this);
            this.myExecutor = executor;
        }

        public void contentRemoved(ContentManagerEvent event) {
            Content content = event.getContent();
            if (content == this.myContent) {
                this.dispose();
            }
        }

        private void dispose() {
            if (this.myContent == null) {
                return;
            }
            Content content = this.myContent;
            try {
                RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(content);
                RunContentManagerImpl.this.getSyncPublisher().contentRemoved(descriptor, this.myExecutor);
                if (descriptor != null) {
                    Disposer.dispose((Disposable)descriptor);
                }
            }
            finally {
                content.getManager().removeContentManagerListener((ContentManagerListener)this);
                ProjectManager.getInstance().removeProjectManagerListener((ProjectManagerListener)this);
                content.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            boolean canClose;
            if (event.getContent() == this.myContent && !(canClose = this.closeQuery(false))) {
                event.consume();
            }
        }

        public void projectClosed(Project project2) {
            if (this.myContent != null && project2 == RunContentManagerImpl.this.myProject) {
                this.myContent.getManager().removeContent(this.myContent, true);
                this.dispose();
            }
        }

        public boolean canCloseProject(Project project2) {
            if (project2 != RunContentManagerImpl.this.myProject) {
                return true;
            }
            if (this.myContent == null) {
                return true;
            }
            boolean canClose = this.closeQuery(true);
            if (canClose) {
                this.myContent.getManager().removeContent(this.myContent, true);
                this.myContent = null;
            }
            return canClose;
        }

        private boolean closeQuery(boolean modal) {
            boolean destroyProcess;
            RunContentDescriptor descriptor = RunContentManagerImpl.getRunContentDescriptorByContent(this.myContent);
            if (descriptor == null) {
                return true;
            }
            ProcessHandler processHandler2 = descriptor.getProcessHandler();
            if (processHandler2 == null || processHandler2.isProcessTerminated() || processHandler2.isProcessTerminating()) {
                return true;
            }
            GeneralSettings.ProcessCloseConfirmation rc = TerminateRemoteProcessDialog.show(RunContentManagerImpl.this.myProject, descriptor.getDisplayName(), processHandler2);
            if (rc == null) {
                return false;
            }
            boolean bl = destroyProcess = rc == GeneralSettings.ProcessCloseConfirmation.TERMINATE;
            if (destroyProcess) {
                processHandler2.destroyProcess();
            } else {
                processHandler2.detachProcess();
            }
            RunContentManagerImpl.this.waitForProcess(descriptor, modal);
            return true;
        }
    }
}

