/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.config.Storage;
import com.intellij.util.containers.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class StoringPropertyContainer
extends AbstractProperty.AbstractPropertyContainer<AbstractProperty<Boolean>> {
    private final Map<AbstractProperty<Boolean>, Boolean> myValues = new HashMap();
    private final Storage myStorage;

    public StoringPropertyContainer(String groupName, PropertiesComponent propertiesComponent) {
        this((Storage)new Storage.PropertiesComponentStorage(groupName, propertiesComponent));
    }

    public StoringPropertyContainer(@NotNull Storage storage2) {
        this.myStorage = storage2;
    }

    public void setIfUndefined(@NotNull AbstractProperty<Boolean> property, boolean value2) {
        if (this.myStorage.get(property.getName()) == null) {
            this.setValueOf(property, value2);
        }
    }

    protected void setValueOf(@NotNull AbstractProperty<Boolean> property, Object value2) {
        this.myValues.put(property, (Boolean)value2);
        this.onPropertyChanged(property, (Boolean)value2);
        this.myStorage.put(property.getName(), value2.toString());
    }

    public boolean hasProperty(@NotNull AbstractProperty property) {
        return this.myValues.containsKey(property);
    }

    protected Object getValueOf(@NotNull AbstractProperty<Boolean> property) {
        Object value2 = this.myValues.get(property);
        if (value2 == null) {
            String stringValue = this.myStorage.get(property.getName());
            value2 = stringValue != null ? Boolean.valueOf(stringValue) : property.getDefault((AbstractProperty.AbstractPropertyContainer)this);
            this.myValues.put(property, (Boolean)value2);
        }
        return value2;
    }

    protected <T> void onPropertyChanged(@NotNull AbstractProperty<T> property, T value2) {
    }
}

