/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl;

import com.intellij.ProjectTopics;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.ProjectWideFacetListener;
import com.intellij.facet.ProjectWideFacetListenersRegistry;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ProjectWideFacetListenersRegistryImpl
extends ProjectWideFacetListenersRegistry {
    private final Map<FacetTypeId, EventDispatcher<ProjectWideFacetListener>> myDispatchers = new HashMap<FacetTypeId, EventDispatcher<ProjectWideFacetListener>>();
    private final Map<FacetTypeId, WeakHashMap<Facet, Boolean>> myFacetsByType = new HashMap<FacetTypeId, WeakHashMap<Facet, Boolean>>();
    private final Map<Module, MessageBusConnection> myModule2Connection = new HashMap<Module, MessageBusConnection>();
    private final FacetManagerAdapter myFacetListener;
    private final EventDispatcher<ProjectWideFacetListener> myAllFacetsListener = EventDispatcher.create(ProjectWideFacetListener.class);

    public ProjectWideFacetListenersRegistryImpl(MessageBus messageBus) {
        this.myFacetListener = new MyFacetManagerAdapter();
        messageBus.connect().subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                ProjectWideFacetListenersRegistryImpl.this.onModuleAdded(module2);
            }

            public void beforeModuleRemoved(@NotNull Project project2, @NotNull Module module2) {
                Facet[] allFacets;
                for (Facet facet : allFacets = FacetManager.getInstance((Module)module2).getAllFacets()) {
                    ProjectWideFacetListenersRegistryImpl.this.onFacetRemoved(facet, true);
                }
            }

            public void moduleRemoved(@NotNull Project project2, @NotNull Module module2) {
                ProjectWideFacetListenersRegistryImpl.this.onModuleRemoved(module2);
            }
        });
    }

    private void onModuleRemoved(Module module2) {
        Facet[] facets;
        MessageBusConnection connection = this.myModule2Connection.remove(module2);
        if (connection != null) {
            connection.disconnect();
        }
        FacetManager facetManager = FacetManager.getInstance((Module)module2);
        for (Facet facet : facets = facetManager.getAllFacets()) {
            this.onFacetRemoved(facet, false);
        }
    }

    private void onModuleAdded(Module module2) {
        Facet[] facets;
        FacetManager facetManager = FacetManager.getInstance((Module)module2);
        for (Facet facet : facets = facetManager.getAllFacets()) {
            this.onFacetAdded(facet);
        }
        MessageBusConnection connection = module2.getMessageBus().connect();
        this.myModule2Connection.put(module2, connection);
        connection.subscribe(FacetManager.FACETS_TOPIC, (Object)this.myFacetListener);
    }

    private void onFacetRemoved(Facet facet, boolean before) {
        EventDispatcher<ProjectWideFacetListener> dispatcher;
        boolean lastFacet;
        FacetTypeId typeId = facet.getTypeId();
        WeakHashMap<Facet, Boolean> facets = this.myFacetsByType.get(typeId);
        if (facets != null) {
            facets.remove((Object)facet);
            lastFacet = facets.isEmpty();
            if (lastFacet) {
                this.myFacetsByType.remove(typeId);
            }
        } else {
            lastFacet = true;
        }
        if ((dispatcher = this.myDispatchers.get(typeId)) != null) {
            if (before) {
                ((ProjectWideFacetListener)dispatcher.getMulticaster()).beforeFacetRemoved(facet);
            } else {
                ((ProjectWideFacetListener)dispatcher.getMulticaster()).facetRemoved(facet);
                if (lastFacet) {
                    ((ProjectWideFacetListener)dispatcher.getMulticaster()).allFacetsRemoved();
                }
            }
        }
        if (before) {
            this.getAllFacetsMulticaster().beforeFacetRemoved(facet);
        } else {
            this.getAllFacetsMulticaster().facetRemoved(facet);
            if (this.myFacetsByType.isEmpty()) {
                this.getAllFacetsMulticaster().allFacetsRemoved();
            }
        }
    }

    private ProjectWideFacetListener<Facet> getAllFacetsMulticaster() {
        return (ProjectWideFacetListener)this.myAllFacetsListener.getMulticaster();
    }

    private void onFacetAdded(Facet facet) {
        boolean firstFacet = this.myFacetsByType.isEmpty();
        FacetTypeId typeId = facet.getTypeId();
        WeakHashMap facets = this.myFacetsByType.get(typeId);
        if (facets == null) {
            facets = new WeakHashMap();
            this.myFacetsByType.put(typeId, (WeakHashMap<Facet, Boolean>)facets);
        }
        boolean firstFacetOfType = facets.isEmpty();
        facets.put((Object)facet, (Object)true);
        if (firstFacet) {
            this.getAllFacetsMulticaster().firstFacetAdded();
        }
        this.getAllFacetsMulticaster().facetAdded(facet);
        EventDispatcher<ProjectWideFacetListener> dispatcher = this.myDispatchers.get(typeId);
        if (dispatcher != null) {
            if (firstFacetOfType) {
                ((ProjectWideFacetListener)dispatcher.getMulticaster()).firstFacetAdded();
            }
            ((ProjectWideFacetListener)dispatcher.getMulticaster()).facetAdded(facet);
        }
    }

    private void onFacetChanged(Facet facet) {
        EventDispatcher<ProjectWideFacetListener> dispatcher = this.myDispatchers.get(facet.getTypeId());
        if (dispatcher != null) {
            ((ProjectWideFacetListener)dispatcher.getMulticaster()).facetConfigurationChanged(facet);
        }
        this.getAllFacetsMulticaster().facetConfigurationChanged(facet);
    }

    public <F extends Facet> void registerListener(@NotNull FacetTypeId<F> typeId, @NotNull ProjectWideFacetListener<? extends F> listener2) {
        EventDispatcher dispatcher = this.myDispatchers.get(typeId);
        if (dispatcher == null) {
            dispatcher = EventDispatcher.create(ProjectWideFacetListener.class);
            this.myDispatchers.put(typeId, (EventDispatcher<ProjectWideFacetListener>)dispatcher);
        }
        dispatcher.addListener(listener2);
    }

    public <F extends Facet> void unregisterListener(@NotNull FacetTypeId<F> typeId, @NotNull ProjectWideFacetListener<? extends F> listener2) {
        EventDispatcher<ProjectWideFacetListener> dispatcher = this.myDispatchers.get(typeId);
        if (dispatcher != null) {
            dispatcher.removeListener(listener2);
        }
    }

    public <F extends Facet> void registerListener(final @NotNull FacetTypeId<F> typeId, final @NotNull ProjectWideFacetListener<? extends F> listener2, @NotNull Disposable parentDisposable) {
        this.registerListener(typeId, listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                ProjectWideFacetListenersRegistryImpl.this.unregisterListener(typeId, listener2);
            }
        });
    }

    public void registerListener(@NotNull ProjectWideFacetListener<Facet> listener2) {
        this.myAllFacetsListener.addListener(listener2);
    }

    public void unregisterListener(@NotNull ProjectWideFacetListener<Facet> listener2) {
        this.myAllFacetsListener.removeListener(listener2);
    }

    public void registerListener(@NotNull ProjectWideFacetListener<Facet> listener2, @NotNull Disposable parentDisposable) {
        this.myAllFacetsListener.addListener(listener2, parentDisposable);
    }

    private class MyFacetManagerAdapter
    extends FacetManagerAdapter {
        private MyFacetManagerAdapter() {
        }

        public void facetAdded(@NotNull Facet facet) {
            ProjectWideFacetListenersRegistryImpl.this.onFacetAdded(facet);
        }

        public void beforeFacetRemoved(@NotNull Facet facet) {
            ProjectWideFacetListenersRegistryImpl.this.onFacetRemoved(facet, true);
        }

        public void facetRemoved(@NotNull Facet facet) {
            ProjectWideFacetListenersRegistryImpl.this.onFacetRemoved(facet, false);
        }

        public void facetConfigurationChanged(@NotNull Facet facet) {
            ProjectWideFacetListenersRegistryImpl.this.onFacetChanged(facet);
        }
    }
}

