/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.facet.impl.ui.actions;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetInfo;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeId;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.ui.FacetEditorFacade;
import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.impl.AddFrameworkSupportInProjectStructureAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import java.util.Collection;
import java.util.TreeMap;

public class AddFacetToModuleAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.facet.impl.ui.actions.AddFacetToModuleAction");
    private final FacetEditorFacade myEditor;
    private final Project myProject;
    private final FacetType myType;

    private AddFacetToModuleAction(FacetEditorFacade editor, Project project2, FacetType type2) {
        super(type2.getPresentableName(), null, type2.getIcon());
        this.myEditor = editor;
        this.myProject = project2;
        this.myType = type2;
    }

    public void actionPerformed(AnActionEvent e) {
        Facet facet;
        FacetInfo parent = this.myEditor.getSelectedFacetInfo();
        FacetTypeId underlyingFacetType = this.myType.getUnderlyingFacetType();
        if (parent == null && underlyingFacetType == null || parent != null && parent.getFacetType().getId() == underlyingFacetType) {
            facet = this.myEditor.createFacet(parent, this.myType);
        } else {
            LOG.assertTrue(parent != null);
            FacetInfo grandParent = this.myEditor.getParent(parent);
            LOG.assertTrue(grandParent == null && underlyingFacetType == null || grandParent != null && grandParent.getFacetType().getId() == underlyingFacetType);
            facet = this.myEditor.createFacet(grandParent, this.myType);
        }
        ProjectStructureConfigurable.getInstance(this.myProject).select(facet, true);
    }

    public void update(AnActionEvent e) {
        e.getPresentation().setVisible(AddFacetToModuleAction.isVisible(this.myEditor, this.myType));
    }

    public static boolean isVisible(FacetEditorFacade editor, FacetType<?, ?> type2) {
        ModuleType moduleType = editor.getSelectedModuleType();
        if (moduleType == null || !type2.isSuitableModuleType(moduleType)) {
            return false;
        }
        FacetTypeId underlyingTypeId = type2.getUnderlyingFacetType();
        FacetInfo selectedFacet = editor.getSelectedFacetInfo();
        if (selectedFacet == null) {
            return underlyingTypeId == null && AddFacetToModuleAction.canAddFacet(null, type2, editor);
        }
        FacetTypeId selectedFacetType = selectedFacet.getFacetType().getId();
        if (selectedFacetType == underlyingTypeId) {
            return AddFacetToModuleAction.canAddFacet(selectedFacet, type2, editor);
        }
        FacetInfo parent = editor.getParent(selectedFacet);
        if (!AddFacetToModuleAction.canAddFacet(parent, type2, editor)) {
            return false;
        }
        return parent == null && underlyingTypeId == null || parent != null && parent.getFacetType().getId() == underlyingTypeId;
    }

    private static boolean canAddFacet(FacetInfo selectedFacet, FacetType<?, ?> type2, FacetEditorFacade editor) {
        return !type2.isOnlyOneFacetAllowed() || !editor.nodeHasFacetOfType(selectedFacet, type2.getId());
    }

    public static Collection<AnAction> createAddFrameworkActions(FacetEditorFacade editor, Project project2) {
        TreeMap<String, Object> actions = new TreeMap<String, Object>();
        for (FrameworkTypeEx frameworkTypeEx : (FrameworkTypeEx[])FrameworkTypeEx.EP_NAME.getExtensions()) {
            AddFrameworkSupportInProjectStructureAction action = new AddFrameworkSupportInProjectStructureAction(frameworkTypeEx, frameworkTypeEx.createProvider(), ModuleStructureConfigurable.getInstance(project2));
            actions.put(frameworkTypeEx.getPresentableName(), (Object)action);
        }
        for (FrameworkTypeEx frameworkTypeEx : FacetTypeRegistry.getInstance().getFacetTypes()) {
            actions.put(frameworkTypeEx.getPresentableName(), (Object)new AddFacetToModuleAction(editor, project2, (FacetType)frameworkTypeEx));
        }
        return actions.values();
    }
}

