/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find;

import com.intellij.find.FindInProjectSettings;
import com.intellij.find.SearchTextArea;
import com.intellij.find.editorHeaderActions.ContextAwareShortcutProvider;
import com.intellij.find.editorHeaderActions.ShowMoreOptions;
import com.intellij.find.editorHeaderActions.Utils;
import com.intellij.find.editorHeaderActions.VariantsCompletionAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.impl.EditorHeaderComponent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.LightColors;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.speedSearch.SpeedSearchSupply;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventListener;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchReplaceComponent
extends EditorHeaderComponent
implements DataProvider {
    private final EventDispatcher<Listener> myEventDispatcher = EventDispatcher.create(Listener.class);
    private final MyTextComponentWrapper mySearchFieldWrapper;
    private JTextComponent mySearchTextComponent;
    private final MyTextComponentWrapper myReplaceFieldWrapper;
    private JTextComponent myReplaceTextComponent;
    private final JPanel myLeftPanel;
    private final JPanel myRightPanel;
    private final DefaultActionGroup mySearchFieldActions;
    private final ActionToolbarImpl mySearchActionsToolbar1;
    private final ActionToolbarImpl mySearchActionsToolbar2;
    private final ActionToolbarImpl.PopupStateModifier mySearchToolbar1PopupStateModifier;
    private final DefaultActionGroup myReplaceFieldActions;
    private final ActionToolbarImpl myReplaceActionsToolbar1;
    private final ActionToolbarImpl myReplaceActionsToolbar2;
    private final JPanel myReplaceToolbarWrapper;
    private final Project myProject;
    private final JComponent myTargetComponent;
    private final Runnable myCloseAction;
    private final Runnable myReplaceAction;
    private final DataProvider myDataProviderDelegate;
    private boolean myMultilineMode;
    private String myStatusText = "";

    @NotNull
    public static Builder buildFor(@Nullable Project project2, @NotNull JComponent component) {
        return new Builder(project2, component);
    }

    private SearchReplaceComponent(@Nullable Project project2, @NotNull JComponent targetComponent, @NotNull DefaultActionGroup searchToolbar1Actions, final @NotNull BooleanGetter searchToolbar1ModifiedFlagGetter, @NotNull DefaultActionGroup searchToolbar2Actions, @NotNull DefaultActionGroup searchFieldActions, @NotNull DefaultActionGroup replaceToolbar1Actions, @NotNull DefaultActionGroup replaceToolbar2Actions, @NotNull DefaultActionGroup replaceFieldActions, @Nullable Runnable replaceAction, @Nullable Runnable closeAction, @Nullable DataProvider dataProvider) {
        this.myProject = project2;
        this.myTargetComponent = targetComponent;
        this.mySearchFieldActions = searchFieldActions;
        this.myReplaceFieldActions = replaceFieldActions;
        this.myReplaceAction = replaceAction;
        this.myCloseAction = closeAction;
        this.mySearchToolbar1PopupStateModifier = new ActionToolbarImpl.PopupStateModifier(){

            @Override
            public int getModifiedPopupState() {
                return -1;
            }

            @Override
            public boolean willModify() {
                return searchToolbar1ModifiedFlagGetter.get();
            }
        };
        this.mySearchFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.mySearchTextComponent = 2.unwrapTextComponent(wrapped);
            }
        };
        this.myReplaceFieldWrapper = new MyTextComponentWrapper(){

            public void setContent(JComponent wrapped) {
                super.setContent(wrapped);
                SearchReplaceComponent.this.myReplaceTextComponent = 3.unwrapTextComponent(wrapped);
            }
        };
        this.myLeftPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myLeftPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        this.myLeftPanel.add((Component)((Object)this.mySearchFieldWrapper), "North");
        this.myLeftPanel.add((Component)((Object)this.myReplaceFieldWrapper), "South");
        this.mySearchActionsToolbar1 = this.createSearchToolbar1(searchToolbar1Actions);
        NonOpaquePanel searchToolbarWrapper1 = new NonOpaquePanel((LayoutManager)new BorderLayout());
        searchToolbarWrapper1.add((Component)this.mySearchActionsToolbar1, (Object)"West");
        this.mySearchActionsToolbar2 = this.createSearchToolbar2(searchToolbar2Actions);
        Wrapper searchToolbarWrapper2 = new Wrapper((JComponent)this.mySearchActionsToolbar2);
        this.mySearchActionsToolbar2.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        Wrapper searchPair = new NonOpaquePanel((LayoutManager)new BorderLayout()).setVerticalSizeReferent((JComponent)((Object)this.mySearchFieldWrapper));
        searchPair.add((Component)searchToolbarWrapper1, "West");
        searchPair.add((Component)searchToolbarWrapper2, "Center");
        this.myReplaceActionsToolbar1 = this.createReplaceToolbar1(replaceToolbar1Actions);
        Wrapper replaceToolbarWrapper1 = new Wrapper((JComponent)this.myReplaceActionsToolbar1).setVerticalSizeReferent((JComponent)((Object)this.myReplaceFieldWrapper));
        this.myReplaceActionsToolbar2 = this.createReplaceToolbar2(replaceToolbar2Actions);
        Wrapper replaceToolbarWrapper2 = new Wrapper((JComponent)this.myReplaceActionsToolbar2).setVerticalSizeReferent((JComponent)((Object)this.myReplaceFieldWrapper));
        this.myReplaceActionsToolbar2.setBorder((Border)JBUI.Borders.emptyLeft((int)16));
        this.myReplaceToolbarWrapper = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper1, "West");
        this.myReplaceToolbarWrapper.add((Component)replaceToolbarWrapper2, "Center");
        searchToolbarWrapper1.setHorizontalSizeReferent((JComponent)replaceToolbarWrapper1);
        JLabel closeLabel = new JLabel(null, AllIcons.Actions.Cross, 4);
        closeLabel.setBorder(JBUI.Borders.empty((int)5));
        closeLabel.setVerticalAlignment(1);
        closeLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SearchReplaceComponent.this.close();
            }
        });
        closeLabel.setToolTipText("Close search bar (Escape)");
        searchPair.add((Component)new Wrapper.North((JComponent)closeLabel), "East");
        this.myRightPanel = new NonOpaquePanel((LayoutManager)new BorderLayout());
        this.myRightPanel.add((Component)searchPair, "North");
        this.myRightPanel.add((Component)this.myReplaceToolbarWrapper, "Center");
        OnePixelSplitter splitter = new OnePixelSplitter(false, 0.25f);
        this.myRightPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)6));
        splitter.setFirstComponent((JComponent)this.myLeftPanel);
        splitter.setSecondComponent((JComponent)this.myRightPanel);
        splitter.setHonorComponentsMinimumSize(true);
        splitter.setAndLoadSplitterProportionKey("FindSplitterProportion");
        splitter.setOpaque(false);
        splitter.getDivider().setOpaque(false);
        this.add((Component)splitter, "Center");
        this.update("", "", false, false);
        this.myDataProviderDelegate = dataProvider;
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy());
    }

    public void resetUndoRedoActions() {
        UIUtil.resetUndoRedoActions((JTextComponent)this.mySearchTextComponent);
        UIUtil.resetUndoRedoActions((JTextComponent)this.myReplaceTextComponent);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.addTextToRecent(this.mySearchTextComponent);
        if (this.myReplaceTextComponent != null) {
            this.addTextToRecent(this.myReplaceTextComponent);
        }
    }

    public void requestFocusInTheSearchFieldAndSelectContent(Project project2) {
        this.mySearchTextComponent.selectAll();
        IdeFocusManager.getInstance((Project)project2).requestFocus((Component)this.mySearchTextComponent, true);
        if (this.myReplaceTextComponent != null) {
            this.myReplaceTextComponent.selectAll();
        }
    }

    public void setStatusText(@NotNull String status) {
        this.myStatusText = status;
    }

    @NotNull
    public String getStatusText() {
        return this.myStatusText;
    }

    public void replace() {
        if (this.myReplaceAction != null) {
            this.myReplaceAction.run();
        }
    }

    public void close() {
        if (this.myCloseAction != null) {
            this.myCloseAction.run();
        }
    }

    public void setRegularBackground() {
        this.mySearchTextComponent.setBackground(UIUtil.getTextFieldBackground());
    }

    public void setNotFoundBackground() {
        this.mySearchTextComponent.setBackground(LightColors.RED);
    }

    @Override
    public Insets getInsets() {
        Insets insets = super.getInsets();
        if (UIUtil.isUnderGTKLookAndFeel() || UIUtil.isUnderNimbusLookAndFeel()) {
            ++insets.top;
            insets.bottom += 2;
        }
        return insets;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (SpeedSearchSupply.SPEED_SEARCH_CURRENT_QUERY.is(dataId)) {
            return this.mySearchTextComponent.getText();
        }
        return this.myDataProviderDelegate != null ? this.myDataProviderDelegate.getData(dataId) : null;
    }

    public Project getProject() {
        return this.myProject;
    }

    public void addListener(@NotNull Listener listener2) {
        this.myEventDispatcher.addListener((EventListener)listener2);
    }

    public boolean isMultiline() {
        return this.myMultilineMode;
    }

    private void setMultilineInternal(boolean multiline) {
        boolean stateChanged = multiline != this.myMultilineMode;
        this.myMultilineMode = multiline;
        if (stateChanged) {
            this.multilineStateChanged();
        }
    }

    @NotNull
    public JTextComponent getSearchTextComponent() {
        return this.mySearchTextComponent;
    }

    @NotNull
    public JTextComponent getReplaceTextComponent() {
        return this.myReplaceTextComponent;
    }

    private void updateSearchComponent(@NotNull String textToSet) {
        if (!this.updateTextComponent(true)) {
            String existingText = this.mySearchTextComponent.getText();
            if (!existingText.equals(textToSet)) {
                this.mySearchTextComponent.setText(textToSet);
                if (existingText.length() == 0) {
                    this.mySearchTextComponent.selectAll();
                }
            }
            return;
        }
        this.mySearchTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> SearchReplaceComponent.this.searchFieldDocumentChanged());
            }
        });
        this.mySearchTextComponent.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (StringUtil.isEmpty((String)SearchReplaceComponent.this.mySearchTextComponent.getText())) {
                    SearchReplaceComponent.this.close();
                } else {
                    IdeFocusManager.getInstance((Project)SearchReplaceComponent.this.myProject).requestFocus((Component)SearchReplaceComponent.this.myTargetComponent, true);
                    SearchReplaceComponent.this.addTextToRecent(SearchReplaceComponent.this.mySearchTextComponent);
                }
            }
        }, KeyStroke.getKeyStroke(10, SystemInfo.isMac ? 256 : 128), 0);
        new VariantsCompletionAction(this.mySearchTextComponent);
    }

    private void updateReplaceComponent(@NotNull String textToSet) {
        if (!this.updateTextComponent(false)) {
            String existingText = this.myReplaceTextComponent.getText();
            if (!existingText.equals(textToSet)) {
                this.myReplaceTextComponent.setText(textToSet);
                if (existingText.length() == 0) {
                    this.myReplaceTextComponent.selectAll();
                }
            }
            return;
        }
        this.myReplaceTextComponent.setText(textToSet);
        this.myReplaceTextComponent.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ApplicationManager.getApplication().invokeLater(() -> SearchReplaceComponent.this.replaceFieldDocumentChanged());
            }
        });
        if (!this.isMultiline()) {
            this.installReplaceOnEnterAction(this.myReplaceTextComponent);
        }
        new VariantsCompletionAction(this.myReplaceTextComponent);
        this.myReplaceFieldWrapper.revalidate();
        this.myReplaceFieldWrapper.repaint();
    }

    public void update(@NotNull String findText, @NotNull String replaceText, boolean replaceMode, boolean multiline) {
        this.setMultilineInternal(multiline);
        boolean needToResetSearchFocus = this.mySearchTextComponent != null && this.mySearchTextComponent.hasFocus();
        boolean needToResetReplaceFocus = this.myReplaceTextComponent != null && this.myReplaceTextComponent.hasFocus();
        this.updateSearchComponent(findText);
        this.updateReplaceComponent(replaceText);
        if (replaceMode) {
            if (this.myReplaceFieldWrapper.getParent() == null) {
                this.myLeftPanel.add((Component)((Object)this.myReplaceFieldWrapper), "Center");
            }
            if (this.myReplaceToolbarWrapper.getParent() == null) {
                this.myRightPanel.add((Component)this.myReplaceToolbarWrapper, "Center");
            }
            if (needToResetReplaceFocus) {
                this.myReplaceTextComponent.requestFocusInWindow();
            }
        } else {
            if (this.myReplaceFieldWrapper.getParent() != null) {
                this.myLeftPanel.remove((Component)((Object)this.myReplaceFieldWrapper));
            }
            if (this.myReplaceToolbarWrapper.getParent() != null) {
                this.myRightPanel.remove(this.myReplaceToolbarWrapper);
            }
        }
        if (needToResetSearchFocus) {
            this.mySearchTextComponent.requestFocusInWindow();
        }
        this.updateBindings();
        this.updateActions();
        this.revalidate();
        this.repaint();
    }

    public void updateActions() {
        this.mySearchActionsToolbar1.updateActionsImmediately();
        this.mySearchActionsToolbar2.updateActionsImmediately();
        this.myReplaceActionsToolbar1.updateActionsImmediately();
        this.myReplaceActionsToolbar2.updateActionsImmediately();
    }

    public void addTextToRecent(@NotNull JTextComponent textField) {
        String text = textField.getText();
        if (text.length() > 0) {
            FindInProjectSettings findInProjectSettings = FindInProjectSettings.getInstance(this.myProject);
            if (textField == this.mySearchTextComponent) {
                findInProjectSettings.addStringToFind(text);
                if (this.mySearchFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.mySearchFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            } else {
                findInProjectSettings.addStringToReplace(text);
                if (this.myReplaceFieldWrapper.getTargetComponent() instanceof SearchTextField) {
                    ((SearchTextField)this.myReplaceFieldWrapper.getTargetComponent()).addCurrentTextToHistory();
                }
            }
        }
    }

    private boolean updateTextComponent(boolean search) {
        JTextComponent oldComponent;
        JTextComponent jTextComponent = oldComponent = search ? this.mySearchTextComponent : this.myReplaceTextComponent;
        if (oldComponent != null) {
            return false;
        }
        MyTextComponentWrapper wrapper = search ? this.mySearchFieldWrapper : this.myReplaceFieldWrapper;
        SearchTextArea textArea = new SearchTextArea(search);
        final JTextArea textComponent = textArea.getTextArea();
        textComponent.setRows(this.isMultiline() ? 2 : 1);
        wrapper.setContent((JComponent)((Object)textArea));
        UIUtil.addUndoRedoActions((JTextComponent)textComponent);
        if (UIUtil.isUnderWindowsLookAndFeel()) {
            ((JComponent)textComponent).setFont(UIManager.getFont("TextField.font"));
        } else {
            Utils.setSmallerFont(textComponent);
        }
        textComponent.putClientProperty("AuxEditorComponent", Boolean.TRUE);
        textComponent.setBackground(UIUtil.getTextFieldBackground());
        textComponent.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                textComponent.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
                textComponent.repaint();
            }
        });
        this.installCloseOnEscapeAction(textComponent);
        return true;
    }

    private void searchFieldDocumentChanged() {
        if (this.mySearchTextComponent instanceof JTextArea) {
            SearchReplaceComponent.adjustRows((JTextArea)this.mySearchTextComponent);
        }
        ((Listener)this.myEventDispatcher.getMulticaster()).searchFieldDocumentChanged();
    }

    private void replaceFieldDocumentChanged() {
        if (this.myReplaceTextComponent instanceof JTextArea) {
            SearchReplaceComponent.adjustRows((JTextArea)this.myReplaceTextComponent);
        }
        this.myReplaceActionsToolbar2.invalidate();
        this.doLayout();
        ((Listener)this.myEventDispatcher.getMulticaster()).replaceFieldDocumentChanged();
    }

    private void multilineStateChanged() {
        ((Listener)this.myEventDispatcher.getMulticaster()).multilineStateChanged();
    }

    private static void adjustRows(@NotNull JTextArea area) {
        area.setRows(Math.max(1, Math.min(3, StringUtil.countChars((CharSequence)area.getText(), (char)'\n') + 1)));
    }

    private void installCloseOnEscapeAction(@NotNull JTextComponent c) {
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchReplaceComponent.this.close();
            }
        };
        c.registerKeyboardAction(action, KeyStroke.getKeyStroke(27, 0), 0);
        if (KeymapUtil.isEmacsKeymap()) {
            c.registerKeyboardAction(action, KeyStroke.getKeyStroke(71, 2), 0);
        }
    }

    private void installReplaceOnEnterAction(@NotNull JTextComponent c) {
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchReplaceComponent.this.replace();
            }
        };
        c.registerKeyboardAction(action, KeyStroke.getKeyStroke(10, 0), 0);
    }

    private void updateBindings() {
        this.updateBindings(this.mySearchFieldActions, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.mySearchActionsToolbar1, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.mySearchActionsToolbar2, (JComponent)((Object)this.mySearchFieldWrapper));
        this.updateBindings(this.myReplaceFieldActions, (JComponent)((Object)this.myReplaceFieldWrapper));
        this.updateBindings(this.myReplaceActionsToolbar1, (JComponent)this.myReplaceToolbarWrapper);
        this.updateBindings(this.myReplaceActionsToolbar2, (JComponent)this.myReplaceToolbarWrapper);
    }

    private void updateBindings(@NotNull DefaultActionGroup group, @NotNull JComponent shortcutHolder) {
        this.updateBindings((List<? extends AnAction>)ContainerUtil.immutableList((Object[])group.getChildActionsOrStubs()), shortcutHolder);
    }

    private void updateBindings(@NotNull ActionToolbarImpl toolbar, @NotNull JComponent shortcutHolder) {
        this.updateBindings(toolbar.getActions(), shortcutHolder);
    }

    private void updateBindings(@NotNull List<? extends AnAction> actions, @NotNull JComponent shortcutHolder) {
        DataContext context = DataManager.getInstance().getDataContext((Component)this);
        for (AnAction anAction : actions) {
            ShortcutSet shortcut = null;
            if (anAction instanceof ContextAwareShortcutProvider) {
                shortcut = ((ContextAwareShortcutProvider)anAction).getShortcut(context);
            } else if (anAction instanceof ShortcutProvider) {
                shortcut = ((ShortcutProvider)anAction).getShortcut();
            }
            if (shortcut == null) continue;
            anAction.registerCustomShortcutSet(shortcut, shortcutHolder);
        }
    }

    @NotNull
    private ActionToolbarImpl createSearchToolbar1(@NotNull DefaultActionGroup group) {
        ActionToolbarImpl toolbar = this.createToolbar((ActionGroup)group);
        toolbar.setForceMinimumSize(true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        toolbar.setSecondaryButtonPopupStateModifier(this.mySearchToolbar1PopupStateModifier);
        toolbar.setSecondaryActionsTooltip("More Options(" + ShowMoreOptions.SHORT_CUT + ")");
        new ShowMoreOptions(toolbar, (JComponent)((Object)this.mySearchFieldWrapper));
        return toolbar;
    }

    @NotNull
    private ActionToolbarImpl createSearchToolbar2(@NotNull DefaultActionGroup group) {
        return this.createToolbar((ActionGroup)group);
    }

    @NotNull
    private ActionToolbarImpl createReplaceToolbar1(@NotNull DefaultActionGroup group) {
        ActionToolbarImpl toolbar = this.createToolbar((ActionGroup)group);
        toolbar.setForceMinimumSize(true);
        toolbar.setReservePlaceAutoPopupIcon(false);
        return toolbar;
    }

    @NotNull
    private ActionToolbarImpl createReplaceToolbar2(@NotNull DefaultActionGroup group) {
        return this.createToolbar((ActionGroup)group);
    }

    @NotNull
    private ActionToolbarImpl createToolbar(@NotNull ActionGroup group) {
        return this.tweakToolbar((ActionToolbarImpl)ActionManager.getInstance().createActionToolbar("EditorToolbar", group, true));
    }

    @NotNull
    private ActionToolbarImpl tweakToolbar(@NotNull ActionToolbarImpl toolbar) {
        toolbar.setTargetComponent(this);
        toolbar.setLayoutPolicy(2);
        toolbar.setBorder(null);
        Utils.setSmallerFontForChildren(toolbar);
        return toolbar;
    }

    private static class MyTextComponentWrapper
    extends Wrapper {
        private MyTextComponentWrapper() {
        }

        @Nullable
        public JTextComponent getTextComponent() {
            JComponent wrapped = this.getTargetComponent();
            return wrapped != null ? MyTextComponentWrapper.unwrapTextComponent(wrapped) : null;
        }

        @NotNull
        protected static JTextComponent unwrapTextComponent(@NotNull JComponent wrapped) {
            if (wrapped instanceof SearchTextField) {
                return ((SearchTextField)wrapped).getTextEditor();
            }
            if (wrapped instanceof SearchTextArea) {
                return ((SearchTextArea)((Object)wrapped)).getTextArea();
            }
            throw new AssertionError();
        }
    }

    public static class Builder {
        private final Project myProject;
        private final JComponent myTargetComponent;
        private DataProvider myDataProvider;
        private Runnable myReplaceAction;
        private Runnable myCloseAction;
        private DefaultActionGroup mySearchActions = new DefaultActionGroup("search bar 1", false);
        private DefaultActionGroup myExtraSearchActions = new DefaultActionGroup("search bar 2", false);
        private DefaultActionGroup mySearchFieldActions = new DefaultActionGroup("search field actions", false);
        private BooleanGetter mySearchToolbarModifiedFlagGetter = BooleanGetter.FALSE;
        private DefaultActionGroup myReplaceActions = new DefaultActionGroup("replace bar 1", false);
        private DefaultActionGroup myExtraReplaceActions = new DefaultActionGroup("replace bar 1", false);
        private DefaultActionGroup myReplaceFieldActions = new DefaultActionGroup("replace field actions", false);

        private Builder(@Nullable Project project2, @NotNull JComponent component) {
            this.myProject = project2;
            this.myTargetComponent = component;
        }

        @NotNull
        public Builder withDataProvider(@NotNull DataProvider provider2) {
            this.myDataProvider = provider2;
            return this;
        }

        @NotNull
        public Builder withReplaceAction(@NotNull Runnable action) {
            this.myReplaceAction = action;
            return this;
        }

        @NotNull
        public Builder withCloseAction(@NotNull Runnable action) {
            this.myCloseAction = action;
            return this;
        }

        @NotNull
        public Builder addSearchFieldActions(AnAction ... actions) {
            this.mySearchFieldActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addReplaceFieldActions(AnAction ... actions) {
            this.myReplaceFieldActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addPrimarySearchActions(AnAction ... actions) {
            this.mySearchActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addSecondarySearchActions(AnAction ... actions) {
            for (AnAction action : actions) {
                this.mySearchActions.addAction(action).setAsSecondary(true);
            }
            return this;
        }

        @NotNull
        public Builder withSecondarySearchActionsIsModifiedGetter(@NotNull BooleanGetter getter) {
            this.mySearchToolbarModifiedFlagGetter = getter;
            return this;
        }

        @NotNull
        public Builder addExtraSearchActions(AnAction ... actions) {
            this.myExtraSearchActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addPrimaryReplaceActions(AnAction ... actions) {
            this.myReplaceActions.addAll(actions);
            return this;
        }

        @NotNull
        public Builder addExtraReplaceAction(AnAction ... actions) {
            this.myExtraReplaceActions.addAll(actions);
            return this;
        }

        @NotNull
        public SearchReplaceComponent build() {
            return new SearchReplaceComponent(this.myProject, this.myTargetComponent, this.mySearchActions, this.mySearchToolbarModifiedFlagGetter, this.myExtraSearchActions, this.mySearchFieldActions, this.myReplaceActions, this.myExtraReplaceActions, this.myReplaceFieldActions, this.myReplaceAction, this.myCloseAction, this.myDataProvider);
        }
    }

    public static interface Listener
    extends EventListener {
        public void searchFieldDocumentChanged();

        public void replaceFieldDocumentChanged();

        public void multilineStateChanged();
    }
}

