/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.find.actions.ShowUsagesAction;
import com.intellij.openapi.fileEditor.impl.EditorTabbedContainer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.usages.TextChunk;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsagePresentation;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.rules.UsageInFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;

class ShowUsagesTableCellRenderer
implements TableCellRenderer {
    private final UsageViewImpl myUsageView;
    @NotNull
    private final AtomicInteger myOutOfScopeUsages;
    @NotNull
    private final SearchScope mySearchScope;

    ShowUsagesTableCellRenderer(@NotNull UsageViewImpl usageView, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        this.myUsageView = usageView;
        this.myOutOfScopeUsages = outOfScopeUsages;
        this.mySearchScope = searchScope;
    }

    @Override
    public Component getTableCellRendererComponent(JTable list, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
        UsageNode usageNode = value2 instanceof UsageNode ? (UsageNode)value2 : null;
        Usage usage = usageNode == null ? null : usageNode.getUsage();
        Color fileBgColor = this.getBackgroundColor(isSelected, usage);
        Color bg = UIUtil.getListSelectionBackground();
        Color fg = UIUtil.getListSelectionForeground();
        Color panelBackground = isSelected ? bg : (fileBgColor == null ? list.getBackground() : fileBgColor);
        Color panelForeground = isSelected ? fg : list.getForeground();
        SimpleColoredComponent textChunks = new SimpleColoredComponent();
        if (usageNode == null || usageNode instanceof ShowUsagesAction.StringNode) {
            textChunks.append(ObjectUtils.notNull((Object)value2, (Object)"").toString(), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, panelBackground, panelForeground, column, list);
        }
        if (usage == ShowUsagesAction.MORE_USAGES_SEPARATOR) {
            textChunks.append("...<");
            textChunks.append("more usages", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, panelBackground, panelForeground, column, list);
        }
        if (usage == ShowUsagesAction.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
            textChunks.append("...<");
            textChunks.append(UsageViewManagerImpl.outOfScopeMessage((int)this.myOutOfScopeUsages.get(), (SearchScope)this.mySearchScope), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            textChunks.append(">...");
            return ShowUsagesTableCellRenderer.textComponentSpanningWholeRow(textChunks, panelBackground, panelForeground, column, list);
        }
        boolean lineNumberColumn = column == 1;
        JPanel panel2 = new JPanel(new FlowLayout(lineNumberColumn ? 2 : 0, 0, 0){

            @Override
            public void layoutContainer(Container container) {
                super.layoutContainer(container);
                for (Component component : container.getComponents()) {
                    Rectangle b = component.getBounds();
                    Insets insets = container.getInsets();
                    component.setBounds(b.x, b.y, b.width, container.getSize().height - insets.top - insets.bottom);
                }
            }
        });
        panel2.setFont(null);
        panel2.setBackground(panelBackground);
        panel2.setForeground(panelForeground);
        boolean isEnabled = true;
        if (!isEnabled) {
            fg = UIUtil.getLabelDisabledForeground();
        }
        if (column == 0) {
            this.appendGroupText(list, (GroupNode)usageNode.getParent(), panel2, fileBgColor, isSelected);
        } else {
            if (usage != ShowUsagesAction.MORE_USAGES_SEPARATOR && usage != ShowUsagesAction.USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                UsagePresentation presentation = usage.getPresentation();
                TextChunk[] text = presentation.getText();
                if (lineNumberColumn) {
                    if (text.length != 0) {
                        TextChunk chunk = text[0];
                        textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, bg, fg, chunk));
                    }
                } else if (column == 2) {
                    Icon icon = presentation.getIcon();
                    textChunks.setIcon(icon == null ? EmptyIcon.ICON_16 : icon);
                    textChunks.append("").appendTextPadding(JBUI.scale((int)21));
                    for (int i2 = 1; i2 < text.length; ++i2) {
                        TextChunk chunk = text[i2];
                        textChunks.append(chunk.getText(), ShowUsagesTableCellRenderer.getAttributes(isSelected, fileBgColor, bg, fg, chunk));
                    }
                } else assert (false) : column;
            }
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)list, (SimpleColoredComponent)textChunks, (boolean)false, (boolean)isSelected);
            panel2.add((Component)textChunks);
        }
        if (!isEnabled) {
            GuiUtils.enableChildren((Component)panel2, (boolean)false, (JComponent[])new JComponent[0]);
        }
        return panel2;
    }

    @NotNull
    private static SimpleTextAttributes getAttributes(boolean isSelected, Color fileBgColor, Color bg, Color fg, @NotNull TextChunk chunk) {
        SimpleTextAttributes background = chunk.getSimpleAttributesIgnoreBackground();
        return isSelected ? new SimpleTextAttributes(bg, fg, null, background.getStyle()) : ShowUsagesTableCellRenderer.deriveAttributesWithColor(background, fileBgColor);
    }

    @NotNull
    private static Component textComponentSpanningWholeRow(@NotNull SimpleColoredComponent chunks, Color panelBackground, Color panelForeground, final int column, final @NotNull JTable table) {
        SimpleColoredComponent component = new SimpleColoredComponent(){

            protected void doPaint(Graphics2D g) {
                int offset = 0;
                TableColumnModel columnModel = table.getColumnModel();
                for (int i2 = 0; i2 < column; ++i2) {
                    offset += columnModel.getColumn(i2).getWidth();
                }
                g.translate(-offset, 0);
                this.setSize(this.getWidth() + offset, this.getHeight());
                super.doPaint(g);
                g.translate(offset, 0);
            }

            @NotNull
            public Dimension getPreferredSize() {
                return column == table.getColumnModel().getColumnCount() - 1 ? super.getPreferredSize() : new Dimension(0, 0);
            }
        };
        component.setBackground(panelBackground);
        component.setForeground(panelForeground);
        SimpleColoredComponent.ColoredIterator iterator = chunks.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            String fragment = iterator.getFragment();
            SimpleTextAttributes attributes = iterator.getTextAttributes();
            attributes = attributes.derive(attributes.getStyle(), panelForeground, panelBackground, attributes.getWaveColor());
            component.append(fragment, attributes);
        }
        return component;
    }

    private static SimpleTextAttributes deriveAttributesWithColor(SimpleTextAttributes attributes, Color fileBgColor) {
        if (fileBgColor != null) {
            attributes = attributes.derive(-1, null, fileBgColor, null);
        }
        return attributes;
    }

    private Color getBackgroundColor(boolean isSelected, Usage usage) {
        Color fileBgColor = null;
        if (isSelected) {
            fileBgColor = UIUtil.getListSelectionBackground();
        } else {
            Project project2;
            Color color;
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = usage instanceof UsageInFile ? ((UsageInFile)usage).getFile() : null;
            if (virtualFile != null && (color = EditorTabbedContainer.calcTabColor(project2 = this.myUsageView.getProject(), virtualFile)) != null) {
                fileBgColor = color;
            }
        }
        return fileBgColor;
    }

    private void appendGroupText(JTable table, GroupNode node, JPanel panel2, Color fileBgColor, boolean isSelected) {
        UsageGroup group;
        UsageGroup usageGroup = group = node == null ? null : node.getGroup();
        if (group == null) {
            return;
        }
        GroupNode parentGroup = (GroupNode)node.getParent();
        this.appendGroupText(table, parentGroup, panel2, fileBgColor, isSelected);
        if (node.canNavigateToSource()) {
            SimpleColoredComponent renderer = new SimpleColoredComponent();
            renderer.setIcon(group.getIcon(false));
            SimpleTextAttributes attributes = ShowUsagesTableCellRenderer.deriveAttributesWithColor(SimpleTextAttributes.REGULAR_ATTRIBUTES, fileBgColor);
            renderer.append(group.getText((UsageView)this.myUsageView), attributes);
            renderer.setBorder(null);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)table, (SimpleColoredComponent)renderer, (boolean)false, (boolean)isSelected);
            panel2.add((Component)renderer);
        }
    }
}

