/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.find.EditorSearchSession;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.project.DumbAwareAction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OccurrenceAction
extends DumbAwareAction
implements ShortcutProvider {
    protected OccurrenceAction(@NotNull String baseActionId, @NotNull Icon icon) {
        this.copyFrom(ActionManager.getInstance().getAction(baseActionId));
        this.getTemplatePresentation().setIcon(icon);
    }

    public void update(AnActionEvent e) {
        EditorSearchSession search = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        if (search == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean isFind = !search.getFindModel().isReplaceState();
        boolean hasMatches = search.hasMatches();
        e.getPresentation().setVisible(isFind);
        e.getPresentation().setEnabled(isFind && hasMatches);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        return this.getShortcutSet();
    }
}

