/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.editorHeaderActions;

import com.intellij.execution.impl.ConsoleViewUtil;
import com.intellij.find.EditorSearchSession;
import com.intellij.find.FindModel;
import com.intellij.find.FindUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SwitchToReplace
extends AnAction {
    public SwitchToReplace(@NotNull JComponent shortcutHolder) {
        AnAction replaceAction = ActionManager.getInstance().getAction("Replace");
        if (replaceAction != null) {
            this.registerCustomShortcutSet(replaceAction.getShortcutSet(), shortcutHolder);
        }
    }

    public void update(AnActionEvent e) {
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR_EVEN_IF_INACTIVE);
        EditorSearchSession search = (EditorSearchSession)e.getData(EditorSearchSession.SESSION_KEY);
        e.getPresentation().setEnabled(editor != null && search != null && !ConsoleViewUtil.isConsoleViewEditor(editor));
    }

    public void actionPerformed(AnActionEvent e) {
        EditorSearchSession search = (EditorSearchSession)e.getRequiredData(EditorSearchSession.SESSION_KEY);
        FindModel findModel = search.getFindModel();
        FindUtil.configureFindModel(true, (Editor)e.getData(CommonDataKeys.EDITOR), findModel, false);
        search.getComponent().getSearchTextComponent().selectAll();
    }
}

