/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.CommonBundle;
import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindClassUsagesDialog;
import com.intellij.find.findUsages.FindMethodUsagesDialog;
import com.intellij.find.findUsages.FindPackageUsagesDialog;
import com.intellij.find.findUsages.FindThrowUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.FindVariableUsagesDialog;
import com.intellij.find.findUsages.JavaFindUsagesHandlerFactory;
import com.intellij.find.findUsages.JavaFindUsagesHelper;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.search.ThrowSearchUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiSuperMethodUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.util.JavaNonCodeSearchElementDescriptionProvider;
import com.intellij.refactoring.util.NonCodeSearchDescriptionLocation;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaFindUsagesHandler
extends FindUsagesHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.find.findUsages.JavaFindUsagesHandler");
    protected static final String ACTION_STRING = FindBundle.message("find.super.method.warning.action.verb", new Object[0]);
    private final PsiElement[] myElementsToSearch;
    private final JavaFindUsagesHandlerFactory myFactory;

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull JavaFindUsagesHandlerFactory factory) {
        this(psiElement, PsiElement.EMPTY_ARRAY, factory);
    }

    public JavaFindUsagesHandler(@NotNull PsiElement psiElement, @NotNull PsiElement[] elementsToSearch, @NotNull JavaFindUsagesHandlerFactory factory) {
        super(psiElement);
        this.myElementsToSearch = elementsToSearch;
        this.myFactory = factory;
    }

    @Override
    @NotNull
    public AbstractFindUsagesDialog getFindUsagesDialog(boolean isSingleFile, boolean toShowInNewTab, boolean mustOpenInNewTab) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            return new FindPackageUsagesDialog(element, this.getProject(), this.myFactory.getFindPackageOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        }
        if (element instanceof PsiClass) {
            return new FindClassUsagesDialog(element, this.getProject(), this.myFactory.getFindClassOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        }
        if (element instanceof PsiMethod) {
            return new FindMethodUsagesDialog(element, this.getProject(), this.myFactory.getFindMethodOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        }
        if (element instanceof PsiVariable) {
            return new FindVariableUsagesDialog(element, this.getProject(), this.myFactory.getFindVariableOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, this);
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            return new FindThrowUsagesDialog(element, this.getProject(), this.myFactory.getFindThrowOptions(), toShowInNewTab, mustOpenInNewTab, isSingleFile, (FindUsagesHandler)this);
        }
        return super.getFindUsagesDialog(isSingleFile, toShowInNewTab, mustOpenInNewTab);
    }

    private static boolean askWhetherShouldSearchForParameterInOverridingMethods(@NotNull PsiElement psiElement, @NotNull PsiParameter parameter) {
        JavaFindUsagesHandler.assertInTransaction();
        return Messages.showOkCancelDialog((Project)psiElement.getProject(), (String)FindBundle.message("find.parameter.usages.in.overriding.methods.prompt", parameter.getName()), (String)FindBundle.message("find.parameter.usages.in.overriding.methods.title", new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    @NotNull
    private static PsiElement[] getParameterElementsToSearch(@NotNull PsiParameter parameter, @NotNull PsiMethod method2) {
        PsiMethod[] overrides = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method2).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        for (int i2 = 0; i2 < overrides.length; ++i2) {
            PsiElement navigationElement = overrides[i2].getNavigationElement();
            if (!(navigationElement instanceof PsiMethod)) continue;
            overrides[i2] = (PsiMethod)navigationElement;
        }
        ArrayList<PsiParameter> elementsToSearch = new ArrayList<PsiParameter>(overrides.length + 1);
        elementsToSearch.add(parameter);
        int idx = method2.getParameterList().getParameterIndex(parameter);
        for (PsiMethod override : overrides) {
            PsiParameter[] parameters2 = override.getParameterList().getParameters();
            if (idx >= parameters2.length) continue;
            elementsToSearch.add(parameters2[idx]);
        }
        return PsiUtilCore.toPsiElementArray(elementsToSearch);
    }

    @Override
    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray;
        PsiMethod method2;
        PsiParameter parameter;
        PsiElement scope;
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiParameter && (scope = (parameter = (PsiParameter)element).getDeclarationScope()) instanceof PsiMethod && PsiUtil.canBeOverriden((PsiMethod)(method2 = (PsiMethod)scope))) {
            boolean hasOverridden;
            PsiClass aClass = method2.getContainingClass();
            LOG.assertTrue(aClass != null);
            boolean bl = hasOverridden = OverridingMethodsSearch.search((PsiMethod)method2).findFirst() != null;
            if (hasOverridden && JavaFindUsagesHandler.askWhetherShouldSearchForParameterInOverridingMethods(element, parameter)) {
                return JavaFindUsagesHandler.getParameterElementsToSearch(parameter, method2);
            }
        }
        if (this.myElementsToSearch.length == 0) {
            PsiElement[] psiElementArray2 = new PsiElement[1];
            psiElementArray = psiElementArray2;
            psiElementArray2[0] = element;
        } else {
            psiElementArray = this.myElementsToSearch;
        }
        return psiElementArray;
    }

    @Override
    @NotNull
    public PsiElement[] getSecondaryElements() {
        PsiField field;
        PsiClass containingClass;
        PsiElement element = this.getPsiElement();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return PsiElement.EMPTY_ARRAY;
        }
        if (element instanceof PsiField && (containingClass = (field = (PsiField)element).getContainingClass()) != null) {
            PsiMethod setter;
            String fieldName = field.getName();
            String propertyName = JavaCodeStyleManager.getInstance((Project)this.getProject()).variableNameToPropertyName(fieldName, VariableKind.FIELD);
            THashSet accessors = new THashSet();
            boolean isStatic = field.hasModifierProperty("static");
            PsiMethod getter = PropertyUtil.findPropertyGetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()));
            if (getter != null) {
                accessors.add(getter);
            }
            if ((setter = PropertyUtil.findPropertySetterWithType((String)propertyName, (boolean)isStatic, (PsiType)field.getType(), (Iterator)ContainerUtil.iterate((Object[])containingClass.getMethods()))) != null) {
                accessors.add(setter);
            }
            accessors.addAll(PropertyUtil.getAccessors((PsiClass)containingClass, (String)fieldName));
            if (!accessors.isEmpty()) {
                boolean doSearch;
                boolean containsPhysical = ContainerUtil.find((Iterable)accessors, psiMethod -> psiMethod.isPhysical()) != null;
                boolean bl = doSearch = !containsPhysical || JavaFindUsagesHandler.askShouldSearchAccessors(fieldName);
                if (doSearch) {
                    THashSet elements = new THashSet();
                    for (PsiMethod accessor : accessors) {
                        ContainerUtil.addAll((Collection)elements, (Object[])SuperMethodWarningUtil.checkSuperMethods(accessor, ACTION_STRING));
                    }
                    return PsiUtilCore.toPsiElementArray((Collection)elements);
                }
            }
        }
        return super.getSecondaryElements();
    }

    private static boolean askShouldSearchAccessors(String fieldName) {
        JavaFindUsagesHandler.assertInTransaction();
        return Messages.showOkCancelDialog((String)FindBundle.message("find.field.accessors.prompt", fieldName), (String)FindBundle.message("find.field.accessors.title", new Object[0]), (String)CommonBundle.getYesButtonText(), (String)CommonBundle.getNoButtonText(), (Icon)Messages.getQuestionIcon()) == 0;
    }

    private static void assertInTransaction() {
        LOG.assertTrue(TransactionGuard.getInstance().getContextTransaction() != null, (Object)"Find Usages should be shown in a transaction, see AnAction#startInTransaction");
    }

    @Override
    @NotNull
    public FindUsagesOptions getFindUsagesOptions(@Nullable DataContext dataContext) {
        PsiElement element = this.getPsiElement();
        if (element instanceof PsiPackage) {
            return this.myFactory.getFindPackageOptions();
        }
        if (element instanceof PsiClass) {
            return this.myFactory.getFindClassOptions();
        }
        if (element instanceof PsiMethod) {
            return this.myFactory.getFindMethodOptions();
        }
        if (element instanceof PsiVariable) {
            return this.myFactory.getFindVariableOptions();
        }
        if (ThrowSearchUtil.isSearchable(element)) {
            return this.myFactory.getFindThrowOptions();
        }
        return super.getFindUsagesOptions(dataContext);
    }

    protected Set<String> getStringsToSearch(@NotNull PsiElement element) {
        return JavaFindUsagesHelper.getElementNames(element);
    }

    @Override
    public boolean processElementUsages(@NotNull PsiElement element, @NotNull Processor<UsageInfo> processor2, @NotNull FindUsagesOptions options) {
        return JavaFindUsagesHelper.processElementUsages(element, options, processor2);
    }

    @Override
    protected boolean isSearchForTextOccurrencesAvailable(@NotNull PsiElement psiElement, boolean isSingleFile) {
        return !isSingleFile && new JavaNonCodeSearchElementDescriptionProvider().getElementDescription(psiElement, NonCodeSearchDescriptionLocation.NON_JAVA) != null;
    }

    @Override
    @NotNull
    public Collection<PsiReference> findReferencesToHighlight(@NotNull PsiElement target, @NotNull SearchScope searchScope) {
        if (target instanceof PsiMethod) {
            PsiMethod[] superMethods = ((PsiMethod)target).findDeepestSuperMethods();
            if (superMethods.length == 0) {
                return MethodReferencesSearch.search((PsiMethod)((PsiMethod)target), (SearchScope)searchScope, (boolean)true).findAll();
            }
            ArrayList<PsiReference> result2 = new ArrayList<PsiReference>();
            GlobalSearchScope resolveScope = null;
            if (searchScope instanceof LocalSearchScope) {
                Object[] scopeElements = ((LocalSearchScope)searchScope).getScope();
                resolveScope = GlobalSearchScope.union((GlobalSearchScope[])((GlobalSearchScope[])ContainerUtil.map2Array((Object[])scopeElements, GlobalSearchScope.class, PsiElement::getResolveScope)));
            }
            for (PsiMethod superMethod : superMethods) {
                if (resolveScope != null) {
                    superMethod = PsiSuperMethodUtil.correctMethodByScope((PsiMethod)superMethod, (GlobalSearchScope)resolveScope);
                }
                result2.addAll(MethodReferencesSearch.search((PsiMethod)superMethod, (SearchScope)searchScope, (boolean)true).findAll());
            }
            return result2;
        }
        return super.findReferencesToHighlight(target, searchScope);
    }
}

