/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.usages.ConfigurableUsageTarget;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.containers.hash.LinkedHashMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class UsageHistory {
    private final Map<ConfigurableUsageTarget, String> myHistory = new LinkedHashMap<ConfigurableUsageTarget, String>(EqualityPolicy.IDENTITY){

        protected boolean removeEldestEntry(Map.Entry<ConfigurableUsageTarget, String> eldest) {
            return this.size() > 15;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull ConfigurableUsageTarget usageTarget) {
        String descriptiveName = usageTarget.getLongDescriptiveName();
        Map<ConfigurableUsageTarget, String> map2 = this.myHistory;
        synchronized (map2) {
            Set<Map.Entry<ConfigurableUsageTarget, String>> entries = this.myHistory.entrySet();
            Iterator<Map.Entry<ConfigurableUsageTarget, String>> iterator = entries.iterator();
            while (iterator.hasNext()) {
                if (!iterator.next().getValue().equals(descriptiveName)) continue;
                iterator.remove();
            }
            this.myHistory.put(usageTarget, descriptiveName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<ConfigurableUsageTarget> getAll() {
        Map<ConfigurableUsageTarget, String> map2 = this.myHistory;
        synchronized (map2) {
            ArrayList result2 = ContainerUtil.newArrayList();
            Set<ConfigurableUsageTarget> entries = this.myHistory.keySet();
            Iterator<ConfigurableUsageTarget> iterator = entries.iterator();
            while (iterator.hasNext()) {
                ConfigurableUsageTarget target = iterator.next();
                if (!target.isValid()) {
                    iterator.remove();
                    continue;
                }
                result2.add(target);
            }
            return result2;
        }
    }
}

