/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.impl;

import com.intellij.openapi.application.PathMacroFilter;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.impl.stores.FileStorageCoreUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class FindInProjectSettingsBase
implements PersistentStateComponent<FindInProjectSettingsBase> {
    private static final int MAX_RECENT_SIZE = 30;
    @Tag(value="findStrings")
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="find", elementValueAttribute="")
    public List<String> findStrings = new ArrayList<String>();
    @Tag(value="replaceStrings")
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="replace", elementValueAttribute="")
    public List<String> replaceStrings = new ArrayList<String>();
    @Tag(value="dirStrings")
    @Property(surroundWithTag=false)
    @AbstractCollection(surroundWithTag=false, elementTag="dir", elementValueAttribute="")
    public List<String> dirStrings = new ArrayList<String>();

    public void loadState(FindInProjectSettingsBase state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        LinkedHashSet<String> tmp = new LinkedHashSet<String>(this.findStrings);
        this.findStrings.clear();
        this.findStrings.addAll(tmp);
        tmp.clear();
        tmp.addAll(this.replaceStrings);
        this.replaceStrings.clear();
        this.replaceStrings.addAll(tmp);
        tmp.clear();
        tmp.addAll(this.dirStrings);
        this.dirStrings.clear();
        this.dirStrings.addAll(tmp);
    }

    public FindInProjectSettingsBase getState() {
        return this;
    }

    public void addDirectory(@NotNull String s) {
        if (s.isEmpty()) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.dirStrings);
    }

    @NotNull
    public List<String> getRecentDirectories() {
        return new ArrayList<String>(this.dirStrings);
    }

    public void addStringToFind(@NotNull String s) {
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.findStrings);
    }

    public void addStringToReplace(@NotNull String s) {
        if (s.indexOf(13) >= 0 || s.indexOf(10) >= 0) {
            return;
        }
        FindInProjectSettingsBase.addRecentStringToList(s, this.replaceStrings);
    }

    @NotNull
    public String[] getRecentFindStrings() {
        return ArrayUtil.toStringArray(this.findStrings);
    }

    @NotNull
    public String[] getRecentReplaceStrings() {
        return ArrayUtil.toStringArray(this.replaceStrings);
    }

    static void addRecentStringToList(@NotNull String str, @NotNull List<String> list) {
        if (list.contains(str)) {
            list.remove(str);
        }
        list.add(str);
        while (list.size() > 30) {
            list.remove(0);
        }
    }

    static class FindInProjectPathMacroFilter
    extends PathMacroFilter {
        FindInProjectPathMacroFilter() {
        }

        public boolean skipPathMacros(@NotNull Element element) {
            String tag = element.getName();
            if (tag.equals("findStrings") || tag.equals("replaceStrings")) {
                String component = FileStorageCoreUtil.findComponentName(element);
                return component != null && (component.equals("FindSettings") || component.equals("FindInProjectRecents"));
            }
            return false;
        }
    }
}

