/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.AlignmentImpl;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingModelBuilder;
import com.intellij.formatting.FormattingModelBuilderEx;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentData;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreFormatterUtil {
    private CoreFormatterUtil() {
    }

    @NotNull
    public static FormattingModel buildModel(@NotNull FormattingModelBuilder builder, @NotNull PsiElement element, @NotNull CodeStyleSettings settings, @NotNull FormattingMode mode) {
        if (builder instanceof FormattingModelBuilderEx) {
            return ((FormattingModelBuilderEx)builder).createModel(element, settings, mode);
        }
        return builder.createModel(element, settings);
    }

    @Nullable
    public static AlignmentImpl getAlignment(@NotNull AbstractBlockWrapper block) {
        AlignmentImpl alignment;
        AbstractBlockWrapper current = block;
        while ((alignment = current.getAlignment()) == null || alignment.getOffsetRespBlockBefore(block) == null) {
            if ((current = current.getParent()) != null && current.getStartOffset() == block.getStartOffset()) continue;
            return null;
        }
        return alignment;
    }

    public static int getStartColumn(@Nullable LeafBlockWrapper block) {
        if (block != null) {
            int result2 = 0;
            do {
                WhiteSpace whiteSpace = block.getWhiteSpace();
                result2 += whiteSpace.getTotalSpaces();
                if (whiteSpace.containsLineFeeds()) {
                    return result2;
                }
                block = block.getPreviousBlock();
                if (result2 > 1000 || block == null) {
                    return result2;
                }
                result2 += block.getSymbolsAtTheLastLine();
            } while (!block.containsLineFeeds());
            return result2;
        }
        return -1;
    }

    @Nullable
    public static AbstractBlockWrapper getIndentedParentBlock(@NotNull AbstractBlockWrapper block) {
        for (CompositeBlockWrapper current = block.getParent(); current != null; current = current.getParent()) {
            AbstractBlockWrapper prevIndented;
            if (current.getStartOffset() != block.getStartOffset() && current.getWhiteSpace().containsLineFeeds()) {
                return current;
            }
            if (current.getParent() == null || (prevIndented = current.getParent().getPrevIndentedSibling(current)) == null) continue;
            return prevIndented;
        }
        return null;
    }

    public static boolean allowBackwardAlignment(@NotNull LeafBlockWrapper first, @NotNull LeafBlockWrapper second, @NotNull Map<AbstractBlockWrapper, Set<AbstractBlockWrapper>> alignmentMappings) {
        HashSet<AbstractBlockWrapper> blocksBeforeCurrent = new HashSet<AbstractBlockWrapper>();
        for (LeafBlockWrapper previousBlock = second.getPreviousBlock(); previousBlock != null; previousBlock = previousBlock.getPreviousBlock()) {
            Set<AbstractBlockWrapper> blocks = alignmentMappings.get(previousBlock);
            if (blocks != null) {
                blocksBeforeCurrent.addAll(blocks);
            }
            if (previousBlock.getWhiteSpace().containsLineFeeds()) break;
        }
        for (LeafBlockWrapper next = first.getNextBlock(); next != null && !next.getWhiteSpace().containsLineFeeds(); next = next.getNextBlock()) {
            if (!blocksBeforeCurrent.contains(next)) continue;
            return false;
        }
        return true;
    }

    public static IndentData getIndent(CommonCodeStyleSettings.IndentOptions options, AbstractBlockWrapper block, int tokenBlockStartOffset) {
        IndentImpl indent = block.getIndent();
        if (indent.getType() == Indent.Type.CONTINUATION) {
            return new IndentData(options.CONTINUATION_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.CONTINUATION_WITHOUT_FIRST) {
            if (block.getStartOffset() != block.getParent().getStartOffset() && block.getStartOffset() == tokenBlockStartOffset) {
                return new IndentData(options.CONTINUATION_INDENT_SIZE);
            }
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.LABEL) {
            return new IndentData(options.LABEL_INDENT_SIZE);
        }
        if (indent.getType() == Indent.Type.NONE) {
            return new IndentData(0);
        }
        if (indent.getType() == Indent.Type.SPACES) {
            return new IndentData(indent.getSpaces(), 0);
        }
        return new IndentData(options.INDENT_SIZE);
    }

    @NotNull
    public static LeafBlockWrapper getFirstLeaf(@NotNull AbstractBlockWrapper block) {
        if (block instanceof LeafBlockWrapper) {
            return (LeafBlockWrapper)block;
        }
        return CoreFormatterUtil.getFirstLeaf(((CompositeBlockWrapper)block).getChildren().get(0));
    }
}

