/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.AdjustFormatRangesState;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.FormatTextRanges;
import com.intellij.formatting.FormattingDocumentModel;
import com.intellij.formatting.FormattingModel;
import com.intellij.formatting.FormattingProgressCallback;
import com.intellij.formatting.IndentInfo;
import com.intellij.formatting.InitialInfoBuilder;
import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.WhiteSpace;
import com.intellij.formatting.engine.AdjustWhiteSpacesState;
import com.intellij.formatting.engine.ApplyChangesState;
import com.intellij.formatting.engine.BlockIndentOptions;
import com.intellij.formatting.engine.BlockRangesMap;
import com.intellij.formatting.engine.ExpandChildrenIndentState;
import com.intellij.formatting.engine.IndentAdjuster;
import com.intellij.formatting.engine.StateProcessor;
import com.intellij.formatting.engine.WrapBlocksState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.formatting.FormatProcessor");
    private final WrapBlocksState myWrapState;
    private boolean myReformatContext;
    private final Document myDocument;
    @NotNull
    private final FormattingProgressCallback myProgressCallback;
    @NotNull
    private StateProcessor myStateProcessor;

    public FormatProcessor(FormattingDocumentModel docModel, Block rootBlock, CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions indentOptions, @Nullable FormatTextRanges affectedRanges, @NotNull FormattingProgressCallback progressCallback) {
        this(docModel, rootBlock, new FormatOptions(settings, indentOptions, affectedRanges, false), progressCallback);
    }

    public FormatProcessor(FormattingDocumentModel model, Block block, FormatOptions options, @NotNull FormattingProgressCallback callback) {
        this.myProgressCallback = callback;
        CommonCodeStyleSettings.IndentOptions defaultIndentOption = options.myIndentOptions;
        CodeStyleSettings settings = options.mySettings;
        BlockIndentOptions blockIndentOptions = new BlockIndentOptions(settings, defaultIndentOption, block);
        this.myDocument = model.getDocument();
        this.myReformatContext = options.myReformatContext;
        InitialInfoBuilder builder = InitialInfoBuilder.prepareToBuildBlocksSequentially(block, model, options, settings, defaultIndentOption, this.myProgressCallback);
        this.myWrapState = new WrapBlocksState(builder, blockIndentOptions);
        FormatTextRanges ranges = options.myAffectedRanges;
        if (ranges != null && this.myReformatContext) {
            AdjustFormatRangesState adjustRangesState = new AdjustFormatRangesState(block, ranges);
            this.myStateProcessor = new StateProcessor(adjustRangesState);
            this.myStateProcessor.setNextState(this.myWrapState);
        } else {
            this.myStateProcessor = new StateProcessor(this.myWrapState);
        }
    }

    public BlockRangesMap getBlockRangesMap() {
        return this.myWrapState.getBlockRangesMap();
    }

    public void format(FormattingModel model) {
        this.format(model, false);
    }

    public void format(FormattingModel model, boolean sequentially) {
        if (sequentially) {
            this.myStateProcessor.setNextState(new AdjustWhiteSpacesState(this.myWrapState, this.myProgressCallback, this.myReformatContext));
            this.myStateProcessor.setNextState(new ExpandChildrenIndentState(this.myDocument, this.myWrapState));
            this.myStateProcessor.setNextState(new ApplyChangesState(model, this.myWrapState, this.myProgressCallback));
        } else {
            this.formatWithoutRealModifications(false);
            this.performModifications(model, false);
        }
    }

    public boolean iteration() {
        if (this.myStateProcessor.isDone()) {
            return true;
        }
        this.myStateProcessor.iteration();
        return this.myStateProcessor.isDone();
    }

    public void stopSequentialProcessing() {
        this.myStateProcessor.stop();
    }

    public void formatWithoutRealModifications() {
        this.formatWithoutRealModifications(false);
    }

    public void formatWithoutRealModifications(boolean sequentially) {
        this.myStateProcessor.setNextState(new AdjustWhiteSpacesState(this.myWrapState, this.myProgressCallback, this.myReformatContext));
        this.myStateProcessor.setNextState(new ExpandChildrenIndentState(this.myDocument, this.myWrapState));
        if (sequentially) {
            return;
        }
        this.doIterationsSynchronously();
    }

    public void performModifications(FormattingModel model) {
        this.performModifications(model, false);
    }

    public void performModifications(FormattingModel model, boolean sequentially) {
        this.myStateProcessor.setNextState(new ApplyChangesState(model, this.myWrapState, this.myProgressCallback));
        if (sequentially) {
            return;
        }
        this.doIterationsSynchronously();
    }

    private void doIterationsSynchronously() {
        while (!this.myStateProcessor.isDone()) {
            this.myStateProcessor.iteration();
        }
    }

    public void setAllWhiteSpacesAreReadOnly() {
        for (LeafBlockWrapper current = this.myWrapState.getFirstBlock(); current != null; current = current.getNextBlock()) {
            current.getWhiteSpace().setReadOnly(true);
        }
    }

    public IndentInfo getIndentAt(int offset) {
        LeafBlockWrapper current = this.processBlocksBefore(offset);
        AbstractBlockWrapper parent = this.getParentFor(offset, current);
        if (parent == null) {
            LeafBlockWrapper previousBlock = current.getPreviousBlock();
            if (previousBlock != null) {
                parent = this.getParentFor(offset, previousBlock);
            }
            if (parent == null) {
                return new IndentInfo(0, 0, 0);
            }
        }
        int index = FormatProcessor.getNewChildPosition(parent, offset);
        Block block = this.myWrapState.getBlockToInfoMap().get(parent);
        if (block == null) {
            return new IndentInfo(0, 0, 0);
        }
        ChildAttributesInfo info = FormatProcessor.getChildAttributesInfo(block, index, parent);
        if (info == null) {
            return new IndentInfo(0, 0, 0);
        }
        IndentAdjuster adjuster = this.myWrapState.getIndentAdjuster();
        return adjuster.adjustLineIndent(current, info);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static ChildAttributesInfo getChildAttributesInfo(@NotNull Block block, int index, @Nullable AbstractBlockWrapper parent) {
        void var4_7;
        if (parent == null) {
            return null;
        }
        ChildAttributes childAttributes = block.getChildAttributes(index);
        if (childAttributes == ChildAttributes.DELEGATE_TO_PREV_CHILD) {
            void var5_10;
            Block block2 = (Block)block.getSubBlocks().get(index - 1);
            if (parent instanceof CompositeBlockWrapper) {
                AbstractBlockWrapper abstractBlockWrapper = ((CompositeBlockWrapper)parent).getChildren().get(index - 1);
                return FormatProcessor.getChildAttributesInfo(block2, block2.getSubBlocks().size(), (AbstractBlockWrapper)var5_10);
            } else {
                LeafBlockWrapper leafBlockWrapper = parent.getPreviousBlock();
            }
            return FormatProcessor.getChildAttributesInfo(block2, block2.getSubBlocks().size(), (AbstractBlockWrapper)var5_10);
        }
        if (childAttributes != ChildAttributes.DELEGATE_TO_NEXT_CHILD) return new ChildAttributesInfo(parent, childAttributes, index);
        if (parent instanceof CompositeBlockWrapper) {
            List<AbstractBlockWrapper> list = ((CompositeBlockWrapper)parent).getChildren();
            if (list == null || index >= list.size()) return null;
            AbstractBlockWrapper abstractBlockWrapper = list.get(index);
            return FormatProcessor.getChildAttributesInfo((Block)block.getSubBlocks().get(index), 0, (AbstractBlockWrapper)var4_7);
        } else {
            LeafBlockWrapper leafBlockWrapper = ((LeafBlockWrapper)parent).getNextBlock();
        }
        return FormatProcessor.getChildAttributesInfo((Block)block.getSubBlocks().get(index), 0, (AbstractBlockWrapper)var4_7);
    }

    private static int getNewChildPosition(AbstractBlockWrapper parent, int offset) {
        AbstractBlockWrapper parentBlockToUse = FormatProcessor.getLastNestedCompositeBlockForSameRange(parent);
        if (!(parentBlockToUse instanceof CompositeBlockWrapper)) {
            return 0;
        }
        List<AbstractBlockWrapper> subBlocks = ((CompositeBlockWrapper)parentBlockToUse).getChildren();
        if (subBlocks != null) {
            for (int i = 0; i < subBlocks.size(); ++i) {
                AbstractBlockWrapper block = subBlocks.get(i);
                if (block.getStartOffset() < offset) continue;
                return i;
            }
            return subBlocks.size();
        }
        return 0;
    }

    @Nullable
    private static AbstractBlockWrapper getParentFor(int offset, AbstractBlockWrapper block) {
        for (AbstractBlockWrapper current = block; current != null; current = current.getParent()) {
            if (current.getStartOffset() >= offset || current.getEndOffset() < offset) continue;
            return current;
        }
        return null;
    }

    @Nullable
    private AbstractBlockWrapper getParentFor(int offset, LeafBlockWrapper block) {
        AbstractBlockWrapper previous = this.getPreviousIncompleteBlock(block, offset);
        if (previous != null) {
            return FormatProcessor.getLastNestedCompositeBlockForSameRange(previous);
        }
        return FormatProcessor.getParentFor(offset, block);
    }

    @Nullable
    private AbstractBlockWrapper getPreviousIncompleteBlock(LeafBlockWrapper block, int offset) {
        if (block == null) {
            LeafBlockWrapper lastTokenBlock = this.myWrapState.getLastBlock();
            if (lastTokenBlock.isIncomplete()) {
                return lastTokenBlock;
            }
            return null;
        }
        AbstractBlockWrapper current = block;
        while (current.getParent() != null && current.getParent().getStartOffset() > offset) {
            current = current.getParent();
        }
        if (current.getParent() == null) {
            return null;
        }
        if (current.getEndOffset() <= offset) {
            while (!current.isIncomplete() && current.getParent() != null && current.getParent().getEndOffset() <= offset) {
                current = current.getParent();
            }
            if (current.isIncomplete()) {
                return current;
            }
        }
        if (current.getParent() == null) {
            return null;
        }
        List<AbstractBlockWrapper> subBlocks = current.getParent().getChildren();
        int index = subBlocks.indexOf(current);
        if (index < 0) {
            LOG.assertTrue(false);
        }
        if (index == 0) {
            return null;
        }
        AbstractBlockWrapper currentResult = subBlocks.get(index - 1);
        if (!currentResult.isIncomplete()) {
            return null;
        }
        AbstractBlockWrapper lastChild = FormatProcessor.getLastChildOf(currentResult);
        while (lastChild != null && lastChild.isIncomplete()) {
            currentResult = lastChild;
            lastChild = FormatProcessor.getLastChildOf(currentResult);
        }
        return currentResult;
    }

    @Nullable
    private static AbstractBlockWrapper getLastChildOf(AbstractBlockWrapper currentResult) {
        AbstractBlockWrapper parentBlockToUse = FormatProcessor.getLastNestedCompositeBlockForSameRange(currentResult);
        if (!(parentBlockToUse instanceof CompositeBlockWrapper)) {
            return null;
        }
        List<AbstractBlockWrapper> subBlocks = ((CompositeBlockWrapper)parentBlockToUse).getChildren();
        if (subBlocks.isEmpty()) {
            return null;
        }
        return subBlocks.get(subBlocks.size() - 1);
    }

    @NotNull
    private static AbstractBlockWrapper getLastNestedCompositeBlockForSameRange(@NotNull AbstractBlockWrapper block) {
        List<AbstractBlockWrapper> subBlocks;
        if (!(block instanceof CompositeBlockWrapper)) {
            return block;
        }
        AbstractBlockWrapper result2 = block;
        AbstractBlockWrapper candidate = block;
        while ((subBlocks = ((CompositeBlockWrapper)candidate).getChildren()) != null && subBlocks.size() == 1 && (candidate = subBlocks.get(0)).getStartOffset() == block.getStartOffset() && candidate.getEndOffset() == block.getEndOffset() && candidate instanceof CompositeBlockWrapper) {
            result2 = candidate;
        }
        return result2;
    }

    private LeafBlockWrapper processBlocksBefore(int offset) {
        AdjustWhiteSpacesState state = new AdjustWhiteSpacesState(this.myWrapState, this.myProgressCallback, this.myReformatContext);
        state.prepare();
        LeafBlockWrapper last = null;
        while (!state.isDone() && state.getCurrentBlock().getStartOffset() < offset) {
            last = state.getCurrentBlock();
            state.doIteration();
        }
        return state.getCurrentBlock() != null ? state.getCurrentBlock() : last;
    }

    public LeafBlockWrapper getFirstTokenBlock() {
        return this.myWrapState.getFirstBlock();
    }

    public WhiteSpace getLastWhiteSpace() {
        return this.myWrapState.getLastWhiteSpace();
    }

    public static class FormatOptions {
        public CodeStyleSettings mySettings;
        public CommonCodeStyleSettings.IndentOptions myIndentOptions;
        public FormatTextRanges myAffectedRanges;
        public boolean myReformatContext;
        public int myInterestingOffset;

        public FormatOptions(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, FormatTextRanges ranges, boolean reformatContext) {
            this(settings, options, ranges, reformatContext, -1);
        }

        public FormatOptions(CodeStyleSettings settings, CommonCodeStyleSettings.IndentOptions options, FormatTextRanges ranges, boolean reformatContext, int interestingOffset) {
            this.mySettings = settings;
            this.myIndentOptions = options;
            this.myAffectedRanges = ranges;
            this.myReformatContext = reformatContext;
            this.myInterestingOffset = interestingOffset;
        }
    }

    public static class ChildAttributesInfo {
        public final AbstractBlockWrapper parent;
        public final ChildAttributes attributes;
        public final int index;

        public ChildAttributesInfo(AbstractBlockWrapper parent, ChildAttributes attributes, int index) {
            this.parent = parent;
            this.attributes = attributes;
            this.index = index;
        }
    }
}

