/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;

public class FormatTextRange {
    @NotNull
    private TextRange formattingRange;
    private final boolean processHeadingWhitespace;

    public FormatTextRange(@NotNull TextRange range, boolean processHeadingSpace) {
        this.formattingRange = range;
        this.processHeadingWhitespace = processHeadingSpace;
    }

    public boolean isProcessHeadingWhitespace() {
        return this.processHeadingWhitespace;
    }

    public boolean isWhitespaceReadOnly(@NotNull TextRange range) {
        if (range.getStartOffset() >= this.formattingRange.getEndOffset()) {
            return true;
        }
        if (this.processHeadingWhitespace && range.getEndOffset() == this.formattingRange.getStartOffset()) {
            return false;
        }
        return range.getEndOffset() <= this.formattingRange.getStartOffset();
    }

    public int getStartOffset() {
        return this.formattingRange.getStartOffset();
    }

    public boolean isReadOnly(@NotNull TextRange range) {
        return range.getStartOffset() > this.formattingRange.getEndOffset() || range.getEndOffset() < this.formattingRange.getStartOffset();
    }

    @NotNull
    public TextRange getTextRange() {
        return this.formattingRange;
    }

    public void setTextRange(@NotNull TextRange range) {
        this.formattingRange = range;
    }

    public TextRange getNonEmptyTextRange() {
        int endOffset = this.formattingRange.getStartOffset() == this.formattingRange.getEndOffset() ? this.formattingRange.getEndOffset() + 1 : this.formattingRange.getEndOffset();
        return new TextRange(this.formattingRange.getStartOffset(), endOffset);
    }

    public String toString() {
        return this.formattingRange.toString() + (this.processHeadingWhitespace ? "+" : "");
    }
}

