/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class FormatterTestUtils {
    public static final Map<Action, TestFormatAction> ACTIONS = new EnumMap<Action, TestFormatAction>(Action.class);

    public static void testFormatting(@NotNull Project project2, @NotNull String ext, @NotNull String before, @NotNull String after2, @NotNull Action action) {
        String fileName = "FTU." + ext;
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(fileName);
        FormatData data = FormatterTestUtils.extractFormatData(before);
        PsiFile file2 = PsiFileFactory.getInstance((Project)project2).createFileFromText(fileName, fileType, (CharSequence)data.text, System.currentTimeMillis(), true);
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project2);
        Document document = manager.getDocument(file2);
        if (document == null) {
            throw new IllegalStateException("Document is null");
        }
        TestFormatAction formatAction = ACTIONS.get((Object)action);
        if (formatAction == null) {
            throw new IllegalStateException("Format action is null");
        }
        WriteCommandAction.runWriteCommandAction((Project)project2, () -> formatAction.run(file2, data.startOffset, data.endOffset));
        Assert.assertEquals((Object)after2, (Object)document.getText());
    }

    private static FormatData extractFormatData(@NotNull String before) {
        String SELECTION_START = "<selection>";
        String SELECTION_END = "<selection/>";
        int startOffset = before.indexOf("<selection>");
        if (startOffset > 0) {
            int endOffset = before.indexOf("<selection/>") - "<selection>".length();
            String text = before.replace("<selection>", "").replace("<selection/>", "");
            return new FormatData(text, startOffset, endOffset);
        }
        return new FormatData(before, 0, before.length());
    }

    static {
        ACTIONS.put(Action.REFORMAT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatText(psiFile, startOffset, endOffset);
            }
        });
        ACTIONS.put(Action.INDENT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).adjustLineIndent(psiFile, startOffset);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                ArrayList ranges = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(startOffset, endOffset)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, (Collection)ranges);
            }
        });
        ACTIONS.put(Action.REFORMAT_WITH_INSERTED_LINE_CONTEXT, new TestFormatAction(){

            @Override
            public void run(PsiFile psiFile, int startOffset, int endOffset) {
                ArrayList ranges = ContainerUtil.newArrayList((Object[])new TextRange[]{new TextRange(startOffset, endOffset)});
                Project project2 = psiFile.getProject();
                CodeStyleManager.getInstance((Project)project2).reformatTextWithContext(psiFile, new ChangedRangesInfo((List)ranges, (List)ranges));
            }
        });
    }

    public static class FormatData {
        public int startOffset;
        public int endOffset;
        public String text;

        public FormatData(String text, int startOffset, int endOffset) {
            this.text = text;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }
    }

    public static enum Action {
        REFORMAT,
        INDENT,
        REFORMAT_WITH_CONTEXT,
        REFORMAT_WITH_INSERTED_LINE_CONTEXT;

    }

    public static interface TestFormatAction {
        public void run(PsiFile var1, int var2, int var3);
    }
}

