/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.AbstractBlockWrapper;
import com.intellij.formatting.Block;
import com.intellij.formatting.CompositeBlockWrapper;
import com.intellij.formatting.Indent;
import com.intellij.formatting.IndentImpl;
import com.intellij.formatting.WrapImpl;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InitialInfoBuilderState {
    public final Block parentBlock;
    public final WrapImpl parentBlockWrap;
    public final CompositeBlockWrapper wrappedBlock;
    public final boolean readOnly;
    public Block previousBlock;
    private final List<AbstractBlockWrapper> myWrappedChildren = ContainerUtil.newArrayList();

    InitialInfoBuilderState(@NotNull Block parentBlock, @NotNull CompositeBlockWrapper wrappedBlock, @Nullable WrapImpl parentBlockWrap, boolean readOnly) {
        this.parentBlock = parentBlock;
        this.wrappedBlock = wrappedBlock;
        this.parentBlockWrap = parentBlockWrap;
        this.readOnly = readOnly;
    }

    public int getIndexOfChildBlockToProcess() {
        return this.myWrappedChildren.size();
    }

    public boolean childBlockProcessed(@NotNull Block child, @NotNull AbstractBlockWrapper wrappedChild, CommonCodeStyleSettings.IndentOptions options) {
        this.myWrappedChildren.add(wrappedChild);
        this.previousBlock = child;
        int subBlocksNumber = this.parentBlock.getSubBlocks().size();
        if (this.myWrappedChildren.size() > subBlocksNumber) {
            return true;
        }
        if (this.myWrappedChildren.size() == subBlocksNumber) {
            InitialInfoBuilderState.setDefaultIndents(this.myWrappedChildren, options.USE_RELATIVE_INDENTS);
            this.wrappedBlock.setChildren(this.myWrappedChildren);
            return true;
        }
        return false;
    }

    public boolean isProcessed() {
        return this.myWrappedChildren.size() == this.parentBlock.getSubBlocks().size();
    }

    private static void setDefaultIndents(List<AbstractBlockWrapper> list, boolean useRelativeIndents) {
        for (AbstractBlockWrapper wrapper : list) {
            if (wrapper.getIndent() != null) continue;
            wrapper.setIndent((IndentImpl)Indent.getContinuationWithoutFirstIndent((boolean)useRelativeIndents));
        }
    }
}

