/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.contextConfiguration;

import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.OptionTreeWithPreviewPanel;
import com.intellij.application.options.codeStyle.WrappingAndBracesPanel;
import com.intellij.formatting.contextConfiguration.SelectedTextFormatter;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCodeFragmentFilter;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CodeFragmentCodeStyleSettingsPanel
extends TabbedLanguageCodeStylePanel {
    private static final Logger LOG = Logger.getInstance(CodeFragmentCodeStyleSettingsPanel.class);
    private final CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow mySettingsToShow;
    private final SelectedTextFormatter mySelectedTextFormatter;
    private SpacesPanelWithoutPreview mySpacesPanel;
    private WrappingAndBracesPanelWithoutPreview myWrappingPanel;
    private Runnable mySomethingChangedCallback;

    public CodeFragmentCodeStyleSettingsPanel(@NotNull CodeStyleSettings settings, @NotNull CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow settingsToShow, @NotNull Language language, @NotNull SelectedTextFormatter selectedTextFormatter) {
        super(language, settings, settings.clone());
        this.mySettingsToShow = settingsToShow;
        this.mySelectedTextFormatter = selectedTextFormatter;
        this.ensureTabs();
    }

    public void setOnSomethingChangedCallback(Runnable runnable2) {
        this.mySomethingChangedCallback = runnable2;
    }

    @Override
    protected void somethingChanged() {
        if (this.mySomethingChangedCallback != null) {
            this.mySomethingChangedCallback.run();
        }
    }

    @Override
    protected String getPreviewText() {
        return null;
    }

    @Override
    protected void updatePreview(boolean useDefaultSample) {
    }

    @Override
    protected void initTabs(CodeStyleSettings settings) {
        SpacesPanelWithoutPreview panel2 = this.getSpacesPanel(settings);
        if (panel2 != null) {
            this.mySpacesPanel = panel2;
            this.addTab(this.mySpacesPanel);
        }
        this.myWrappingPanel = new WrappingAndBracesPanelWithoutPreview(settings);
        this.addTab(this.myWrappingPanel);
        this.reset(this.getSettings());
    }

    @Nullable
    private SpacesPanelWithoutPreview getSpacesPanel(CodeStyleSettings settings) {
        SpacesPanelWithoutPreview spacesPanel = new SpacesPanelWithoutPreview(settings);
        if (spacesPanel.hasSomethingToShow()) {
            return spacesPanel;
        }
        Disposer.dispose((Disposable)spacesPanel);
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.mySpacesPanel != null ? this.mySpacesPanel.getPreferredFocusedComponent() : this.myWrappingPanel.getPreferredFocusedComponent();
    }

    public static CodeStyleSettingsCodeFragmentFilter.CodeStyleSettingsToShow calcSettingNamesToShow(CodeStyleSettingsCodeFragmentFilter filter) {
        return filter.getFieldNamesAffectingCodeFragment(LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS, LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS);
    }

    public static boolean hasOptionsToShow(LanguageCodeStyleSettingsProvider provider2) {
        LanguageCodeStyleSettingsProvider.SettingsType[] types;
        for (LanguageCodeStyleSettingsProvider.SettingsType type2 : types = new LanguageCodeStyleSettingsProvider.SettingsType[]{LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS, LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS}) {
            if (provider2.getSupportedFields(type2).isEmpty()) continue;
            return true;
        }
        return !provider2.getSupportedFields().isEmpty();
    }

    private void reformatSelectedTextWithNewSettings() {
        try {
            this.apply(this.getSettings());
        }
        catch (ConfigurationException e) {
            LOG.debug("Cannot apply code style settings", (Throwable)e);
        }
        CodeStyleSettings clonedSettings = this.getSettings().clone();
        this.mySelectedTextFormatter.reformatSelectedText(clonedSettings);
    }

    private class WrappingAndBracesPanelWithoutPreview
    extends TabbedLanguageCodeStylePanel.MyWrappingAndBracesPanel {
        public JPanel myPanel;

        public WrappingAndBracesPanelWithoutPreview(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected void init() {
            List<String> settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getSettings(this.getSettingsType());
            if (settingNames.isEmpty()) {
                settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getOtherSetting();
            }
            this.initTables();
            Collection<String> fields = this.populateWithAssociatedFields(settingNames);
            fields.add("KEEP_LINE_BREAKS");
            String[] names = (String[])ContainerUtil.toArray(fields, (Object[])new String[fields.size()]);
            this.showStandardOptions(names);
            this.myTreeTable = this.createOptionsTree(this.getSettings());
            JBScrollPane scrollPane = new JBScrollPane((Component)this.myTreeTable){

                public Dimension getMinimumSize() {
                    return WrappingAndBracesPanelWithoutPreview.this.myTreeTable.getPreferredSize();
                }
            };
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)scrollPane);
            this.showStandardOptions(names);
            this.isFirstUpdate = false;
        }

        @NotNull
        private Collection<String> populateWithAssociatedFields(Collection<String> settingNames) {
            HashSet commonFields = ContainerUtil.newHashSet();
            for (String fieldName : settingNames) {
                WrappingAndBracesPanel.SettingsGroup settingsGroup = this.getAssociatedSettingsGroup(fieldName);
                if (settingsGroup == null) {
                    commonFields.add(fieldName);
                    continue;
                }
                if (settingsGroup.title == WRAPPING_KEEP) continue;
                commonFields.addAll(settingsGroup.commonCodeStyleSettingFieldNames);
            }
            return commonFields;
        }

        @Override
        public JComponent getPanel() {
            return this.myPanel;
        }

        @Override
        protected void somethingChanged() {
            CodeFragmentCodeStyleSettingsPanel.this.mySelectedTextFormatter.restoreSelectedText();
            CodeFragmentCodeStyleSettingsPanel.this.reformatSelectedTextWithNewSettings();
            CodeFragmentCodeStyleSettingsPanel.this.somethingChanged();
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myTreeTable;
        }
    }

    private class SpacesPanelWithoutPreview
    extends TabbedLanguageCodeStylePanel.MySpacesPanel {
        private JPanel myPanel;

        public SpacesPanelWithoutPreview(CodeStyleSettings settings) {
            super(settings);
        }

        @Override
        protected void somethingChanged() {
            CodeFragmentCodeStyleSettingsPanel.this.mySelectedTextFormatter.restoreSelectedText();
            CodeFragmentCodeStyleSettingsPanel.this.reformatSelectedTextWithNewSettings();
            CodeFragmentCodeStyleSettingsPanel.this.somethingChanged();
        }

        @Override
        protected void init() {
            List<String> settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getSettings(this.getSettingsType());
            if (settingNames.isEmpty()) {
                settingNames = CodeFragmentCodeStyleSettingsPanel.this.mySettingsToShow.getOtherSetting();
            }
            String[] names = (String[])ContainerUtil.toArray(settingNames, (Object[])new String[settingNames.size()]);
            this.showStandardOptions(names);
            this.initTables();
            this.myOptionsTree = this.createOptionsTree();
            this.myOptionsTree.setCellRenderer(new OptionTreeWithPreviewPanel.MyTreeCellRenderer());
            JBScrollPane pane = new JBScrollPane(this.myOptionsTree){

                public Dimension getMinimumSize() {
                    return super.getPreferredSize();
                }
            };
            this.myPanel = new JPanel(new BorderLayout());
            this.myPanel.add((Component)pane);
            this.isFirstUpdate = false;
        }

        public boolean hasSomethingToShow() {
            return !this.myKeys.isEmpty();
        }

        @Override
        public JComponent getPanel() {
            return this.myPanel;
        }

        @Override
        protected String getPreviewText() {
            return null;
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myOptionsTree;
        }
    }
}

