/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting.engine;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.TextChange;
import com.intellij.openapi.editor.impl.BulkChangesMerger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CaretOffsetUpdater {
    private final Map<Editor, Integer> myCaretOffsets = new HashMap<Editor, Integer>();

    public CaretOffsetUpdater(@NotNull Document document) {
        Editor[] editors;
        for (Editor editor : editors = EditorFactory.getInstance().getEditors(document)) {
            this.myCaretOffsets.put(editor, editor.getCaretModel().getOffset());
        }
    }

    public void update(@NotNull List<? extends TextChange> changes) {
        BulkChangesMerger merger = BulkChangesMerger.INSTANCE;
        for (Map.Entry<Editor, Integer> entry : this.myCaretOffsets.entrySet()) {
            entry.setValue(merger.updateOffset(entry.getValue(), changes));
        }
    }

    public void restoreCaretLocations() {
        for (Map.Entry<Editor, Integer> entry : this.myCaretOffsets.entrySet()) {
            entry.getKey().getCaretModel().moveToOffset(entry.getValue().intValue());
        }
    }
}

