/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl;

import com.intellij.framework.detection.DetectedFrameworkDescription;
import com.intellij.framework.detection.FrameworkDetectionContext;
import com.intellij.framework.detection.FrameworkDetector;
import com.intellij.framework.detection.impl.FrameworkDetectionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.patterns.ElementPattern;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class FrameworkDetectionProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.framework.detection.impl.FrameworkDetectionProcessor");
    private final ProgressIndicator myProgressIndicator;
    private final MultiMap<FileType, FrameworkDetectorData> myDetectorsByFileType;
    private Set<VirtualFile> myProcessedFiles;
    private final FrameworkDetectionContext myContext;

    public FrameworkDetectionProcessor(ProgressIndicator progressIndicator, FrameworkDetectionContext context) {
        this.myProgressIndicator = progressIndicator;
        FrameworkDetector[] detectors = (FrameworkDetector[])FrameworkDetector.EP_NAME.getExtensions();
        this.myDetectorsByFileType = new MultiMap();
        for (FrameworkDetector detector : detectors) {
            this.myDetectorsByFileType.putValue((Object)detector.getFileType(), (Object)new FrameworkDetectorData(detector));
        }
        this.myContext = context;
    }

    public List<? extends DetectedFrameworkDescription> processRoots(List<File> roots) {
        this.myProcessedFiles = new HashSet<VirtualFile>();
        for (File root : roots) {
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(root);
            if (virtualFile == null) continue;
            this.collectSuitableFiles(virtualFile);
        }
        ArrayList<DetectedFrameworkDescription> result2 = new ArrayList<DetectedFrameworkDescription>();
        for (FrameworkDetectorData data : this.myDetectorsByFileType.values()) {
            result2.addAll(data.myDetector.detect((Collection)data.mySuitableFiles, this.myContext));
        }
        return FrameworkDetectionUtil.removeDisabled(result2);
    }

    private void collectSuitableFiles(@NotNull VirtualFile file2) {
        try {
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    FrameworkDetectionProcessor.this.myProgressIndicator.checkCanceled();
                    return true;
                }
            });
            file2.refresh(false, true);
            VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file2) {
                    FrameworkDetectionProcessor.this.myProgressIndicator.checkCanceled();
                    if (!FrameworkDetectionProcessor.this.myProcessedFiles.add(file2)) {
                        return false;
                    }
                    if (!file2.isDirectory()) {
                        FileType fileType = file2.getFileType();
                        if (FrameworkDetectionProcessor.this.myDetectorsByFileType.containsKey((Object)fileType)) {
                            FrameworkDetectionProcessor.this.myProgressIndicator.setText2(file2.getPresentableUrl());
                            try {
                                FileContentImpl fileContent = new FileContentImpl(file2, file2.contentsToByteArray(false));
                                for (FrameworkDetectorData detector : FrameworkDetectionProcessor.this.myDetectorsByFileType.get((Object)fileType)) {
                                    if (!detector.myFilePattern.accepts((Object)fileContent)) continue;
                                    detector.mySuitableFiles.add(file2);
                                }
                            }
                            catch (IOException e) {
                                LOG.info((Throwable)e);
                            }
                        }
                    }
                    return true;
                }
            });
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private static class FrameworkDetectorData {
        private final FrameworkDetector myDetector;
        private final ElementPattern<FileContent> myFilePattern;
        private final List<VirtualFile> mySuitableFiles = new ArrayList<VirtualFile>();

        public FrameworkDetectorData(FrameworkDetector detector) {
            this.myDetector = detector;
            this.myFilePattern = detector.createSuitableFilePattern();
        }
    }
}

