/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.detection.impl.exclude.old;

import com.intellij.framework.detection.impl.exclude.old.DisabledAutodetectionByTypeElement;
import com.intellij.util.containers.SortedList;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisabledAutodetectionInfo {
    private List<DisabledAutodetectionByTypeElement> myElements = new SortedList(DisabledAutodetectionByTypeElement.COMPARATOR);

    @Tag(value="autodetection-disabled")
    @AbstractCollection(surroundWithTag=false)
    public List<DisabledAutodetectionByTypeElement> getElements() {
        return this.myElements;
    }

    public void setElements(List<DisabledAutodetectionByTypeElement> elements) {
        this.myElements = elements;
    }

    public boolean isDisabled(@NotNull String facetType, @NotNull String moduleName, String url) {
        DisabledAutodetectionByTypeElement element = this.findElement(facetType);
        return element != null && element.isDisabled(moduleName, url);
    }

    public void replaceElement(@NotNull String facetTypeId, @Nullable DisabledAutodetectionByTypeElement element) {
        DisabledAutodetectionByTypeElement old = this.findElement(facetTypeId);
        if (old != null) {
            this.myElements.remove(old);
        }
        if (element != null) {
            this.myElements.add(element);
        }
    }

    @Nullable
    public DisabledAutodetectionByTypeElement findElement(@NotNull String facetTypeId) {
        for (DisabledAutodetectionByTypeElement element : this.myElements) {
            if (!facetTypeId.equals(element.getFacetTypeId())) continue;
            return element;
        }
        return null;
    }

    public void addDisabled(@NotNull String facetTypeId) {
        DisabledAutodetectionByTypeElement element = this.findElement(facetTypeId);
        if (element != null) {
            element.disableInProject();
        } else {
            this.myElements.add(new DisabledAutodetectionByTypeElement(facetTypeId));
        }
    }

    public void addDisabled(@NotNull String facetTypeId, @NotNull String moduleName) {
        DisabledAutodetectionByTypeElement element = this.findElement(facetTypeId);
        if (element != null) {
            element.addDisabled(moduleName);
        } else {
            this.myElements.add(new DisabledAutodetectionByTypeElement(facetTypeId, moduleName));
        }
    }

    public void addDisabled(@NotNull String facetTypeId, @NotNull String moduleName, String url, boolean recursively) {
        DisabledAutodetectionByTypeElement element = this.findElement(facetTypeId);
        if (element != null) {
            element.addDisabled(moduleName, url, recursively);
        } else {
            this.myElements.add(new DisabledAutodetectionByTypeElement(facetTypeId, moduleName, url, recursively));
        }
    }

    public void addDisabled(@NotNull String facetTypeId, @NotNull String moduleName, String ... urls) {
        for (String url : urls) {
            this.addDisabled(facetTypeId, moduleName, url, false);
        }
    }
}

