/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleConfigurable;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.DownloadableLibraryService;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.ide.util.frameworkSupport.FrameworkSupportModel;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.roots.ModifiableModelsProvider;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.libraries.CustomLibraryDescription;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LibraryBasedFrameworkSupportProvider
extends FrameworkSupportInModuleProvider {
    private final FrameworkTypeEx myFrameworkType;
    private final Class<? extends DownloadableLibraryType> myLibraryTypeClass;

    public LibraryBasedFrameworkSupportProvider(FrameworkTypeEx frameworkType, Class<? extends DownloadableLibraryType> libraryTypeClass) {
        this.myFrameworkType = frameworkType;
        this.myLibraryTypeClass = libraryTypeClass;
    }

    @Override
    @NotNull
    public FrameworkTypeEx getFrameworkType() {
        return this.myFrameworkType;
    }

    @Override
    @NotNull
    public FrameworkSupportInModuleConfigurable createConfigurable(@NotNull FrameworkSupportModel model) {
        return new LibrarySupportConfigurable();
    }

    @Override
    public boolean isEnabledForModuleType(@NotNull ModuleType moduleType) {
        return moduleType instanceof JavaModuleType;
    }

    private class LibrarySupportConfigurable
    extends FrameworkSupportInModuleConfigurable {
        private LibrarySupportConfigurable() {
        }

        @Override
        public JComponent createComponent() {
            return null;
        }

        @Override
        public void addSupport(@NotNull Module module2, @NotNull ModifiableRootModel rootModel, @NotNull ModifiableModelsProvider modifiableModelsProvider) {
        }

        @Override
        @NotNull
        public CustomLibraryDescription createLibraryDescription() {
            return DownloadableLibraryService.getInstance().createDescriptionForType(LibraryBasedFrameworkSupportProvider.this.myLibraryTypeClass);
        }

        @Override
        public boolean isOnlyLibraryAdded() {
            return true;
        }
    }
}

