/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.framework.library;

import com.intellij.framework.FrameworkTypeEx;
import com.intellij.framework.addSupport.FrameworkSupportInModuleProvider;
import com.intellij.framework.library.DownloadableLibraryType;
import com.intellij.framework.library.LibraryBasedFrameworkSupportProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.libraries.LibraryType;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class LibraryBasedFrameworkType
extends FrameworkTypeEx {
    private static final Logger LOG = Logger.getInstance(LibraryBasedFrameworkType.class);
    private final Class<? extends DownloadableLibraryType> myLibraryTypeClass;

    protected LibraryBasedFrameworkType(@NotNull String id, Class<? extends DownloadableLibraryType> libraryTypeClass) {
        super(id);
        this.myLibraryTypeClass = libraryTypeClass;
    }

    protected Class<? extends DownloadableLibraryType> getLibraryTypeClass() {
        return this.myLibraryTypeClass;
    }

    @Override
    @NotNull
    public FrameworkSupportInModuleProvider createProvider() {
        return new LibraryBasedFrameworkSupportProvider(this, this.myLibraryTypeClass);
    }

    @NotNull
    public Icon getIcon() {
        DownloadableLibraryType libraryType = this.getLibraryType();
        return libraryType.getIcon();
    }

    @NotNull
    public DownloadableLibraryType getLibraryType() {
        DownloadableLibraryType libraryType = (DownloadableLibraryType)LibraryType.EP_NAME.findExtension(this.myLibraryTypeClass);
        LOG.assertTrue(libraryType != null, this.myLibraryTypeClass);
        return libraryType;
    }
}

