/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration;

import com.intellij.history.core.Content;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.StoredContent;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManagerListener;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHistoryEventDispatcher
extends VirtualFileAdapter
implements VirtualFileManagerListener,
CommandListener,
BulkFileListener {
    private static final Key<Boolean> WAS_VERSIONED_KEY = Key.create((String)(LocalHistoryEventDispatcher.class.getSimpleName() + ".WAS_VERSIONED_KEY"));
    private final LocalHistoryFacade myVcs;
    private final IdeaGateway myGateway;
    private final EventDispatcher<VirtualFileListener> myVfsEventsDispatcher = EventDispatcher.create(VirtualFileListener.class);

    public LocalHistoryEventDispatcher(LocalHistoryFacade vcs, IdeaGateway gw) {
        this.myVcs = vcs;
        this.myGateway = gw;
        this.myVfsEventsDispatcher.addListener((EventListener)((Object)this));
    }

    public void beforeRefreshStart(boolean asynchronous) {
        this.beginChangeSet();
    }

    public void afterRefreshFinish(boolean asynchronous) {
        this.endChangeSet(LocalHistoryBundle.message("system.label.external.change", new Object[0]));
    }

    public void commandStarted(CommandEvent e) {
        this.beginChangeSet();
    }

    public void beforeCommandFinished(CommandEvent e) {
    }

    public void commandFinished(CommandEvent e) {
        this.endChangeSet(e.getCommandName());
    }

    public void undoTransparentActionStarted() {
    }

    public void undoTransparentActionFinished() {
    }

    public void startAction() {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.myVcs.forceBeginChangeSet();
    }

    public void finishAction(String name) {
        this.myGateway.registerUnsavedDocuments(this.myVcs);
        this.endChangeSet(name);
    }

    private void beginChangeSet() {
        this.myVcs.beginChangeSet();
    }

    private void endChangeSet(String name) {
        this.myVcs.endChangeSet(name);
    }

    public void fileCreated(@NotNull VirtualFileEvent e) {
        this.beginChangeSet();
        this.createRecursively(e.getFile());
        this.endChangeSet(null);
    }

    private void createRecursively(VirtualFile f) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)f, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile f) {
                if (LocalHistoryEventDispatcher.this.isVersioned(f)) {
                    LocalHistoryEventDispatcher.this.myVcs.created(f.getPath(), f.isDirectory());
                }
                return true;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile f) {
                return LocalHistoryEventDispatcher.this.myGateway.isVersioned(f, true) ? IdeaGateway.loadAndIterateChildren(f) : IdeaGateway.iterateDBChildren(f);
            }
        });
    }

    public void beforeContentsChange(@NotNull VirtualFileEvent e) {
        if (!this.areContentChangesVersioned(e)) {
            return;
        }
        VirtualFile f = e.getFile();
        Pair<StoredContent, Long> content = this.myGateway.acquireAndUpdateActualContent(f, null);
        if (content != null) {
            this.myVcs.contentChanged(f.getPath(), (Content)content.first, (Long)content.second);
        }
    }

    public void beforePropertyChange(@NotNull VirtualFilePropertyEvent e) {
        if ("name".equals(e.getPropertyName())) {
            VirtualFile f = e.getFile();
            f.putUserData(WAS_VERSIONED_KEY, (Object)this.myGateway.isVersioned(f));
        }
    }

    public void propertyChanged(@NotNull VirtualFilePropertyEvent e) {
        if ("name".equals(e.getPropertyName())) {
            VirtualFile f = e.getFile();
            boolean isVersioned = this.myGateway.isVersioned(f);
            Boolean wasVersioned = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
            if (wasVersioned == null) {
                return;
            }
            f.putUserData(WAS_VERSIONED_KEY, null);
            if (!wasVersioned.booleanValue() && !isVersioned) {
                return;
            }
            String oldName = (String)e.getOldValue();
            this.myVcs.renamed(f.getPath(), oldName);
        } else if ("writable".equals(e.getPropertyName())) {
            if (!this.isVersioned(e.getFile())) {
                return;
            }
            VirtualFile f = e.getFile();
            if (!f.isDirectory()) {
                this.myVcs.readOnlyStatusChanged(f.getPath(), (Boolean)e.getOldValue() == false);
            }
        }
    }

    public void beforeFileMovement(@NotNull VirtualFileMoveEvent e) {
        VirtualFile f = e.getFile();
        f.putUserData(WAS_VERSIONED_KEY, (Object)this.myGateway.isVersioned(f));
    }

    public void fileMoved(@NotNull VirtualFileMoveEvent e) {
        VirtualFile f = e.getFile();
        boolean isVersioned = this.myGateway.isVersioned(f);
        Boolean wasVersioned = (Boolean)f.getUserData(WAS_VERSIONED_KEY);
        if (wasVersioned == null) {
            return;
        }
        f.putUserData(WAS_VERSIONED_KEY, null);
        if (!wasVersioned.booleanValue() && !isVersioned) {
            return;
        }
        this.myVcs.moved(f.getPath(), e.getOldParent().getPath());
    }

    public void beforeFileDeletion(@NotNull VirtualFileEvent e) {
        VirtualFile f = e.getFile();
        Entry entry = this.myGateway.createEntryForDeletion(f);
        if (entry != null) {
            this.myVcs.deleted(f.getPath(), entry);
        }
    }

    private boolean isVersioned(VirtualFile f) {
        return this.myGateway.isVersioned(f);
    }

    private boolean areContentChangesVersioned(VirtualFileEvent e) {
        return this.myGateway.areContentChangesVersioned(e.getFile());
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        this.myGateway.runWithVfsEventsDispatchContext(events, true, () -> {
            for (VFileEvent event : events) {
                BulkVirtualFileListenerAdapter.fireBefore((VirtualFileListener)((VirtualFileListener)this.myVfsEventsDispatcher.getMulticaster()), (VFileEvent)event);
            }
        });
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        this.myGateway.runWithVfsEventsDispatchContext(events, false, () -> {
            for (VFileEvent event : events) {
                BulkVirtualFileListenerAdapter.fireAfter((VirtualFileListener)((VirtualFileListener)this.myVfsEventsDispatcher.getMulticaster()), (VFileEvent)event);
            }
        });
    }

    public void addVirtualFileListener(VirtualFileListener virtualFileListener, Disposable disposable) {
        this.myVfsEventsDispatcher.addListener((EventListener)virtualFileListener, disposable);
    }
}

