/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.views;

import com.intellij.diff.DiffDialogHints;
import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.core.revisions.Difference;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryBundle;
import com.intellij.history.integration.ui.models.DirectoryHistoryDialogModel;
import com.intellij.history.integration.ui.views.DirectoryChange;
import com.intellij.history.integration.ui.views.HistoryDialog;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffAction;
import com.intellij.openapi.vcs.changes.actions.diff.ShowDiffContext;
import com.intellij.openapi.vcs.changes.ui.ChangeNodeDecorator;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesTreeList;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ExcludingTraversalPolicy;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SearchTextField;
import com.intellij.ui.SearchTextFieldWithStoredHistory;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;

public class DirectoryHistoryDialog
extends HistoryDialog<DirectoryHistoryDialogModel> {
    private ChangesTreeList<Change> myChangesTree;
    private JScrollPane myChangesTreeScrollPane;
    private ActionToolbar myToolBar;

    public DirectoryHistoryDialog(Project p, IdeaGateway gw, VirtualFile f) {
        this(p, gw, f, true);
    }

    protected DirectoryHistoryDialog(@NotNull Project p, IdeaGateway gw, VirtualFile f, boolean doInit) {
        super(p, gw, f, doInit);
    }

    @Override
    protected DirectoryHistoryDialogModel createModel(LocalHistoryFacade vcs) {
        return new DirectoryHistoryDialogModel(this.myProject, this.myGateway, vcs, this.myFile);
    }

    @Override
    protected Pair<JComponent, Dimension> createDiffPanel(JPanel root, ExcludingTraversalPolicy traversalPolicy) {
        this.initChangesTree(root);
        JPanel p = new JPanel(new BorderLayout());
        this.myToolBar = ActionManager.getInstance().createActionToolbar("unknown", this.createChangesTreeActions(root), true);
        JPanel toolBarPanel = new JPanel(new BorderLayout());
        toolBarPanel.add((Component)this.myToolBar.getComponent(), "Center");
        if (this.showSearchField()) {
            SearchTextField search = this.createSearchBox(root);
            toolBarPanel.add((Component)search, "East");
            traversalPolicy.exclude((Component)search.getTextEditor());
        }
        p.add((Component)toolBarPanel, "North");
        this.myChangesTreeScrollPane = ScrollPaneFactory.createScrollPane(this.myChangesTree);
        p.add((Component)this.myChangesTreeScrollPane, "Center");
        return Pair.create((Object)p, (Object)toolBarPanel.getPreferredSize());
    }

    protected boolean showSearchField() {
        return true;
    }

    @Override
    protected void setDiffBorder(Border border) {
        this.myChangesTreeScrollPane.setBorder(border);
    }

    private SearchTextField createSearchBox(JPanel root) {
        final SearchTextFieldWithStoredHistory field = new SearchTextFieldWithStoredHistory(this.getPropertiesKey() + ".searchHistory");
        field.addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                DirectoryHistoryDialog.this.scheduleRevisionsUpdate(m -> {
                    m.setFilter(field.getText());
                    field.addCurrentTextToHistory();
                });
            }
        });
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                field.requestFocusInWindow();
            }
        }.registerCustomShortcutSet(CommonShortcuts.getFind(), (JComponent)root, (Disposable)this);
        return field;
    }

    private void initChangesTree(JComponent root) {
        this.myChangesTree = this.createChangesTree();
        this.myChangesTree.setDoubleClickHandler(() -> new ShowDifferenceAction().performIfEnabled());
        this.myChangesTree.installPopupHandler(this.createChangesTreeActions(root));
    }

    private ChangesTreeList<Change> createChangesTree() {
        return new ChangesTreeList<Change>(this.myProject, Collections.emptyList(), false, false, null, null){

            @Override
            protected DefaultTreeModel buildTreeModel(List<Change> cc, ChangeNodeDecorator changeNodeDecorator) {
                return TreeModelBuilder.buildFromChanges(this.myProject, this.isShowFlatten(), cc, changeNodeDecorator);
            }

            @Override
            protected List<Change> getSelectedObjects(ChangesBrowserNode node) {
                return node.getAllChangesUnder();
            }

            @Override
            protected Change getLeadSelectedObject(ChangesBrowserNode node) {
                Object o = node.getUserObject();
                if (o instanceof Change) {
                    return (Change)o;
                }
                return null;
            }
        };
    }

    private ActionGroup createChangesTreeActions(JComponent root) {
        DefaultActionGroup result2 = new DefaultActionGroup();
        ShowDifferenceAction a = new ShowDifferenceAction();
        a.registerCustomShortcutSet(CommonShortcuts.getDiff(), root);
        result2.add((AnAction)a);
        result2.add((AnAction)new RevertSelectionAction());
        result2.addSeparator();
        result2.addAll(this.myChangesTree.getTreeActions());
        return result2;
    }

    @Override
    protected void updateActions() {
        super.updateActions();
        this.myToolBar.updateActionsImmediately();
    }

    @Override
    protected Runnable doUpdateDiffs(DirectoryHistoryDialogModel model) {
        List<Change> changes = model.getChanges();
        return () -> this.myChangesTree.setChangesToDisplay(changes);
    }

    @Override
    protected String getHelpId() {
        return "reference.dialogs.localHistory.show.folder";
    }

    private List<DirectoryChange> getChanges() {
        return this.myChangesTree.getChanges();
    }

    private List<DirectoryChange> getSelectedChanges() {
        return this.myChangesTree.getSelectedChanges();
    }

    private abstract class ActionOnSelection
    extends HistoryDialog.MyAction {
        public ActionOnSelection(String name, String iconName) {
            super(name, null, IconLoader.getIcon((String)iconName));
        }

        protected void doPerform(DirectoryHistoryDialogModel model) {
            this.doPerform(model, DirectoryHistoryDialog.this.getSelectedChanges());
        }

        protected abstract void doPerform(DirectoryHistoryDialogModel var1, List<DirectoryChange> var2);

        protected boolean isEnabled(DirectoryHistoryDialogModel model) {
            List changes = DirectoryHistoryDialog.this.getSelectedChanges();
            if (changes.isEmpty()) {
                return false;
            }
            return this.isEnabledFor(model, changes);
        }

        protected boolean isEnabledFor(DirectoryHistoryDialogModel model, List<DirectoryChange> changes) {
            return true;
        }
    }

    private class RevertSelectionAction
    extends ActionOnSelection {
        public RevertSelectionAction() {
            super(LocalHistoryBundle.message("action.revert.selection", new Object[0]), "/actions/rollback.png");
        }

        @Override
        protected void doPerform(DirectoryHistoryDialogModel model, List<DirectoryChange> selected) {
            ArrayList<Difference> diffs = new ArrayList<Difference>();
            for (DirectoryChange each : selected) {
                diffs.add(each.getModel().getDifference());
            }
            DirectoryHistoryDialog.this.revert(model.createRevisionReverter(diffs));
        }

        @Override
        protected boolean isEnabledFor(DirectoryHistoryDialogModel model, List<DirectoryChange> changes) {
            return model.isRevertEnabled();
        }
    }

    private class ShowDifferenceAction
    extends ActionOnSelection {
        public ShowDifferenceAction() {
            super(LocalHistoryBundle.message("action.show.difference", new Object[0]), "/actions/diff.png");
        }

        @Override
        protected void doPerform(DirectoryHistoryDialogModel model, List<DirectoryChange> selected) {
            THashSet selectedSet = new THashSet(selected);
            int index = 0;
            ArrayList<Change> changes = new ArrayList<Change>();
            for (DirectoryChange change : this.iterFileChanges()) {
                if (selectedSet.contains((Object)change)) {
                    index = changes.size();
                }
                changes.add(change);
            }
            ShowDiffAction.showDiffForChange(DirectoryHistoryDialog.this.myProject, changes, index, new ShowDiffContext(DiffDialogHints.FRAME));
        }

        private Iterable<DirectoryChange> iterFileChanges() {
            return ContainerUtil.iterate((Collection)DirectoryHistoryDialog.this.getChanges(), each -> each.canShowFileDifference());
        }

        @Override
        protected boolean isEnabledFor(DirectoryHistoryDialogModel model, List<DirectoryChange> changes) {
            return this.iterFileChanges().iterator().hasNext();
        }
    }
}

