/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ApplicationStarterEx;
import com.intellij.openapi.application.JBProtocolCommand;
import com.intellij.openapi.application.JetBrainsProtocolHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.project.ProjectKt;
import com.intellij.projectImport.ProjectOpenProcessor;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandLineProcessor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.CommandLineProcessor");

    private CommandLineProcessor() {
    }

    @Nullable
    private static Project doOpenFileOrProject(String name) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(name);
        if (virtualFile == null) {
            Messages.showErrorDialog((String)("Cannot find file '" + name + "'"), (String)"Cannot Find File");
            return null;
        }
        ProjectOpenProcessor provider2 = ProjectOpenProcessor.getImportProvider((VirtualFile)virtualFile);
        if (provider2 instanceof PlatformProjectOpenProcessor && !virtualFile.isDirectory()) {
            provider2 = null;
        }
        if (provider2 != null || ProjectKt.isValidProjectPath(name)) {
            Project result2 = ProjectUtil.openOrImport(name, null, true);
            if (result2 == null) {
                Messages.showErrorDialog((String)("Cannot open project '" + name + "'"), (String)"Cannot Open Project");
            }
            return result2;
        }
        return CommandLineProcessor.doOpenFile(virtualFile, -1, false);
    }

    @Nullable
    private static Project doOpenFile(VirtualFile file2, int line, boolean tempProject) {
        Project[] projects = ProjectManager.getInstance().getOpenProjects();
        if (projects.length == 0 || tempProject) {
            PlatformProjectOpenProcessor processor2 = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (processor2 != null) {
                EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.noneOf(PlatformProjectOpenProcessor.Option.class);
                if (tempProject) {
                    options.add(PlatformProjectOpenProcessor.Option.TEMP_PROJECT);
                    options.add(PlatformProjectOpenProcessor.Option.FORCE_NEW_FRAME);
                }
                return PlatformProjectOpenProcessor.doOpenProject(file2, null, line, null, options);
            }
            Messages.showErrorDialog((String)"No project found to open file in", (String)"Cannot Open File");
            return null;
        }
        NonProjectFileWritingAccessProvider.allowWriting(file2);
        Project project2 = CommandLineProcessor.findBestProject(file2, projects);
        OpenFileDescriptor descriptor = line == -1 ? new OpenFileDescriptor(project2, file2) : new OpenFileDescriptor(project2, file2, line - 1, 0);
        descriptor.navigate(true);
        return project2;
    }

    @NotNull
    private static Project findBestProject(VirtualFile virtualFile, Project[] projects) {
        for (Project aProject : projects) {
            if (!ProjectRootManager.getInstance((Project)aProject).getFileIndex().isInContent(virtualFile)) continue;
            return aProject;
        }
        IdeFrame frame = IdeFocusManager.getGlobalInstance().getLastFocusedFrame();
        Project project2 = frame == null ? null : frame.getProject();
        return project2 != null ? project2 : projects[0];
    }

    @Nullable
    public static Project processExternalCommandLine(List<String> args, @Nullable String currentDirectory) {
        if (args.size() > 0) {
            LOG.info("External command line:");
            LOG.info("Dir: " + currentDirectory);
            for (String string : args) {
                LOG.info(string);
            }
        }
        LOG.info("-----");
        if (args.size() > 0) {
            String command = args.get(0);
            for (ApplicationStarter starter : (ApplicationStarter[])Extensions.getExtensions((ExtensionPointName)ApplicationStarter.EP_NAME)) {
                if (!command.equals(starter.getCommandName()) || !(starter instanceof ApplicationStarterEx) || !((ApplicationStarterEx)starter).canProcessExternalCommandLine()) continue;
                LOG.info("Processing command with " + starter);
                ((ApplicationStarterEx)starter).processExternalCommandLine(ArrayUtil.toStringArray(args), currentDirectory);
                return null;
            }
            if (command.startsWith("jetbrains://")) {
                try {
                    String string = URLDecoder.decode(command, "UTF-8");
                    JetBrainsProtocolHandler.processJetBrainsLauncherParameters((String)string);
                    ApplicationManager.getApplication().invokeLater(() -> JBProtocolCommand.handleCurrentCommand());
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    LOG.error((Throwable)unsupportedEncodingException);
                }
                return null;
            }
        }
        Project lastOpenedProject = null;
        int n = -1;
        boolean tempProject = false;
        int argsSize = args.size();
        for (int i2 = 0; i2 < argsSize; ++i2) {
            int n2;
            String arg = args.get(i2);
            if (arg.equals("nosplash")) continue;
            if (arg.equals("-l") || arg.equals("--line")) {
                if (++i2 == args.size()) break;
                try {
                    n2 = Integer.parseInt(args.get(i2));
                }
                catch (NumberFormatException e) {
                    n2 = -1;
                }
                continue;
            }
            if (arg.equals("--temp-project")) {
                tempProject = true;
                continue;
            }
            if (StringUtil.isQuotedString((String)arg)) {
                arg = StringUtil.unquoteString((String)arg);
            }
            if (!new File(arg).isAbsolute()) {
                String string = arg = currentDirectory != null ? new File(currentDirectory, arg).getAbsolutePath() : new File(arg).getAbsolutePath();
            }
            if (n2 != -1 || tempProject) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(arg);
                if (virtualFile != null && !virtualFile.isDirectory()) {
                    lastOpenedProject = CommandLineProcessor.doOpenFile(virtualFile, n2, tempProject);
                } else {
                    Messages.showErrorDialog((String)("Cannot find file '" + arg + "'"), (String)"Cannot Find File");
                }
            } else {
                lastOpenedProject = CommandLineProcessor.doOpenFileOrProject(arg);
            }
            n2 = -1;
            tempProject = false;
        }
        return lastOpenedProject;
    }
}

