/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import com.intellij.ide.ExceptionRegistry;
import com.intellij.ide.StackTrace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0003\u001a\u00020\u0004J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0015\u001a\u00020\u0016J\b\u0010\u0017\u001a\u0004\u0018\u00010\u000fJ\u0016\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0004J\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/ExceptionRegistry;", "", "()V", "count", "", "getCount", "()I", "setCount", "(I)V", "leafFrames", "", "Lcom/intellij/ide/ExceptionRegistry$LeafFrame;", "root", "Lcom/intellij/ide/ExceptionRegistry$StackFrame;", "addFrames", "Lcom/intellij/ide/StackTrace;", "throwable", "", "clear", "", "find", "md5", "", "getMostFrequent", "getStackTraces", "", "threshold", "register", "LeafFrame", "StackFrame", "platform-impl"})
public final class ExceptionRegistry {
    private static int count;
    private static final StackFrame root;
    private static final List<LeafFrame> leafFrames;
    public static final ExceptionRegistry INSTANCE;

    public final int getCount() {
        return count;
    }

    public final void setCount(int n) {
        count = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final StackTrace register(@NotNull Throwable throwable) {
        Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            int n = count;
            count = n + 1;
            StackTrace stackTrace = INSTANCE.addFrames(throwable);
            return stackTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int count() {
        int n;
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            n = count;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final StackTrace getMostFrequent() {
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            Object v0;
            block8: {
                if (!leafFrames.isEmpty()) break block8;
                StackTrace stackTrace = null;
                return stackTrace;
            }
            Iterable $receiver$iv = leafFrames;
            Iterator iterator$iv = $receiver$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                LeafFrame it = (LeafFrame)maxElem$iv;
                Comparable maxValue$iv = Integer.valueOf(it.getCount());
                while (iterator$iv.hasNext()) {
                    Object e$iv = iterator$iv.next();
                    LeafFrame it2 = (LeafFrame)e$iv;
                    Comparable v$iv = Integer.valueOf(it2.getCount());
                    if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                }
                v0 = maxElem$iv;
            }
            if (v0 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.StackTrace");
            }
            StackTrace stackTrace = v0;
            return stackTrace;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clear() {
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            count = 0;
            root.setFirstChild(null);
            root.setNextSibling(null);
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<StackTrace> getStackTraces(int threshold) {
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Iterable iterable = $receiver$iv = (Iterable)leafFrames;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                LeafFrame it = (LeafFrame)element$iv$iv;
                if (!(it.count() >= threshold)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List list = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            CollectionsKt.sort((List)list);
            List list2 = list;
            return list2;
        }
    }

    @NotNull
    public static /* bridge */ /* synthetic */ List getStackTraces$default(ExceptionRegistry exceptionRegistry, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 0;
        }
        return exceptionRegistry.getStackTraces(n);
    }

    /*
     * WARNING - void declaration
     */
    private final StackTrace addFrames(Throwable throwable) {
        int n;
        StackFrame curr = root;
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        int max = ((Object[])stackTrace).length - 1;
        int n2 = max;
        if (n2 >= (n = 1)) {
            while (true) {
                void index;
                StackTraceElement element;
                StackTraceElement stackTraceElement = element = stackTrace[index];
                Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"element");
                curr = curr.addChild(stackTraceElement);
                if (index == n) break;
                --index;
            }
        }
        StackTraceElement stackTraceElement = stackTrace[0];
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"stackTrace[0]");
        LeafFrame leaf = curr.addLeaf(stackTraceElement, throwable.getClass());
        if (leaf.getCount() == 1) {
            leafFrames.add(leaf);
        }
        return leaf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final StackTrace find(@NotNull String md5) {
        Intrinsics.checkParameterIsNotNull((Object)md5, (String)"md5");
        ExceptionRegistry exceptionRegistry = this;
        synchronized (exceptionRegistry) {
            Object v0;
            block4: {
                Iterable $receiver$iv = leafFrames;
                for (Object element$iv : $receiver$iv) {
                    LeafFrame it = (LeafFrame)element$iv;
                    if (!Intrinsics.areEqual((Object)md5, (Object)it.md5string())) continue;
                    v0 = element$iv;
                    break block4;
                }
                v0 = null;
            }
            StackTrace stackTrace = v0;
            return stackTrace;
        }
    }

    private ExceptionRegistry() {
        INSTANCE = this;
        root = new StackFrame(new StackTraceElement("ROOT", "", "", 0), null);
        leafFrames = new ArrayList();
    }

    static {
        new ExceptionRegistry();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0012\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u001c\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00010\u001bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0003H\u0002R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0000X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u000e\"\u0004\b\u0015\u0010\u0010R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u000e\u00a8\u0006\u001f"}, d2={"Lcom/intellij/ide/ExceptionRegistry$StackFrame;", "", "frame", "Ljava/lang/StackTraceElement;", "parent", "(Ljava/lang/StackTraceElement;Lcom/intellij/ide/ExceptionRegistry$StackFrame;)V", "count", "", "getCount", "()I", "setCount", "(I)V", "firstChild", "getFirstChild", "()Lcom/intellij/ide/ExceptionRegistry$StackFrame;", "setFirstChild", "(Lcom/intellij/ide/ExceptionRegistry$StackFrame;)V", "getFrame", "()Ljava/lang/StackTraceElement;", "nextSibling", "getNextSibling", "setNextSibling", "getParent", "addChild", "addLeaf", "Lcom/intellij/ide/ExceptionRegistry$LeafFrame;", "cls", "Ljava/lang/Class;", "matches", "", "element", "platform-impl"})
    private static class StackFrame {
        private int count;
        @Nullable
        private StackFrame firstChild;
        @Nullable
        private StackFrame nextSibling;
        @NotNull
        private final StackTraceElement frame;
        @Nullable
        private final StackFrame parent;

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        @Nullable
        public final StackFrame getFirstChild() {
            return this.firstChild;
        }

        public final void setFirstChild(@Nullable StackFrame stackFrame) {
            this.firstChild = stackFrame;
        }

        @Nullable
        public final StackFrame getNextSibling() {
            return this.nextSibling;
        }

        public final void setNextSibling(@Nullable StackFrame stackFrame) {
            this.nextSibling = stackFrame;
        }

        @NotNull
        public final StackFrame addChild(@NotNull StackTraceElement frame) {
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            if (this.firstChild == null) {
                StackFrame child;
                this.firstChild = child = new StackFrame(frame, this);
                return child;
            }
            StackFrame prev = null;
            StackFrame curr = this.firstChild;
            while (curr != null) {
                if (curr.matches(frame)) {
                    int n = curr.count;
                    curr.count = n + 1;
                    return curr;
                }
                prev = curr;
                curr = curr.nextSibling;
            }
            StackFrame child = new StackFrame(frame, this);
            if (prev == null) {
                Intrinsics.throwNpe();
            }
            prev.nextSibling = child;
            return child;
        }

        @NotNull
        public final LeafFrame addLeaf(@NotNull StackTraceElement frame, @NotNull Class<Object> cls) {
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
            if (this.firstChild == null) {
                LeafFrame child = new LeafFrame(cls, frame, this);
                this.firstChild = child;
                return child;
            }
            StackFrame prev = null;
            StackFrame curr = this.firstChild;
            while (curr != null) {
                if (curr.matches(frame)) {
                    int n = curr.count;
                    curr.count = n + 1;
                    StackFrame stackFrame = curr;
                    if (stackFrame == null) {
                        throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.ExceptionRegistry.LeafFrame");
                    }
                    return (LeafFrame)stackFrame;
                }
                prev = curr;
                curr = curr.nextSibling;
            }
            LeafFrame child = new LeafFrame(cls, frame, this);
            if (prev == null) {
                Intrinsics.throwNpe();
            }
            prev.nextSibling = child;
            return child;
        }

        private final boolean matches(StackTraceElement element) {
            return Intrinsics.areEqual((Object)element, (Object)this.frame);
        }

        @NotNull
        public final StackTraceElement getFrame() {
            return this.frame;
        }

        @Nullable
        public final StackFrame getParent() {
            return this.parent;
        }

        public StackFrame(@NotNull StackTraceElement frame, @Nullable StackFrame parent) {
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            this.frame = frame;
            this.parent = parent;
            this.count = 1;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\tJ\u0011\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u000fH\u0016J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00010\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u000fH\u0016J\b\u0010\u001d\u001a\u00020\rH\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ide/ExceptionRegistry$LeafFrame;", "Lcom/intellij/ide/ExceptionRegistry$StackFrame;", "Lcom/intellij/ide/StackTrace;", "cls", "Ljava/lang/Class;", "", "frame", "Ljava/lang/StackTraceElement;", "parent", "(Ljava/lang/Class;Ljava/lang/StackTraceElement;Lcom/intellij/ide/ExceptionRegistry$StackFrame;)V", "getCls", "()Ljava/lang/Class;", "md5String", "", "compareTo", "", "other", "count", "frameSequence", "Lkotlin/sequences/Sequence;", "md5", "Lcom/google/common/hash/HashCode;", "md5string", "printStackTrace", "", "writer", "Ljava/io/PrintWriter;", "summarize", "maxWidth", "toStackTrace", "platform-impl"})
    private static final class LeafFrame
    extends StackFrame
    implements StackTrace {
        private String md5String;
        @NotNull
        private final Class<Object> cls;

        @Override
        public int count() {
            return this.getCount();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String summarize(int maxWidth) {
            StringBuilder sb = new StringBuilder(maxWidth);
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = "";
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = "";
            char arrow = '\u2190';
            sb.append(this.cls.getSimpleName()).append(": ");
            for (StackFrame curr : this.frameSequence()) {
                void prevMethod;
                void prevClass;
                StackTraceElement stackTraceElement = curr.getFrame();
                StackTraceElement $receiver = stackTraceElement;
                if (Intrinsics.areEqual((Object)$receiver.getClassName(), (Object)((String)prevClass.element)) ^ true) {
                    sb.append(StringsKt.substringAfterLast((String)$receiver.getClassName(), (char)'.', (String)""));
                }
                if (Intrinsics.areEqual((Object)$receiver.getMethodName(), (Object)((String)prevMethod.element)) ^ true) {
                    if (StringsKt.last((CharSequence)sb) != arrow) {
                        sb.append('.');
                    }
                    sb.append($receiver.getMethodName());
                }
                if ($receiver.getLineNumber() >= 1) {
                    if (StringsKt.last((CharSequence)sb) != arrow) {
                        sb.append(':');
                    }
                    sb.append(Integer.toString($receiver.getLineNumber()));
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)$receiver.getClassName(), (String)"className");
                prevClass.element = prevClass.element;
                Intrinsics.checkExpressionValueIsNotNull((Object)$receiver.getMethodName(), (String)"methodName");
                prevMethod.element = prevMethod.element;
                sb.append(arrow);
                if (sb.length() <= maxWidth) continue;
                break;
            }
            if (StringsKt.endsWith$default((CharSequence)sb, (char)arrow, (boolean)false, (int)2, null)) {
                StringsKt.trim((CharSequence)sb, (char[])new char[]{arrow});
            }
            if (sb.length() > maxWidth) {
                sb.setLength(maxWidth - 1);
                sb.append('\u2026');
            }
            String string = sb.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            return string;
        }

        @Override
        @NotNull
        public HashCode md5() {
            HashFunction hf = Hashing.md5();
            Hasher hc = hf.newHasher();
            hc.putString((CharSequence)this.cls.getName(), Charsets.UTF_8);
            for (StackFrame curr : this.frameSequence()) {
                StackTraceElement stackTraceElement;
                StackTraceElement $receiver = stackTraceElement = curr.getFrame();
                hc.putString((CharSequence)$receiver.getClassName(), Charsets.UTF_8);
                hc.putString((CharSequence)$receiver.getMethodName(), Charsets.UTF_8);
                String string = $receiver.getFileName();
                hc.putString(string != null ? (CharSequence)string : (CharSequence)"", Charsets.UTF_8);
                hc.putInt($receiver.getLineNumber());
            }
            HashCode hashCode = hc.hash();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashCode, (String)"hc.hash()");
            return hashCode;
        }

        @Override
        @NotNull
        public String md5string() {
            if (this.md5String == null) {
                HashCode hash = this.md5();
                byte[] bytes = hash.asBytes();
                this.md5String = BaseEncoding.base16().upperCase().encode(bytes);
            }
            String string = this.md5String;
            if (string == null) {
                Intrinsics.throwNpe();
            }
            return string;
        }

        @Override
        @NotNull
        public String toStackTrace() {
            StringWriter writer = new StringWriter();
            this.printStackTrace(new PrintWriter(writer));
            String string = writer.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"writer.toString()");
            return string;
        }

        @Override
        public void printStackTrace(@NotNull PrintWriter writer) {
            Intrinsics.checkParameterIsNotNull((Object)writer, (String)"writer");
            writer.print(this.cls.getName());
            writer.print(":\n");
            for (StackFrame curr : this.frameSequence()) {
                StackTraceElement stackTraceElement;
                writer.print("\tat ");
                StackTraceElement $receiver = stackTraceElement = curr.getFrame();
                writer.print($receiver.getClassName());
                writer.print('.');
                writer.print($receiver.getMethodName());
                if ($receiver.getLineNumber() == -2) {
                    writer.print("(Native Method)");
                } else if ($receiver.getFileName() != null) {
                    writer.print('(');
                    writer.print($receiver.getFileName());
                    writer.print(':');
                    writer.print($receiver.getMethodName());
                    writer.print(')');
                }
                writer.print("\n");
            }
        }

        @Override
        public int compareTo(@NotNull StackTrace other) {
            String string;
            String fileName;
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            StackTrace stackTrace = other;
            if (stackTrace == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.ExceptionRegistry.LeafFrame");
            }
            LeafFrame otherFrame = (LeafFrame)stackTrace;
            int delta = Intrinsics.compare((int)otherFrame.getCount(), (int)this.getCount());
            if (delta != 0) {
                return delta;
            }
            String string2 = this.getFrame().getClassName();
            String string3 = otherFrame.getFrame().getClassName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"otherFrame.frame.className");
            delta = string2.compareTo(string3);
            if (delta != 0) {
                return delta;
            }
            String string4 = this.getFrame().getMethodName();
            String string5 = otherFrame.getFrame().getMethodName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"otherFrame.frame.methodName");
            delta = string4.compareTo(string5);
            if (delta != 0) {
                return delta;
            }
            String string6 = this.getFrame().getFileName();
            if (string6 == null) {
                string6 = fileName = "";
            }
            if ((string = otherFrame.getFrame().getFileName()) == null) {
                string = "";
            }
            String otherFileName = string;
            delta = fileName.compareTo(otherFileName);
            if (delta != 0) {
                return delta;
            }
            return this.getFrame().getLineNumber() - otherFrame.getFrame().getLineNumber();
        }

        private final Sequence<StackFrame> frameSequence() {
            LeafFrame leafFrame = this;
            if (leafFrame == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.ide.ExceptionRegistry.StackFrame");
            }
            return SequencesKt.generateSequence((Object)leafFrame, (Function1)frameSequence.1.INSTANCE);
        }

        @NotNull
        public final Class<Object> getCls() {
            return this.cls;
        }

        public LeafFrame(@NotNull Class<Object> cls, @NotNull StackTraceElement frame, @Nullable StackFrame parent) {
            Intrinsics.checkParameterIsNotNull(cls, (String)"cls");
            Intrinsics.checkParameterIsNotNull((Object)frame, (String)"frame");
            super(frame, parent);
            this.cls = cls;
        }
    }
}

