/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationActivationListener;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.BusyObject;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameStateManagerImpl
extends FrameStateManager {
    private final List<FrameStateListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myShouldSynchronize;
    private final Alarm mySyncAlarm;
    private final BusyObject.Impl myActive;
    private final ApplicationImpl myApp;

    public FrameStateManagerImpl(final ApplicationImpl app) {
        this.myApp = app;
        this.myActive = new BusyObject.Impl(){

            public boolean isReady() {
                return FrameStateManagerImpl.this.myApp.isActive();
            }
        };
        this.myShouldSynchronize = false;
        this.mySyncAlarm = new Alarm();
        app.getMessageBus().connect().subscribe(ApplicationActivationListener.TOPIC, (Object)new ApplicationActivationListener.Adapter(){

            public void applicationActivated(IdeFrame ideFrame) {
                FrameStateManagerImpl.this.myActive.onReady();
                FrameStateManagerImpl.this.mySyncAlarm.cancelAllRequests();
                if (FrameStateManagerImpl.this.myShouldSynchronize) {
                    FrameStateManagerImpl.this.myShouldSynchronize = false;
                    FrameStateManagerImpl.this.fireActivationEvent();
                }
            }

            public void applicationDeactivated(IdeFrame ideFrame) {
                FrameStateManagerImpl.this.mySyncAlarm.cancelAllRequests();
                FrameStateManagerImpl.this.mySyncAlarm.addRequest(() -> {
                    if (!app.isActive() && !app.isDisposed()) {
                        FrameStateManagerImpl.this.myShouldSynchronize = true;
                        FrameStateManagerImpl.this.fireDeactivationEvent();
                    }
                }, 200);
            }
        });
    }

    public ActionCallback getApplicationActive() {
        return this.myActive.getReady((Object)this);
    }

    private void fireDeactivationEvent() {
        for (FrameStateListener listener2 : this.myListeners) {
            listener2.onFrameDeactivated();
        }
    }

    private void fireActivationEvent() {
        for (FrameStateListener listener2 : this.myListeners) {
            listener2.onFrameActivated();
        }
    }

    public void addListener(@NotNull FrameStateListener listener2) {
        this.addListener(listener2, null);
    }

    public void addListener(final @NotNull FrameStateListener listener2, @Nullable Disposable disposable) {
        this.myListeners.add(listener2);
        if (disposable != null) {
            Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

                public void dispose() {
                    FrameStateManagerImpl.this.removeListener(listener2);
                }
            });
        }
    }

    public void removeListener(@NotNull FrameStateListener listener2) {
        this.myListeners.remove(listener2);
    }
}

