/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.ActivityTracker;
import com.intellij.ide.ApplicationActivationStateManager;
import com.intellij.ide.CharToVKeyMap;
import com.intellij.ide.IdeKeyboardFocusManager;
import com.intellij.ide.IdePopupManager;
import com.intellij.ide.ToolkitBugsProcessor;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDManagerImpl;
import com.intellij.ide.plugins.PluginManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.idea.IdeaApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.TransactionGuard;
import com.intellij.openapi.application.TransactionGuardImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.diagnostic.FrequentEventDetector;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeyboardSettingsExternalizable;
import com.intellij.openapi.keymap.impl.IdeKeyEventDispatcher;
import com.intellij.openapi.keymap.impl.IdeMouseEventDispatcher;
import com.intellij.openapi.keymap.impl.KeyState;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.FocusManagerImpl;
import com.intellij.util.Alarm;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.io.storage.HeavyProcessLatch;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InputMethodEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.ComboPopup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.AppContext;
import sun.awt.SunToolkit;

public class IdeEventQueue
extends EventQueue {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.IdeEventQueue");
    private static TransactionGuardImpl ourTransactionGuard;
    private final Object myLock = new Object();
    private final List<Runnable> myIdleListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Runnable> myActivityListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Alarm myIdleRequestsAlarm = new Alarm();
    private final Alarm myIdleTimeCounterAlarm = new Alarm();
    private long myIdleTime;
    private final Map<Runnable, MyFireIdleRequest> myListener2Request = new HashMap();
    private final IdeKeyEventDispatcher myKeyEventDispatcher = new IdeKeyEventDispatcher(this);
    private final IdeMouseEventDispatcher myMouseEventDispatcher = new IdeMouseEventDispatcher();
    private final IdePopupManager myPopupManager = new IdePopupManager();
    private final ToolkitBugsProcessor myToolkitBugsProcessor = new ToolkitBugsProcessor();
    private boolean mySuspendMode;
    private Component myFocusOwner;
    private final Runnable myExitSuspendModeRunnable = new ExitSuspendModeRunnable();
    private final Alarm mySuspendModeAlarm = new Alarm();
    private int myEventCount;
    final AtomicInteger myKeyboardEventsPosted = new AtomicInteger();
    final AtomicInteger myKeyboardEventsDispatched = new AtomicInteger();
    private boolean myIsInInputEvent;
    private AWTEvent myCurrentEvent;
    private long myLastActiveTime;
    private long myLastEventTime = System.currentTimeMillis();
    private WindowManagerEx myWindowManager;
    private final List<EventDispatcher> myDispatchers = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<EventDispatcher> myPostProcessors = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<Runnable> myReady = ContainerUtil.newHashSet();
    private boolean myKeyboardBusy;
    private boolean myDispatchingFocusEvent;
    private boolean myWinMetaPressed;
    private int myInputMethodLock;
    private final com.intellij.util.EventDispatcher<PostEventHook> myPostEventListeners = com.intellij.util.EventDispatcher.create(PostEventHook.class);
    private static boolean ourAppIsLoaded;
    private final FrequentEventDetector myFrequentEventDetector = new FrequentEventDetector(1009, 100);
    private Boolean myTestMode;
    private static Ref<Method> unsafeNonBlockingExecuteRef;

    public static IdeEventQueue getInstance() {
        return IdeEventQueueHolder.INSTANCE;
    }

    private IdeEventQueue() {
        EventQueue systemEventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        assert (!(systemEventQueue instanceof IdeEventQueue)) : systemEventQueue;
        systemEventQueue.push(this);
        this.addIdleTimeCounterRequest();
        IdeKeyboardFocusManager keyboardFocusManager = IdeKeyboardFocusManager.replaceDefault();
        keyboardFocusManager.addPropertyChangeListener("permanentFocusOwner", e -> {
            Application application = ApplicationManager.getApplication();
            if (application == null) {
                return;
            }
            application.assertIsDispatchThread();
            Window focusedWindow = keyboardFocusManager.getFocusedWindow();
            Component focusOwner = keyboardFocusManager.getFocusOwner();
            if (this.mySuspendMode && focusedWindow != null && focusOwner != null && focusOwner != this.myFocusOwner && !(focusOwner instanceof Window)) {
                this.exitSuspendMode();
            }
        });
        this.addDispatcher(new WindowsAltSuppressor(), null);
        this.addDispatcher(new EditingCanceller(), null);
        this.abracadabraDaberBoreh();
    }

    private void abracadabraDaberBoreh() {
        try {
            Class<?> aClass = Class.forName("sun.awt.PostEventQueue");
            Constructor<?> constructor = aClass.getDeclaredConstructor(EventQueue.class);
            constructor.setAccessible(true);
            Object postEventQueue = constructor.newInstance(this);
            AppContext.getAppContext().put("PostEventQueue", postEventQueue);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setWindowManager(WindowManagerEx windowManager) {
        this.myWindowManager = windowManager;
    }

    private void addIdleTimeCounterRequest() {
        if (this.isTestMode()) {
            return;
        }
        this.myIdleTimeCounterAlarm.cancelAllRequests();
        this.myLastActiveTime = System.currentTimeMillis();
        this.myIdleTimeCounterAlarm.addRequest(() -> {
            this.myIdleTime += System.currentTimeMillis() - this.myLastActiveTime;
            this.addIdleTimeCounterRequest();
        }, 20000, ModalityState.NON_MODAL);
    }

    public void stopIdleTimeCalculation() {
        this.myIdleTimeCounterAlarm.cancelAllRequests();
    }

    public boolean shouldNotTypeInEditor() {
        return this.myKeyEventDispatcher.isWaitingForSecondKeyStroke() || this.mySuspendMode;
    }

    private void enterSuspendMode() {
        this.mySuspendMode = true;
        this.myFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        this.mySuspendModeAlarm.cancelAllRequests();
        this.mySuspendModeAlarm.addRequest(this.myExitSuspendModeRunnable, 750);
    }

    private void exitSuspendMode() {
        if (this.shallEnterSuspendMode()) {
            this.mySuspendModeAlarm.cancelAllRequests();
            this.mySuspendModeAlarm.addRequest(this.myExitSuspendModeRunnable, 250);
        } else {
            this.mySuspendMode = false;
            this.myFocusOwner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIdleListener(@NotNull Runnable runnable2, int timeoutMillis) {
        if (timeoutMillis <= 0 || TimeUnit.MILLISECONDS.toHours(timeoutMillis) >= 24L) {
            throw new IllegalArgumentException("This timeout value is unsupported: " + timeoutMillis);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myIdleListeners.add(runnable2);
            MyFireIdleRequest request = new MyFireIdleRequest(runnable2, timeoutMillis);
            this.myListener2Request.put(runnable2, request);
            UIUtil.invokeLaterIfNeeded(() -> this.myIdleRequestsAlarm.addRequest((Runnable)request, timeoutMillis));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeIdleListener(@NotNull Runnable runnable2) {
        Object object = this.myLock;
        synchronized (object) {
            MyFireIdleRequest request;
            boolean wasRemoved = this.myIdleListeners.remove(runnable2);
            if (!wasRemoved) {
                LOG.error("unknown runnable: " + runnable2);
            }
            LOG.assertTrue((request = this.myListener2Request.remove(runnable2)) != null);
            this.myIdleRequestsAlarm.cancelRequest((Runnable)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivityListener(@NotNull Runnable runnable2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myActivityListeners.add(runnable2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addActivityListener(@NotNull Runnable runnable2, Disposable parentDisposable) {
        Object object = this.myLock;
        synchronized (object) {
            ContainerUtil.add((Object)runnable2, this.myActivityListeners, (Disposable)parentDisposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeActivityListener(@NotNull Runnable runnable2) {
        Object object = this.myLock;
        synchronized (object) {
            this.myActivityListeners.remove(runnable2);
        }
    }

    public void addDispatcher(@NotNull EventDispatcher dispatcher, Disposable parent) {
        IdeEventQueue._addProcessor(dispatcher, parent, this.myDispatchers);
    }

    public void removeDispatcher(@NotNull EventDispatcher dispatcher) {
        this.myDispatchers.remove(dispatcher);
    }

    public boolean containsDispatcher(@NotNull EventDispatcher dispatcher) {
        return this.myDispatchers.contains(dispatcher);
    }

    public void addPostprocessor(@NotNull EventDispatcher dispatcher, @Nullable Disposable parent) {
        IdeEventQueue._addProcessor(dispatcher, parent, this.myPostProcessors);
    }

    public void removePostprocessor(@NotNull EventDispatcher dispatcher) {
        this.myPostProcessors.remove(dispatcher);
    }

    private static void _addProcessor(@NotNull EventDispatcher dispatcher, Disposable parent, @NotNull Collection<EventDispatcher> set2) {
        set2.add(dispatcher);
        if (parent != null) {
            Disposer.register((Disposable)parent, () -> set2.remove(dispatcher));
        }
    }

    public int getEventCount() {
        return this.myEventCount;
    }

    public void setEventCount(int evCount) {
        this.myEventCount = evCount;
    }

    public AWTEvent getTrueCurrentEvent() {
        return this.myCurrentEvent;
    }

    private static boolean appIsLoaded() {
        if (ourAppIsLoaded) {
            return true;
        }
        boolean loaded = IdeaApplication.isLoaded();
        if (loaded) {
            ourAppIsLoaded = true;
        }
        return loaded;
    }

    public static void applicationClose() {
        ourAppIsLoaded = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispatchEvent(@NotNull AWTEvent e) {
        this.checkForTimeJump();
        if (!IdeEventQueue.appIsLoaded()) {
            try {
                super.dispatchEvent(e);
            }
            catch (Throwable t) {
                this.processException(t);
            }
            return;
        }
        e = IdeEventQueue.fixNonEnglishKeyboardLayouts(e);
        e = IdeEventQueue.mapEvent(e);
        if (Registry.is((String)"keymap.windows.as.meta")) {
            e = this.mapMetaState(e);
        }
        boolean wasInputEvent = this.myIsInInputEvent;
        this.myIsInInputEvent = IdeEventQueue.isInputEvent(e);
        AWTEvent oldEvent = this.myCurrentEvent;
        this.myCurrentEvent = e;
        HeavyProcessLatch.INSTANCE.prioritizeUiActivity();
        try (AccessToken ignored = IdeEventQueue.startActivity(e);){
            this._dispatchEvent(e, false);
        }
        catch (Throwable t) {
            try {
                this.processException(t);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
                this.myIsInInputEvent = wasInputEvent;
                this.myCurrentEvent = oldEvent;
                for (EventDispatcher each : this.myPostProcessors) {
                    each.dispatch(e);
                }
                if (e instanceof KeyEvent) {
                    this.maybeReady();
                }
            }
        }
        HeavyProcessLatch.INSTANCE.stopThreadPrioritizing();
        this.myIsInInputEvent = wasInputEvent;
        this.myCurrentEvent = oldEvent;
        for (EventDispatcher each : this.myPostProcessors) {
            each.dispatch(e);
        }
        if (e instanceof KeyEvent) {
            this.maybeReady();
        }
    }

    private void checkForTimeJump() {
        long now = System.currentTimeMillis();
        if (this.myLastEventTime > now + 1000L) {
            LOG.warn("System clock's jumped back by ~" + (this.myLastEventTime - now) / 1000L + " sec");
        }
        this.myLastEventTime = now;
    }

    private static boolean isInputEvent(@NotNull AWTEvent e) {
        return e instanceof InputEvent || e instanceof InputMethodEvent || e instanceof WindowEvent || e instanceof ActionEvent;
    }

    @Override
    @NotNull
    public AWTEvent getNextEvent() throws InterruptedException {
        AWTEvent event = super.getNextEvent();
        if (IdeEventQueue.isKeyboardEvent(event) && this.myKeyboardEventsDispatched.incrementAndGet() > this.myKeyboardEventsPosted.get()) {
            throw new RuntimeException(event + "; posted: " + this.myKeyboardEventsPosted + "; dispatched: " + this.myKeyboardEventsDispatched);
        }
        return event;
    }

    @Nullable
    static AccessToken startActivity(@NotNull AWTEvent e) {
        if (ourTransactionGuard == null && IdeEventQueue.appIsLoaded() && ApplicationManager.getApplication() != null && !ApplicationManager.getApplication().isDisposed()) {
            ourTransactionGuard = (TransactionGuardImpl)TransactionGuard.getInstance();
        }
        return ourTransactionGuard == null ? null : ourTransactionGuard.startActivity(IdeEventQueue.isInputEvent(e) || e instanceof ItemEvent || e instanceof FocusEvent);
    }

    private void processException(@NotNull Throwable t) {
        if (!this.myToolkitBugsProcessor.process(t)) {
            PluginManager.processException(t);
        }
    }

    @NotNull
    private static AWTEvent fixNonEnglishKeyboardLayouts(@NotNull AWTEvent e) {
        if (!(e instanceof KeyEvent)) {
            return e;
        }
        KeyboardSettingsExternalizable externalizable = KeyboardSettingsExternalizable.getInstance();
        if (!Registry.is((String)"ide.non.english.keyboard.layout.fix") || externalizable == null || !externalizable.isNonEnglishKeyboardSupportEnabled()) {
            return e;
        }
        KeyEvent ke = (KeyEvent)e;
        switch (ke.getID()) {
            case 401: {
                break;
            }
        }
        int keyCodeFromChar = CharToVKeyMap.get(Character.valueOf(ke.getKeyChar()));
        if (keyCodeFromChar == ke.getKeyCode() || keyCodeFromChar == 0) {
            return e;
        }
        ke.setKeyCode(keyCodeFromChar);
        return ke;
    }

    @NotNull
    private static AWTEvent mapEvent(@NotNull AWTEvent e) {
        if (SystemInfo.isXWindow && e instanceof MouseEvent && ((MouseEvent)e).getButton() > 3) {
            MouseEvent src = (MouseEvent)e;
            e = src.getButton() < 6 ? new MouseWheelEvent(src.getComponent(), 507, src.getWhen(), src.getModifiers() | 0x40, src.getX(), src.getY(), 0, false, 0, src.getClickCount(), src.getButton() == 4 ? -1 : 1) : new MouseEvent(src.getComponent(), src.getID(), src.getWhen(), src.getModifiers() | 1 << 8 + src.getButton(), src.getX(), src.getY(), 1, src.isPopupTrigger(), src.getButton() - 2);
        }
        return e;
    }

    @NotNull
    private AWTEvent mapMetaState(@NotNull AWTEvent e) {
        if (this.myWinMetaPressed) {
            Application app = ApplicationManager.getApplication();
            boolean weAreNotActive = app == null || !app.isActive();
            if (weAreNotActive |= e instanceof FocusEvent && ((FocusEvent)e).getOppositeComponent() == null) {
                this.myWinMetaPressed = false;
                return e;
            }
        }
        if (e instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)e;
            if (ke.getKeyCode() == 524) {
                if (ke.getID() == 401) {
                    this.myWinMetaPressed = true;
                }
                if (ke.getID() == 402) {
                    this.myWinMetaPressed = false;
                }
                return new KeyEvent(ke.getComponent(), ke.getID(), ke.getWhen(), ke.getModifiers() | ke.getModifiersEx(), 157, ke.getKeyChar(), ke.getKeyLocation());
            }
            if (this.myWinMetaPressed) {
                return new KeyEvent(ke.getComponent(), ke.getID(), ke.getWhen(), ke.getModifiers() | ke.getModifiersEx() | 4, ke.getKeyCode(), ke.getKeyChar(), ke.getKeyLocation());
            }
        }
        if (this.myWinMetaPressed && e instanceof MouseEvent && ((MouseEvent)e).getButton() != 0) {
            MouseEvent me = (MouseEvent)e;
            return new MouseEvent(me.getComponent(), me.getID(), me.getWhen(), me.getModifiers() | me.getModifiersEx() | 4, me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger(), me.getButton());
        }
        return e;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _dispatchEvent(@NotNull AWTEvent e, boolean typeAheadFlushing) {
        Object selectedPath;
        DnDManagerImpl dndManager;
        if (e.getID() == 506 && (dndManager = (DnDManagerImpl)DnDManager.getInstance()) != null) {
            dndManager.setLastDropHandler(null);
        }
        ++this.myEventCount;
        if (IdeEventQueue.processAppActivationEvents(e)) {
            return;
        }
        if (!typeAheadFlushing) {
            this.fixStickyFocusedComponents(e);
        }
        if (!this.myPopupManager.isPopupActive()) {
            this.enterSuspendModeIfNeeded(e);
        }
        boolean bl = this.myKeyboardBusy = e instanceof KeyEvent || this.myKeyboardEventsPosted.get() > this.myKeyboardEventsDispatched.get();
        if (e instanceof KeyEvent && e.getID() == 402 && ((KeyEvent)e).getKeyCode() == 16) {
            this.myMouseEventDispatcher.resetHorScrollingTracker();
        }
        if (!typeAheadFlushing && IdeEventQueue.typeAheadDispatchToFocusManager(e)) {
            LOG.debug("Typeahead dispatch for event ", new Object[]{e});
            return;
        }
        if (e instanceof WindowEvent) {
            ActivityTracker.getInstance().inc();
        }
        if (e instanceof MouseWheelEvent && ((MenuElement[])(selectedPath = MenuSelectionManager.defaultManager().getSelectedPath())).length > 0 && !(selectedPath[0] instanceof ComboPopup)) {
            ((MouseWheelEvent)e).consume();
            Component component = selectedPath[0].getComponent();
            if (component instanceof JBPopupMenu) {
                ((JBPopupMenu)component).processMouseWheelEvent((MouseWheelEvent)e);
            }
            return;
        }
        if (e instanceof KeyEvent || e instanceof MouseEvent) {
            ActivityTracker.getInstance().inc();
            selectedPath = this.myLock;
            synchronized (selectedPath) {
                this.myIdleRequestsAlarm.cancelAllRequests();
                for (Runnable idleListener : this.myIdleListeners) {
                    MyFireIdleRequest request = this.myListener2Request.get(idleListener);
                    if (request == null) {
                        LOG.error("There is no request for " + idleListener);
                        continue;
                    }
                    this.myIdleRequestsAlarm.addRequest((Runnable)request, request.getTimeout(), ModalityState.NON_MODAL);
                }
                if (401 == e.getID() || 400 == e.getID() || 501 == e.getID() || 502 == e.getID() || 500 == e.getID()) {
                    this.addIdleTimeCounterRequest();
                    for (Runnable activityListener : this.myActivityListeners) {
                        activityListener.run();
                    }
                }
            }
        }
        if (this.myPopupManager.isPopupActive() && this.myPopupManager.dispatch(e)) {
            if (this.myKeyEventDispatcher.isWaitingForSecondKeyStroke()) {
                this.myKeyEventDispatcher.setState(KeyState.STATE_INIT);
            }
            return;
        }
        if (this.dispatchByCustomDispatchers(e)) {
            return;
        }
        if (e instanceof InputMethodEvent && SystemInfo.isMac && this.myKeyEventDispatcher.isWaitingForSecondKeyStroke()) {
            return;
        }
        if (e instanceof ComponentEvent && this.myWindowManager != null) {
            this.myWindowManager.dispatchComponentEvent((ComponentEvent)e);
        }
        if (e instanceof KeyEvent) {
            if (this.mySuspendMode || !this.myKeyEventDispatcher.dispatchKeyEvent((KeyEvent)e)) {
                this.defaultDispatchEvent(e);
            } else {
                ((KeyEvent)e).consume();
                this.defaultDispatchEvent(e);
            }
        } else if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            if (IdeMouseEventDispatcher.patchClickCount(me) && me.getID() == 500) {
                MouseEvent toDispatch = new MouseEvent(me.getComponent(), me.getID(), System.currentTimeMillis(), me.getModifiers(), me.getX(), me.getY(), 1, me.isPopupTrigger(), me.getButton());
                SwingUtilities.invokeLater(() -> this.dispatchEvent(toDispatch));
            }
            if (!this.myMouseEventDispatcher.dispatchMouseEvent(me)) {
                this.defaultDispatchEvent(e);
            }
        } else {
            this.defaultDispatchEvent(e);
        }
    }

    private boolean dispatchByCustomDispatchers(@NotNull AWTEvent e) {
        for (EventDispatcher eachDispatcher : this.myDispatchers) {
            if (!eachDispatcher.dispatch(e)) continue;
            return true;
        }
        return false;
    }

    private static void fixStickyWindow(@NotNull KeyboardFocusManager mgr, Window wnd, @NotNull String resetMethod) {
        if (wnd != null && !wnd.isShowing()) {
            Method setActive;
            Window showingWindow;
            for (showingWindow = wnd; showingWindow != null && !showingWindow.isShowing(); showingWindow = (Window)showingWindow.getParent()) {
            }
            if (showingWindow == null) {
                Frame[] allFrames;
                for (Frame each : allFrames = Frame.getFrames()) {
                    if (!each.isShowing()) continue;
                    showingWindow = each;
                    break;
                }
            }
            if (showingWindow != null && showingWindow != wnd && (setActive = ReflectionUtil.findMethod((Collection)ReflectionUtil.getClassDeclaredMethods(KeyboardFocusManager.class, (boolean)false), (String)resetMethod, (Class[])new Class[]{Window.class})) != null) {
                try {
                    setActive.invoke((Object)mgr, showingWindow);
                }
                catch (Exception exc) {
                    LOG.info((Throwable)exc);
                }
            }
        }
    }

    public void fixStickyFocusedComponents(@Nullable AWTEvent e) {
        Component focusOwner;
        if (e != null && !(e instanceof InputEvent)) {
            return;
        }
        final KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (Registry.is((String)"actionSystem.fixStickyFocusedWindows")) {
            IdeEventQueue.fixStickyWindow(mgr, mgr.getActiveWindow(), "setGlobalActiveWindow");
            IdeEventQueue.fixStickyWindow(mgr, mgr.getFocusedWindow(), "setGlobalFocusedWindow");
        }
        if (Registry.is((String)"actionSystem.fixNullFocusedComponent") && ((focusOwner = mgr.getFocusOwner()) == null || !focusOwner.isShowing() || focusOwner instanceof JFrame || focusOwner instanceof JDialog)) {
            boolean okToFixFocus;
            Application app = ApplicationManager.getApplication();
            if (app instanceof ApplicationEx && !((ApplicationEx)app).isLoaded()) {
                return;
            }
            boolean mouseEventsAhead = IdeEventQueue.isMouseEventAhead(e);
            boolean focusTransferredNow = IdeFocusManager.getGlobalInstance().isFocusBeingTransferred();
            boolean bl = okToFixFocus = !mouseEventsAhead && !focusTransferredNow;
            if (okToFixFocus) {
                Method getNativeFocusOwner;
                Window showingWindow = mgr.getActiveWindow();
                if (showingWindow == null && (getNativeFocusOwner = ReflectionUtil.getDeclaredMethod(KeyboardFocusManager.class, (String)"getNativeFocusOwner", (Class[])new Class[0])) != null) {
                    try {
                        Object owner = getNativeFocusOwner.invoke((Object)mgr, new Object[0]);
                        if (owner instanceof Component) {
                            showingWindow = UIUtil.getWindow((Component)((Component)owner));
                        }
                    }
                    catch (Exception e1) {
                        LOG.debug((Throwable)e1);
                    }
                }
                if (showingWindow != null) {
                    final IdeFocusManager fm = IdeFocusManager.findInstanceByComponent((Component)showingWindow);
                    ExpirableRunnable maybeRequestDefaultFocus = new ExpirableRunnable(){

                        public void run() {
                            if (IdeEventQueue.this.getPopupManager().requestDefaultFocus(false)) {
                                return;
                            }
                            Application app = ApplicationManager.getApplication();
                            if (app != null && app.isActive()) {
                                fm.requestDefaultFocus(false);
                            }
                        }

                        public boolean isExpired() {
                            return !UIUtil.isMeaninglessFocusOwner((Component)mgr.getFocusOwner());
                        }
                    };
                    fm.revalidateFocus(maybeRequestDefaultFocus);
                }
            }
        }
    }

    public static boolean isMouseEventAhead(@Nullable AWTEvent e) {
        IdeEventQueue queue = IdeEventQueue.getInstance();
        return e instanceof MouseEvent || queue.peekEvent(501) != null || queue.peekEvent(502) != null || queue.peekEvent(500) != null;
    }

    private void enterSuspendModeIfNeeded(@NotNull AWTEvent e) {
        if (e instanceof KeyEvent && !this.mySuspendMode && this.shallEnterSuspendMode()) {
            this.enterSuspendMode();
        }
    }

    private boolean shallEnterSuspendMode() {
        return this.peekEvent(200) != null;
    }

    private static boolean processAppActivationEvents(@NotNull AWTEvent e) {
        if (e instanceof WindowEvent) {
            WindowEvent we = (WindowEvent)e;
            ApplicationActivationStateManager.updateState(we);
            IdeEventQueue.storeLastFocusedComponent(we);
        }
        return false;
    }

    private static void storeLastFocusedComponent(@NotNull WindowEvent we) {
        Window eventWindow = we.getWindow();
        if (we.getID() == 206 || we.getID() == 208) {
            Component frame = UIUtil.findUltimateParent((Component)eventWindow);
            Component focusOwnerInDeactivatedWindow = eventWindow.getMostRecentFocusOwner();
            IdeFrame[] allProjectFrames = WindowManager.getInstance().getAllProjectFrames();
            if (focusOwnerInDeactivatedWindow != null) {
                for (IdeFrame ideFrame : allProjectFrames) {
                    IdeFocusManager focusManager;
                    JFrame aFrame = WindowManager.getInstance().getFrame(ideFrame.getProject());
                    if (!aFrame.equals(frame) || !((focusManager = IdeFocusManager.getGlobalInstance()) instanceof FocusManagerImpl)) continue;
                    ((FocusManagerImpl)focusManager).setLastFocusedAtDeactivation(ideFrame, focusOwnerInDeactivatedWindow);
                }
            }
        }
    }

    private void defaultDispatchEvent(@NotNull AWTEvent e) {
        try {
            this.myDispatchingFocusEvent = e instanceof FocusEvent;
            this.maybeReady();
            IdeEventQueue.fixStickyAlt(e);
            super.dispatchEvent(e);
        }
        catch (Throwable t) {
            this.processException(t);
        }
        finally {
            this.myDispatchingFocusEvent = false;
        }
    }

    private static void fixStickyAlt(@NotNull AWTEvent e) {
        if (Registry.is((String)"actionSystem.win.suppressAlt.new")) {
            if (UIUtil.isUnderWindowsLookAndFeel() && e instanceof InputEvent && (((InputEvent)e).getModifiers() & 0x208) != 0 && (!(e instanceof KeyEvent) || ((KeyEvent)e).getKeyCode() != 18)) {
                try {
                    if (FieldHolder.ourStickyAltField != null) {
                        FieldHolder.ourStickyAltField.set(null, true);
                    }
                }
                catch (Exception exception) {
                    LOG.error((Throwable)exception);
                }
            }
        } else if (SystemInfo.isWinXpOrNewer && !SystemInfo.isWinVistaOrNewer && e instanceof KeyEvent && ((KeyEvent)e).getKeyCode() == 18) {
            ((KeyEvent)e).consume();
        }
    }

    public boolean isDispatchingFocusEvent() {
        return this.myDispatchingFocusEvent;
    }

    private static boolean typeAheadDispatchToFocusManager(@NotNull AWTEvent e) {
        KeyEvent event;
        if (e instanceof KeyEvent && !(event = (KeyEvent)e).isConsumed()) {
            IdeFocusManager focusManager = IdeFocusManager.findInstanceByComponent((Component)event.getComponent());
            return focusManager.dispatch(event);
        }
        return false;
    }

    public void flushQueue() {
        AWTEvent event;
        while ((event = this.peekEvent()) != null) {
            try {
                AWTEvent event1 = this.getNextEvent();
                this.dispatchEvent(event1);
                continue;
            }
            catch (Exception e) {
                LOG.error((Throwable)e);
                continue;
            }
            break;
        }
        return;
    }

    public void pumpEventsForHierarchy(Component modalComponent, @NotNull Condition<AWTEvent> exitCondition) {
        AWTEvent event;
        do {
            try {
                Object s;
                event = this.getNextEvent();
                boolean eventOk = true;
                if (event instanceof InputEvent && (s = event.getSource()) instanceof Component) {
                    Component c;
                    Window modalWindow;
                    Window window = modalWindow = modalComponent == null ? null : SwingUtilities.windowForComponent(modalComponent);
                    for (c = (Component)s; c != null && c != modalWindow; c = c.getParent()) {
                    }
                    if (c == null) {
                        eventOk = false;
                        ((InputEvent)event).consume();
                    }
                }
                if (!eventOk) continue;
                this.dispatchEvent(event);
            }
            catch (Throwable e) {
                LOG.error(e);
                event = null;
            }
        } while (!exitCondition.value((Object)event));
    }

    public long getIdleTime() {
        return this.myIdleTime;
    }

    @NotNull
    public IdePopupManager getPopupManager() {
        return this.myPopupManager;
    }

    @NotNull
    public IdeKeyEventDispatcher getKeyEventDispatcher() {
        return this.myKeyEventDispatcher;
    }

    public void blockNextEvents(@NotNull MouseEvent e) {
        this.blockNextEvents(e, BlockMode.COMPLETE);
    }

    public void blockNextEvents(@NotNull MouseEvent e, @NotNull BlockMode blockMode) {
        this.myMouseEventDispatcher.blockNextEvents(e, blockMode);
    }

    public boolean isSuspendMode() {
        return this.mySuspendMode;
    }

    public boolean hasFocusEventsPending() {
        return this.peekEvent(1004) != null || this.peekEvent(1005) != null;
    }

    private boolean isReady() {
        return !this.myKeyboardBusy && this.myKeyEventDispatcher.isReady();
    }

    public void maybeReady() {
        if (this.myReady.isEmpty() || !this.isReady()) {
            return;
        }
        Runnable[] ready = this.myReady.toArray(new Runnable[this.myReady.size()]);
        this.myReady.clear();
        for (Runnable each : ready) {
            each.run();
        }
    }

    public void doWhenReady(@NotNull Runnable runnable2) {
        if (EventQueue.isDispatchThread()) {
            this.myReady.add(runnable2);
            this.maybeReady();
        } else {
            SwingUtilities.invokeLater(() -> {
                this.myReady.add(runnable2);
                this.maybeReady();
            });
        }
    }

    public boolean isPopupActive() {
        return this.myPopupManager.isPopupActive();
    }

    public boolean isInputMethodEnabled() {
        return !SystemInfo.isMac || this.myInputMethodLock == 0;
    }

    public void disableInputMethods(@NotNull Disposable parentDisposable) {
        ++this.myInputMethodLock;
        Disposer.register((Disposable)parentDisposable, () -> --this.myInputMethodLock);
    }

    @Override
    public void postEvent(@NotNull AWTEvent event) {
        this.doPostEvent(event);
    }

    boolean doPostEvent(@NotNull AWTEvent event) {
        for (PostEventHook listener2 : this.myPostEventListeners.getListeners()) {
            if (!listener2.consumePostedEvent(event)) continue;
            return false;
        }
        this.myFrequentEventDetector.eventHappened((Object)event);
        if (IdeEventQueue.isKeyboardEvent(event)) {
            this.myKeyboardEventsPosted.incrementAndGet();
        }
        super.postEvent(event);
        return true;
    }

    private static boolean isKeyboardEvent(@NotNull AWTEvent event) {
        return event instanceof KeyEvent;
    }

    @Override
    public AWTEvent peekEvent() {
        AWTEvent event = super.peekEvent();
        if (event != null) {
            return event;
        }
        if (this.isTestMode() && LaterInvocator.ensureFlushRequested()) {
            return super.peekEvent();
        }
        return null;
    }

    private boolean isTestMode() {
        Boolean testMode = this.myTestMode;
        if (testMode != null) {
            return testMode;
        }
        Application application = ApplicationManager.getApplication();
        if (application == null) {
            return false;
        }
        this.myTestMode = testMode = Boolean.valueOf(application.isUnitTestMode());
        return testMode;
    }

    public void addPostEventListener(@NotNull PostEventHook listener2, @NotNull Disposable parentDisposable) {
        this.myPostEventListeners.addListener((EventListener)listener2, parentDisposable);
    }

    public static void unsafeNonblockingExecute(Runnable r) {
        assert (EventQueue.isDispatchThread());
        if (unsafeNonBlockingExecuteRef == null) {
            unsafeNonBlockingExecuteRef = Ref.create((Object)ReflectionUtil.getDeclaredMethod(SunToolkit.class, (String)"unsafeNonblockingExecute", (Class[])new Class[]{Runnable.class}));
        }
        if (unsafeNonBlockingExecuteRef.get() != null) {
            try {
                ((Method)unsafeNonBlockingExecuteRef.get()).invoke((Object)Toolkit.getDefaultToolkit(), r);
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        r.run();
    }

    @FunctionalInterface
    public static interface PostEventHook
    extends EventListener {
        public boolean consumePostedEvent(@NotNull AWTEvent var1);
    }

    public static enum BlockMode {
        COMPLETE,
        ACTIONS;

    }

    private static class EditingCanceller
    implements EventDispatcher {
        private EditingCanceller() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            if (e instanceof KeyEvent && e.getID() == 401 && ((KeyEvent)e).getKeyCode() == 27) {
                Component owner = UIUtil.findParentByCondition((Component)KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), component -> component instanceof JTable || component instanceof JTree);
                if (owner instanceof JTable && ((JTable)owner).isEditing()) {
                    ((JTable)owner).editingCanceled(null);
                    return true;
                }
                if (owner instanceof JTree && ((JTree)owner).isEditing()) {
                    ((JTree)owner).cancelEditing();
                    return true;
                }
            }
            return false;
        }
    }

    private static class WindowsAltSuppressor
    implements EventDispatcher {
        private boolean myWaitingForAltRelease;
        private Robot myRobot;

        private WindowsAltSuppressor() {
        }

        @Override
        public boolean dispatch(@NotNull AWTEvent e) {
            boolean dispatch = true;
            if (e instanceof KeyEvent) {
                boolean pureAlt;
                KeyEvent ke = (KeyEvent)e;
                Component component = ke.getComponent();
                boolean bl = pureAlt = ke.getKeyCode() == 18 && (ke.getModifiers() | 8) == 8;
                if (!pureAlt) {
                    this.myWaitingForAltRelease = false;
                } else {
                    UISettings uiSettings = UISettings.getInstanceOrNull();
                    if (uiSettings == null || !SystemInfo.isWindows || !Registry.is((String)"actionSystem.win.suppressAlt") || !uiSettings.getHideToolStripes() && !uiSettings.getPresentationMode()) {
                        return false;
                    }
                    if (ke.getID() == 401) {
                        dispatch = !this.myWaitingForAltRelease;
                    } else if (ke.getID() == 402) {
                        if (this.myWaitingForAltRelease) {
                            this.myWaitingForAltRelease = false;
                            dispatch = false;
                        } else if (component != null) {
                            SwingUtilities.invokeLater(() -> {
                                try {
                                    Window window = UIUtil.getWindow((Component)component);
                                    if (window == null || !window.isActive()) {
                                        return;
                                    }
                                    this.myWaitingForAltRelease = true;
                                    if (this.myRobot == null) {
                                        this.myRobot = new Robot();
                                    }
                                    this.myRobot.keyPress(18);
                                    this.myRobot.keyRelease(18);
                                }
                                catch (AWTException e1) {
                                    LOG.debug((Throwable)e1);
                                }
                            });
                        }
                    }
                }
            }
            return !dispatch;
        }
    }

    private final class ExitSuspendModeRunnable
    implements Runnable {
        private ExitSuspendModeRunnable() {
        }

        @Override
        public void run() {
            if (IdeEventQueue.this.mySuspendMode) {
                IdeEventQueue.this.exitSuspendMode();
            }
        }
    }

    private final class MyFireIdleRequest
    implements Runnable {
        private final Runnable myRunnable;
        private final int myTimeout;

        MyFireIdleRequest(Runnable runnable2, int timeout) {
            this.myTimeout = timeout;
            this.myRunnable = runnable2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.myRunnable.run();
            Object object = IdeEventQueue.this.myLock;
            synchronized (object) {
                if (IdeEventQueue.this.myIdleListeners.contains(this.myRunnable)) {
                    IdeEventQueue.this.myIdleRequestsAlarm.addRequest((Runnable)this, this.myTimeout, ModalityState.NON_MODAL);
                }
            }
        }

        public int getTimeout() {
            return this.myTimeout;
        }

        public String toString() {
            return "Fire idle request. delay: " + this.getTimeout() + "; runnable: " + this.myRunnable;
        }
    }

    @FunctionalInterface
    public static interface EventDispatcher {
        public boolean dispatch(@NotNull AWTEvent var1);
    }

    private static class FieldHolder {
        private static final Field ourStickyAltField;

        private FieldHolder() {
        }

        static {
            Field field;
            try {
                Class<?> aClass = Class.forName("com.sun.java.swing.plaf.windows.WindowsRootPaneUI$AltProcessor");
                field = ReflectionUtil.getDeclaredField(aClass, (String)"menuCanceledOnPress");
            }
            catch (Exception e) {
                field = null;
            }
            ourStickyAltField = field;
        }
    }

    private static class IdeEventQueueHolder {
        private static final IdeEventQueue INSTANCE = new IdeEventQueue();

        private IdeEventQueueHolder() {
        }
    }
}

