/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.platform.ProjectBaseDirectory;
import com.intellij.util.messages.MessageBus;
import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="RecentDirectoryProjectsManager", storages={@Storage(value="recentProjectDirectories.xml", roamingType=RoamingType.DISABLED), @Storage(value="other.xml", deprecated=true)})
public class RecentDirectoryProjectsManager
extends RecentProjectsManagerBase {
    public RecentDirectoryProjectsManager(MessageBus messageBus) {
        super(messageBus);
    }

    @Override
    @Nullable
    protected String getProjectPath(@NotNull Project project2) {
        ProjectBaseDirectory baseDir = ProjectBaseDirectory.getInstance(project2);
        VirtualFile baseDirVFile = baseDir.getBaseDir() != null ? baseDir.getBaseDir() : project2.getBaseDir();
        return baseDirVFile != null ? FileUtil.toSystemDependentName((String)baseDirVFile.getPath()) : null;
    }

    @Override
    protected void doOpenProject(@NotNull String projectPath, Project projectToClose, boolean forceOpenInNewFrame) {
        VirtualFile projectDir = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)projectPath));
        if (projectDir != null) {
            EnumSet<PlatformProjectOpenProcessor.Option> options = EnumSet.of(PlatformProjectOpenProcessor.Option.REOPEN);
            if (forceOpenInNewFrame) {
                options.add(PlatformProjectOpenProcessor.Option.FORCE_NEW_FRAME);
            }
            PlatformProjectOpenProcessor.doOpenProject(projectDir, projectToClose, -1, null, options);
        }
    }
}

