/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.RecentProjectsManagerBase;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.PlatformProjectOpenProcessor;
import com.intellij.util.messages.MessageBus;
import java.io.File;
import org.jetbrains.annotations.NotNull;

@State(name="RecentProjectsManager", storages={@Storage(value="recentProjects.xml", roamingType=RoamingType.DISABLED), @Storage(value="other.xml", deprecated=true)})
public class RecentProjectsManagerImpl
extends RecentProjectsManagerBase {
    public RecentProjectsManagerImpl(MessageBus messageBus) {
        super(messageBus);
    }

    @Override
    protected String getProjectPath(@NotNull Project project2) {
        return project2.getPresentableUrl();
    }

    @Override
    protected void doOpenProject(@NotNull String projectPath, Project projectToClose, boolean forceOpenInNewFrame) {
        File projectFile = new File(projectPath);
        if (projectFile.isDirectory() && !new File(projectFile, ".idea").exists()) {
            VirtualFile projectDir = LocalFileSystem.getInstance().findFileByIoFile(projectFile);
            PlatformProjectOpenProcessor processor2 = PlatformProjectOpenProcessor.getInstanceIfItExists();
            if (projectDir != null && processor2 != null) {
                processor2.doOpenProject(projectDir, projectToClose, forceOpenInNewFrame);
                return;
            }
        }
        ProjectUtil.openProject(projectPath, projectToClose, forceOpenInNewFrame);
    }
}

